@extends('web.layouts.container')
@section('content')
    <section class="page-heading">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}">{{__('main.home')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page"> {{__('reservations.hall_reservation')}} </li>
                </ol>
                <h3>{{__('reservations.hall_reservation')}}</h3>
            </nav>
        </div>
        <img src="{{asset('assets/web/images/page-heading-1.png')}}" alt="" class="pattern1">
        <img src="{{asset('assets/web/images/page-heading-2.png')}}" alt="" class="pattern2">
        <img src="{{asset('assets/web/images/page-heading-3.png')}}" alt="" class="pattern3">
    </section>

    <section class="hall-det reservation_det reservation-pg">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 m-auto">
                    <div class="reservation_item ">
                        <div class="form-wrapper">
                            <form action="{{route('reservation.addReservation', $hall)}}" method="post" class="add_reservation_form">
                                <div class="row">
                                    <div class="{{$hall->reservation_type == 'days_count' ? 'col-md-12' : 'col-md-6'}}">
                                        <div class="form-group">
                                            <select name="occasion_id" class="form-control" autocomplete="off" autofocus required>
                                                @if(count($occasions))
                                                    @foreach($occasions as $occasion)
                                                        <option value="{{$occasion->id}}">{{$occasion->name}}</option>
                                                    @endforeach
                                                @endif
                                            </select>
                                            <label class="floating-label">{{__('reservations.select_your_occasion')}}</label>
                                        </div>
                                    </div>
                                    @if($hall->reservation_type == 'person_count')
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <input name="person_count" type="number" min="{{$hall->min_capacity}}" max="{{$hall->total_capacity}}" pattern="[1-9]+" class="form-control" autocomplete="off" autofocus required />
                                                <label class="floating-label">{{__('reservations.person_count')}}</label>
                                                <span class="text-danger"><span>{{__('reservations.hall_reservation_hint_1')}} </span> <b>({{$hall->min_capacity}}</b><b> {{__('reservations.person')}}) </b></span><br>
                                                <span class="text-danger"><span>{{__('reservations.hall_reservation_hint_2')}} </span> <b>({{$hall->total_capacity}}</b><b> {{__('reservations.person')}}) </b></span>
                                                <br><small class="text-danger">{{__('reservations.hall_reservation_hint_3')}}</small>
                                            </div>
                                        </div>
                                    @endif
                                    {{-- Appended reservation days section --}}
                                    <div class="reservation col-12">
                                        <div class="days_content text-center">
                                            <!-- Button trigger modal -->
                                            <a href="#0" class="butn" data-toggle="modal" data-target="#reservation_tab">{{__('reservations.select_reservation_date')}}  </a>
                                            <ul class="content text-left reserved_days_container"></ul>
                                        </div>

                                        <!-- available days Modal -->
                                        <div class="modal fade reservation_tab" id="reservation_tab" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-body">
                                                        <div class="sec-heading">
                                                            <span class="icon"><img src="{{asset('assets/web/images/sec-heading-1.png')}}" alt=""></span>
                                                            <h3>{{__('reservations.select_reservation_date')}}</h3>
                                                        </div>
                                                        <div class="year_month">
                                                            <div class="row">
                                                                <div class="col-lg-6">
                                                                    <h6> {{__('reservations.select_year')}}</h6>
                                                                    <select class="custom-select select_year select_year_month">
                                                                        @if(count($years))
                                                                            {{--                                                                            <option>{{__('reservations.select_year')}}</option>--}}
                                                                            @foreach($years as $year)
                                                                                <option data-year-month="{{$year}}" data-year=".{{$year}}" value="{{$year}}">{{$year}}</option>
                                                                            @endforeach
                                                                        @else
                                                                            <option value="">{{__('reservations.select_year')}}</option>
                                                                        @endif
                                                                    </select>
                                                                </div>
                                                                <div class="col-lg-6">
                                                                    <h6>{{__('reservations.select_month')}}</h6>
                                                                    <select class="custom-select select_month select_year_month">
                                                                        @if(count($months))
                                                                            {{--                                                                            <option value="">{{__('reservations.select_month')}}</option>--}}
                                                                            @foreach($months as $monthNumber => $month)
                                                                                <option class="{{explode('_', $monthNumber)[1]}}" data-month=".{{$month}}" value="{{$month}}">{{__('reservations.'.$month)}}</option>
                                                                            @endforeach
                                                                        @else
                                                                            <option value="">{{__('reservations.select_month')}}</option>
                                                                        @endif
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="reservation_content">
                                                            @if(count($availableDates))
                                                                @foreach($availableDates as $date => $percentage)
                                                                    <div class="items hidden_item {{date('M', strtotime($date))}} {{date('Y', strtotime($date))}}">
                                                                        <div class="custom-control custom-checkbox">
                                                                            <input type="checkbox" class="custom-control-input" id="customCheck_{{$loop->iteration}}" name="re_days[]" value="{{$date}}">
                                                                            <label class="custom-control-label" for="customCheck_{{$loop->iteration}}">
                                                                                <span class="day">{{date('d', strtotime($date))}}</span>
                                                                                <span class="month">{{__('reservations.'.date('M', strtotime($date)))}}</span>
                                                                                <span class="year">{{date('Y', strtotime($date))}}</span>
                                                                                @if($sessionDiscountPercentage ?? $discountPercentage[$date] ?? $percentage)
                                                                                    <small class="discount_cont">
                                                                                        {{__('reservations.discount')}} {{$sessionDiscountPercentage ?? $discountPercentage[$date] ?? $percentage}}%
                                                                                    </small>
                                                                                @endif
                                                                            </label>
                                                                        </div>
                                                                    </div>
                                                                @endforeach
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer justify-content-center">
                                                        <button type="button" class="butn btn-secondary" data-dismiss="modal">{{__('members.close')}}</button>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <h5 class="col-lg-12">{{__('reservations.other_details_question')}}</h5>
                                    <div class="col-lg-1">
                                        <input name="is_other_details" type="radio" id="other_details_yes" value="yes">
                                        <label for="other_details_yes"><h6>{{__('reservations.yes')}}</h6></label>
                                    </div>
                                    <div class="col-lg-1">
                                        <input checked name="is_other_details" type="radio" id="other_details_no" value="no">
                                        <label for="other_details_no"><h6>{{__('reservations.no')}}</h6></label>
                                    </div>
                                    <div class="col-md-12 other_details_container d-none">
                                        <label for="other_details">{{__('reservations.other_details')}}</label>
                                        <textarea readonly name="other_details" id="other_details" class="form-control" cols="30" rows="10"></textarea>
                                    </div>

                                    <button class="submit-butn mt-5 add_reservation_button">   {{__('reservations.finish_reservation')}} </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- ---------------- new bill table --------------- -->
{{--        <div class="container">--}}
{{--            <h5 class="headline mt-5 mb-4"> تفاصيل الحجز </h5>--}}
{{--            <div class="table-responsive">--}}
{{--                <table class="table bill_table">--}}
{{--                    <thead>--}}
{{--                      <tr>--}}
{{--                        <th scope="col" class="day_back_dark">الوصف</th>--}}
{{--                        <th scope="col" class="day_back_dark">الكمية</th>--}}
{{--                        <th scope="col" class="day_back_dark">سعر الوحدة</th>--}}
{{--                        <th scope="col" class="day_back_dark"> الأجمالى </th>--}}
{{--                        <th scope="col" class="day_back_dark"> الخصم </th>--}}
{{--                        <th scope="col" class="day_back_dark"> صافي المبلغ </th>--}}
{{--                      </tr>--}}
{{--                    </thead>--}}
{{--                    <tbody>--}}
{{--                        <!-- -------- day 1 -------- -->--}}
{{--                      <tr class="day_back">--}}
{{--                        <th scope="row" class="day_back">--}}
{{--                            <span class=""> يوم السبت الموافق (30 / 4 / 2022) </span>--}}
{{--                        </th>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            100 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            100 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            10 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            90 ريال--}}
{{--                        </td>--}}
{{--                      </tr>--}}
{{--                      <tr class="day_color1">--}}
{{--                        <th scope="row">--}}
{{--                            <span class=""> الخدمات المعتمدة من ميتات </span>--}}
{{--                        </th>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                      </tr>--}}
{{--                      <tr class="day_color1">--}}
{{--                        <th scope="row">--}}
{{--                            <span> مياة غازية </span>--}}
{{--                        </th>--}}
{{--                        <td>--}}
{{--                            200--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            10 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            2000 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            2 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            1600 ريال--}}
{{--                        </td>--}}
{{--                      </tr>--}}
{{--                      <tr class="day_color1">--}}
{{--                        <th scope="row">--}}
{{--                            <span> ورود </span>--}}
{{--                        </th>--}}
{{--                        <td>--}}
{{--                            20--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            20 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            400 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            5 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            350 ريال--}}
{{--                        </td>--}}
{{--                      </tr>--}}

{{--                      <tr class="day_color1">--}}
{{--                        <th scope="row">--}}
{{--                            <span> الخدمات الأضافية </span>--}}
{{--                        </th>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                      </tr>--}}

{{--                      <tr class="day_color1">--}}
{{--                        <th scope="row">--}}
{{--                            <span> مشروبات ساخنة </span>--}}
{{--                        </th>--}}
{{--                        <td>--}}
{{--                            10--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            30 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            300 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            2 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            240 ريال--}}
{{--                        </td>--}}
{{--                      </tr>--}}

{{--                       <!-- -------- day 2 -------- -->--}}
{{--                       <tr class="day_back">--}}
{{--                        <th scope="row" class="day_back">--}}
{{--                            <span class=""> يوم الحد الموافق (31 / 4 / 2022) </span>--}}
{{--                        </th>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            100 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            100 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            10 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            90 ريال--}}
{{--                        </td>--}}
{{--                      </tr>--}}
{{--                      <tr class="day_color1">--}}
{{--                        <th scope="row">--}}
{{--                            <span class=""> الخدمات المعتمدة من ميتات </span>--}}
{{--                        </th>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                      </tr>--}}
{{--                      <tr class="day_color1">--}}
{{--                        <th scope="row">--}}
{{--                            <span> مياة غازية </span>--}}
{{--                        </th>--}}
{{--                        <td>--}}
{{--                            200--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            10 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            2000 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            2 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            1600 ريال--}}
{{--                        </td>--}}
{{--                      </tr>--}}
{{--                      <tr class="day_color1">--}}
{{--                        <th scope="row">--}}
{{--                            <span> ورود </span>--}}
{{--                        </th>--}}
{{--                        <td>--}}
{{--                            20--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            20 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            400 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            5 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            350 ريال--}}
{{--                        </td>--}}
{{--                      </tr>--}}

{{--                      <!-- ----------- day 3 ----------- -->--}}
{{--                      <tr class="day_back">--}}
{{--                        <th scope="row" class="day_back">--}}
{{--                            <span class=""> يوم الأثنين الموافق (1 / 5 / 2022) </span>--}}
{{--                        </th>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            100 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            100 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            10 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            90 ريال--}}
{{--                        </td>--}}
{{--                      </tr>--}}

{{--                      <tr class="day_color1">--}}
{{--                        <th scope="row">--}}
{{--                            <span class=""> الخدمات المعتمدة من ميتات </span>--}}
{{--                        </th>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                      </tr>--}}
{{--                      <tr class="day_color1">--}}
{{--                        <th scope="row">--}}
{{--                            <span> مياة غازية </span>--}}
{{--                        </th>--}}
{{--                        <td>--}}
{{--                            200--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            10 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            2000 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            2 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            1600 ريال--}}
{{--                        </td>--}}
{{--                      </tr>--}}

{{--                      <!-- ----------- day 4 ----------- -->--}}
{{--                      <tr class="day_back">--}}
{{--                        <th scope="row" class="day_back">--}}
{{--                            <span class=""> يوم الأثنين الموافق (1 / 5 / 2022) </span>--}}
{{--                        </th>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            100 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            100 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            10 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            90 ريال--}}
{{--                        </td>--}}
{{--                      </tr>--}}

{{--                      <tr class="day_color1">--}}
{{--                        <th scope="row">--}}
{{--                            <span> الخدمات الأضافية </span>--}}
{{--                        </th>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                        </td>--}}
{{--                      </tr>--}}

{{--                      <tr class="day_color1">--}}
{{--                        <th scope="row">--}}
{{--                            <span> مشروبات ساخنة </span>--}}
{{--                        </th>--}}
{{--                        <td>--}}
{{--                            10--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            30 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            300 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            2 ريال--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            240 ريال--}}
{{--                        </td>--}}
{{--                      </tr>--}}


{{--                      <tr>--}}
{{--                        <th scope="row" class="day_back_dark">--}}
{{--                            <span>السعر قبل الضريبة</span>--}}
{{--                        </th>--}}
{{--                        <td colspan="4">--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            390 ريال--}}
{{--                        </td>--}}
{{--                      </tr>--}}
{{--                      <tr>--}}
{{--                        <th scope="row" class="day_back_dark">--}}
{{--                            <span>ضريبة القيمة المضافة</span>--}}
{{--                        </th>--}}
{{--                        <td colspan="4">--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            15%--}}
{{--                        </td>--}}
{{--                      </tr>--}}
{{--                      <tr>--}}
{{--                        <th scope="row" class="day_back_dark">--}}
{{--                            <span>الاجمالى بعد الضريبة</span>--}}
{{--                        </th>--}}
{{--                        <td colspan="4">--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            450 ريال--}}
{{--                        </td>--}}
{{--                      </tr>--}}
{{--                      <tr>--}}
{{--                        <th scope="row" class="day_back_dark">--}}
{{--                            <span>نسبة ربح المنصة</span>--}}
{{--                        </th>--}}
{{--                        <td colspan="4">--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            10%--}}
{{--                        </td>--}}
{{--                      </tr>--}}
{{--                    </tbody>--}}
{{--                  </table>--}}
{{--              </div>--}}
{{--        </div>--}}

      <!-- selectServicesModal Modal -->
  <div class="modal fade selectServicesModal" id="selectServicesModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLongTitle">أختر الخدمات الخاصة باليوم </h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
            <form action="{{route('reservation.saveSelectedServices', $hall)}}" method="post" class="save_selected_services_form">
                <input type="hidden" name="selected_day">
                <div class="reservation mt-4">
                    <h5 class="headline mb-4"> {{__('halls.approved_services')}} <b class="dir-l">{{__('halls.meet')}}</b></h5>
                    <div class="select-services">
                        <div class="row">
                            @if(count($services))
                                @foreach($services as $service)
                                    <div class="col-md-6 col-lg-4">
                                        <div class="select_card w-100">
                                            <input data-quantity=".service_quantity_{{$loop->iteration}}"  type="checkbox" class="card-input approved_services" id="service_{{$service->id}}" value="{{$service->id}}">
                                            <label class="label w-100" for="service_{{$service->id}}">
                                                <div class="serv_card">
                                                    <div class="img-box">
                                                        <img src="{{asset($service->image)}}" alt="" class="serv-img">
                                                    </div>
                                                    <div class="card-body">
                                                        <h6 class="title"><b>{{$service->name}}</b></h6>
                                                        <p class="p">{{$service->name}}</p>
                                                        <h4 class="price dir-l mb-0"><b>{{$service->price}}</b> <small>{{__('main.sar')}}</small></h4>

                                                    </div>
                                                </div>
                                            </label>
                                            <div class="form-group number-group">
                                                <label for="service_quantity_{{$loop->iteration}}">{{__('reservations.quantity')}}</label>
                                                <input id="service_quantity_{{$loop->iteration}}" type="text" class="service_quantity service_quantity_{{$loop->iteration}}" placeholder="0">
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            @endif

                        </div>
                    </div>
                </div>
                <div class="reservation mt-5">
                    <h5 class="headline mb-4">{{__('halls.added_services')}}</h5>
                    <div class="select-services">
                        <div class="row">
                            @if(count($addedServices))
                                @foreach($addedServices as $addedService)
                                    <div class="col-md-6 col-lg-4">
                                        <div class="select_card w-100">
                                            <input data-quantity=".added_service_quantity_{{$addedService['id']}}"  type="checkbox" class="card-input added_services" id="additional-service-{{$addedService['id']}}" value="{{$addedService['id']}}">
                                            <label class="label w-100" for="additional-service-{{$addedService['id']}}">
                                                <div class="serv_card">
                                                    <div class="img-box">
                                                        <img src="{{asset($addedService['image'])}}" alt="" class="serv-img">
                                                    </div>
                                                    <div class="card-body">
                                                        <h6 class="title"><b>{{$addedService['name']}}</b></h6>
                                                        <p class="p">{{$addedService['name']}}</p>
                                                        <h4 class="price dir-l mb-0"><b>{{$addedService['price']}}</b> <small>{{__('main.sar')}}</small></h4>
                                                    </div>
                                                </div>
                                            </label>
                                            <div class="form-group number-group">
                                                <label for="added_service_quantity_{{$loop->iteration}}">{{__('reservations.quantity')}}</label>
                                                <input id="added_service_quantity_{{$loop->iteration}}" type="text" class="added_service_quantity added_service_quantity_{{$addedService['id']}}" placeholder="0">
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="modal-footer">
          <button type="button" class="butn main-butn save_selected_services_button">{{__('reservations.save')}}</button>
        </div>
      </div>
    </div>
  </div>

@endsection

@section('inner_js')
    <script>

        let selectServiceTitle = "{{__('reservations.select_services')}}";

        $('input[name="is_other_details"]').click(function () {
            if($(this).val() === 'yes'){
                $('textarea[name="other_details"]').prop('readonly', false)
            }
            if($(this).val() === 'no'){
                $('textarea[name="other_details"]').val(null).prop('readonly', true)
            }
        });

        $(document).ready(function () {
            $('.select_year_month').trigger('change')
        });
        $('.select_year_month').change(function () {
            // $('.reserved_days_container').html('');
            // $('.hidden_item input[type="checkbox"]').prop('checked', false);
            let year = $('.select_year option:selected').data('year'),
                month = $('.select_month option:selected').data('month');
            if (year !== undefined){
                $('.hidden_item').addClass('d-none');
                $(year).removeClass('d-none');
            }
            if (month !== undefined){
                $('.hidden_item').addClass('d-none');
                $(month).removeClass('d-none');
            }
            if (year === undefined && month === undefined){
                $('.hidden_item').removeClass('d-none');
            }
            if (year !== undefined && month !== undefined){
                $('.hidden_item').addClass('d-none');
                $(month+year).removeClass('d-none');
            }
        });

        $('.select_year').change(function () {
            let selectedYear = $(this).children('option:selected').data('year-month');
            $('.select_month option').each(function () {
                if(!$(this).hasClass(selectedYear)){
                    $(this).addClass('d-none');
                    $(this).attr('selected', false)
                } else {
                    $(this).removeClass('d-none');
                }

                if(selectedYear === undefined){
                    $(this).removeClass('d-none')
                }
            })

        });

        let services = [],
            addedServices = [];
        $('.add_reservation_button').click(async function (e) {
            e.preventDefault();

            // $(this).prop('disabled', true);

            let form = $('.add_reservation_form');

            let data = new FormData(form[0]),
                url = form.attr('action'),
                method = form.attr('method');
            services ? data.append('services', JSON.stringify(services)) : [];
            addedServices ? data.append('added_services', JSON.stringify(addedServices)) : [];

            // $('.added_services').each(function () {
            //     if($(this).prop('checked') === true){
            //         data.append('added_services[]', $(this).val());
            //     }
            //     if($(this).prop('checked') === false){
            //         data.append('added_services[]', null);
            //     }
            // });

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method,
                contentType: false,
                processData: false,
            });

            if (response.errors) {
                $(this).prop('disabled', false);
                toasterError(response.errors);
            }
            if (response.url) {
                window.location.href = response.url;
            }
        });

        // When click on available days for hotel
        $('input[name="re_days[]"]').click(function () {
            let itemClass = $(this).attr('id');
            if ($(this).prop('checked') === true){
                let appendContent = '',
                    month = $(this).siblings('label').children('.month'),
                    day = $(this).siblings('label').children('.day'),
                    year = $(this).siblings('label').children('.year'),
                    discount = $(this).siblings('label').children('.discount_cont'),
                    dateValue = $(this).val();

                let isDiscount = discount.length ? discount.html() : '';

                appendContent = day.html() + ' ' + ' ' + month.html() + ' ' + year.html();

                $('.reserved_days_container').append(`
                    <li class="${itemClass}">
                        <div class="cont text-center">${appendContent}</div>
                        <span>${isDiscount}</span>
                        <button data-date-value="${dateValue}" type="button" class="butn small rounded-pill py-2 mt-4 mb-0 select_service_modal_button" data-toggle="modal" data-target="#selectServicesModal"> ${selectServiceTitle} </button>
                    </li>
                `);

            } else {
                $('.reserved_days_container .'+itemClass).remove();
            }
        });


        $('.save_selected_services_button').click(async function (e) {
            e.preventDefault();
            // $(this).prop('disabled', true);

            let form = $('.save_selected_services_form');

            let data = new FormData(form[0]),
                url = form.attr('action'),
                method = form.attr('method');

            $('.approved_services').each(function () {
                if($(this).prop('checked') === true){
                    data.append('services[]', $(this).val());
                }
                // if($(this).prop('checked') === false){
                //     data.append('services[]', '');
                // }
            });
            $('.service_quantity').each(function () {
                if($(this).val() !== ''){
                    data.append('services_quantity[]', $(this).val());
                }
                // if($(this).val() === ''){
                //     data.append('services_quantity[]', '');
                // }
            });

            $('.added_services').each(function () {
                if($(this).prop('checked') === true){
                    data.append('added_services[]', $(this).val());
                }
                // if($(this).prop('checked') === false){
                //     data.append('added_services[]', '');
                // }
            });

            $('.added_service_quantity').each(function () {
                if($(this).val() !== ''){
                    data.append('added_services_quantity[]', $(this).val());
                }
                // if($(this).val() === ''){
                //     data.append('added_service_quantity[]', '');
                // }
            });

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method,
                contentType: false,
                processData: false,
            });

            if (response.errors) {
                $(this).prop('disabled', false);
                toasterError(response.errors);
            }
            if (response.message) {
                $(this).prop('disabled', false);
                toasterSuccess(response.message);
                $('.selectServicesModal').modal('hide');
            }

            if(response.services){
                services = [];
                services = response.services;
            }
            if(response.added_services){
                addedServices = [];
                addedServices = response.added_services;
            }

        });

        $(document).on('click', '.select_service_modal_button',function () {
            $('input[name="selected_day"]').val($(this).data('date-value'))
        });

        $('.approved_services, .added_services').click(function () {
            if($(this).prop('checked') === false){
                $($(this).data('quantity')).val('');
                $($(this).data('quantity')).attr('readonly', 'readonly')
            } else{
                $($(this).data('quantity')).removeAttr('readonly');
                $($(this).data('quantity')).val(1);
            }
        });

        $('.selectServicesModal').on('hide.bs.modal', function () {
            $('input[name="selected_day"]').val('');
            $('.save_selected_services_form input[type="checkbox"]').prop('checked', false);
            $('.save_selected_services_form .service_quantity, .added_service_quantity').val('');
        });

        $(function() {
            $('[data-toggle="tooltip"]').tooltip()
        })
    </script>
    
    <script>
        $('#other_details_yes').change(function() {
            $(".other_details_container").removeClass("d-none")
        });
        $('#other_details_no').change(function() {
            $(".other_details_container").addClass("d-none")
        });
    </script>
@endsection

