<!DOCTYPE html>

<html dir="rtl">

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="" />
    <meta name="keywords" content="" />
    <meta name="author" content="Hossam H-Coder7" />
    <link rel="shortcut icon" href="img/favicon.ico" title="Favicon" sizes="16x16" />

    <title> Meet Mail </title>

    <style>
        * {
            box-sizing: border-box;
        }

        body {
            margin: 0;
            box-sizing: border-box;
        }

        img,
        span,
        small,
        a {
            display: inline-block;
            text-decoration: none;
        }

        .text-center {
            text-align: center;
        }

        .text-left {
            text-align: left;
        }

        .text-right {
            text-align: right;
        }

        .m_0 {
            margin: 0 !important;
        }

        .mt_0 {
            margin-top: 0 !important;
        }

        .mb_0 {
            margin-bottom: 0 !important;
        }

        .mb_2 {
            margin-bottom: 20px !important;
        }

        .mt_3 {
            margin-top: 30px !important;
        }

        .mt_8 {
            margin-top: 80px !important;
        }

        .main_color {
            color: #25B0A8;
        }

        .mail_meet {
            /* background-color: #fafafa; */
        }

        .container {
            margin: 3vw;
            padding: 3vw 6vw;
            position: relative;
            min-width: calc(100% - 6vw);
            min-height: 600px;
            font-family: 'Almarai', sans-serif;
            background-color: #fff;
            border: 1px solid #25B0A8;
            outline: 1px solid #999;
            outline-offset: 10px;
        }

        .content .top_inf {
            display: flex;
            margin-top: 50px;
            align-items: center;
            flex-wrap: wrap;
        }

        .content .top_inf .r_side {
            width: 70%;
        }

        .content .top_inf .l_side {
            width: 30%;
            text-align: center;
        }

        .logo img {
            width: 175px;
        }

        .content .top_inf h6 {
            font-weight: bold;
            font-size: 30px;
            color: #404949;
            margin: 15px 0;
        }

        .content .top_inf p {
            font-size: 25px;
            color: #312482;
            margin: 20px 0;
        }

        .content .top_inf .date {
            font-size: 25px;
            color: #061624;
            margin: 15px 0;
            opacity: 0.7;
            font-size: 16px;
            display: flex;
            align-items: center;
        }

        .content .top_inf .date img {
            width: 20px;
            margin: 0 7px;
        }

        .content .top_inf .butn {
            padding: 15px 50px;
            background-color: #44d47c10;
            color: #44d47c;
            font-size: 18px;
            border-radius: 20px;
            font-weight: bold;
        }

        .content .top_inf .price {
            margin-top: 30px;
        }

        .price {
            font-size: 30px;
            color: #312482;
            font-weight: bold;
            direction: ltr;
        }

        .price small {
            font-weight: 100;
            font-size: 20px;
        }

        .user_detials {
            margin-top: 50px;
        }

        .user_detials ul {
            margin: 0;
            padding: 0;
            display: flex;
            flex-wrap: wrap;
            width: 60%;
        }

        .user_detials ul li {
            display: flex;
            align-items: center;
            padding: 0;
            width: 50%;
            margin: 20px 0;
        }

        .user_detials ul li .img {
            width: 70px;
            height: 70px;
            border-radius: 50%;
            margin-left: 15px;
            text-align: center;
        }

        .user_detials ul li .img img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .user_detials ul li .img .icon {
            width: 100%;
            height: 100%;
            object-fit: contain;
            max-width: 30px;
        }

        .user_detials ul li .inf p {
            color: #312482;
            opacity: 0.8;
            font-size: 17px;
            margin: 0 0 10px 0;
        }

        .user_detials ul li .inf h6 {
            color: #312482;
            font-size: 20px;
            margin: 0;
        }

        .user_detials ul li .inf h6 small {
            opacity: 0.7;
            font-size: 15px;
            margin: 0 8px;
        }

        .center_title {
            margin: 50px 0;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 25px;
        }

        .center_title img {
            width: 15px;
        }

        .center_title span {
            margin: 0 8px;
        }

        .center_title a {
            color: #312482;
            font-weight: bold;
        }

        .center_title.bold {
            font-weight: bold;
        }

        .services .ser_content {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
        }

        .services .ser_content .ser_items {
            padding: 50px 30px;
            text-align: center;
            background-color: #F6F7F7;
            border-radius: 12px;
            width: 23%;
            margin: 1%;
        }

        .services .ser_content .ser_items h6 {
            font-size: 21px;
            margin: 0 0 30px 0;
            font-weight: 400;
        }
        /* ---------- responsive ---------- */

        @media screen and (max-width: 991px) {
            .content .top_inf .r_side,
            .content .top_inf .l_side {
                width: 100%;
                /* padding: 15px; */
                text-align: center;
                margin: 20px 0;
            }
            .content .top_inf .date {
                justify-content: center;
            }
            .user_detials ul,
            .user_detials ul li {
                width: 100%;
            }
            .center_title {
                font-size: 18px;
                flex-wrap: wrap;
            }
            .services .ser_content .ser_items {
                width: 100%;
                margin: 15px 0;
            }
        }
    </style>
</head>

<body>
<!--Header-->

<!--End-Header-->
<!--Contents-->
<main class="mail_meet">
    <div class="container">
        <div class="content">
            <div class="logo">
                <img src="{{asset('assets/web/email_icons/logo.png')}}" alt="">
            </div>
            <div class="top_inf">
                <div class="r_side">
                    <h6>{{$data['reservation']->hall_name}}</h6>
                    <p>#{{$data['reservation']->re_no}}</p>
                    <div class="date">
                        <img src="{{asset('assets/web/email_icons/icon_material-date-range.png')}}" alt="">
                        <span>{{date('d M, Y', strtotime($data['reservation']->re_date_from))}}</span>
                    </div>
                </div>
                <div class="l_side">
                        <span class="butn">
                            {{__('reservations.paid')}}
                        </span>
                    <div class="price">
                        <strong>{{$data['reservation']->total}} </strong> <small>{{__('main.sar')}}</small>
                    </div>
                </div>
            </div>
            <div class="user_detials">
                <ul>
                    <li>
                        <div class="img">
                            <img src="{{asset($data['reservation']->provider_photo ?? 'assets/web/email_icons/user.png')}}" alt="">
                        </div>
                        <div class="inf">
                            <p>{{__('reservations.provider_name')}}</p>
                            <h6>{{$data['reservation']->provider_name}}</h6>
                        </div>
                    </li>
                    @if($data['reservation']->person_count)
                        <li>
                            <div class="img">
                                <img class="icon" src="{{asset('assets/web/email_icons/1.png')}}" alt="">
                            </div>
                            <div class="inf">
                                <p>{{__('reservations.person_count')}}</p>
                                <h6> {{$data['reservation']->person_count}} <small>{{__('members.persons')}}</small></h6>
                            </div>
                        </li>
                    @endif

                    <li>
                        <div class="img">
                            <img class="icon" src="{{asset('assets/web/email_icons/2.png')}}" alt="">
                        </div>
                        <div class="inf">
                            <p>{{__('reservations.address')}}</p>
                            <h6> {{$data['reservation']->street}} </h6>
                        </div>
                    </li>
                    <li>
                        <div class="img">
                            <img class="icon" src="{{asset('assets/web/email_icons/3.png')}}" alt="">
                        </div>
                        <div class="inf">
                            <p>{{__('reservations.phone')}}</p>
                            <h6> +966{{$data['reservation']->provider_phone}} </h6>
                        </div>
                    </li>
                    {{--                    <li>--}}
                    {{--                        <div class="img">--}}
                    {{--                            <img class="icon" src="{{asset('assets/web/email_icons/1.png')}}" alt="">--}}
                    {{--                        </div>--}}
                    {{--                        <div class="inf">--}}
                    {{--                            <p>إسم الشخص المسئول</p>--}}
                    {{--                            <h6> {{$data['reservation']->provider_name}} </h6>--}}
                    {{--                        </div>--}}
                    {{--                    </li>--}}
                    <li>
                        <div class="img">
                            <img class="icon" src="{{asset('assets/web/email_icons/1.png')}}" alt="">
                        </div>
                        <div class="inf">
                            <p>{{__('reservations.user_name')}}</p>
                            <h6> {{$data['reservation']->client_name}} </h6>
                        </div>
                    </li>
                </ul>
            </div>
            @if($data['reservation']->booking_amount_per_person)
                <div class="center_title">
                    <span>{{__('halls.booking_amount_per_person')}}</span>
                    <span class="price">
                        <strong>{{$data['reservation']->booking_amount_per_person}} </strong> <small>{{__('main.sar')}}</small>
                    </span>
                    <span>
                    <small>X</small> <img src="{{asset('assets/web/email_icons/1.png')}}" alt=""> <small>{{$data['reservation']->person_count}}</small> {{__('members.persons')}}
                </span>
                </div>
            @endif
            @if($data['reservation']->booking_amount_per_day)
                <div class="center_title">
                    <span>{{__('halls.booking_amount_per_day')}}</span>
                    <span class="price">
                        <strong>{{$data['reservation']->booking_amount_per_day}} </strong> <small>{{__('main.sar')}}</small>
                    </span>
                </div>
            @endif

            <div class="services">
                <div class="center_title">
                    <span>{{__('halls.approved_services')}} </span> <a href="#">{{__('halls.meet')}}</a>
                </div>
                <div class="ser_content">
                    @if(count($data['services']))
                        @foreach($data['services'] as $service)
                            @foreach($service as $oneService)
                                <div class="ser_items">
                                    <h6>{{$oneService['name']}}</h6>
                                    <span class="price">
                                        <strong>{{$oneService['price']}} </strong> <small>{{__('main.sar')}}</small>
                                    </span>
                                </div>
                            @endforeach
                        @endforeach
                    @endif
                </div>
                <div class="center_title">
                    <span>{{__('halls.added_services')}} </span>
                </div>
                <div class="ser_content">
                    @if(count($data['added_service']))
                        @foreach($data['added_service'] as $addedService)
                            @foreach($addedService as $oneAddedService)
                                <div class="ser_items">
                                    <h6>{{$oneAddedService['name']}}</h6>
                                    <span class="price">
                                        <strong>{{$oneAddedService['price']}} </strong> <small>{{__('main.sar')}}</small>
                                    </span>
                                </div>
                            @endforeach
                        @endforeach
                    @endif
                </div>
            </div>
            <div class="center_title bold mt_8">
                <span>{{__('reservations.added_value_amount')}} <strong class="main_color">({{$data['added_value']}} %)</strong> </span>
            </div>
            <div class="price text-center">
                <strong>{{$data['reservation']->added_value_amount}} </strong> <small>{{__('main.sar')}}</small>
            </div>
            <div class="center_title bold mt_8">
                <span> <strong class="main_color">{{__('reservations.total')}}</strong> </span>
            </div>
            <div class="price text-center">
                <strong>{{$data['reservation']->total}} </strong> <small>{{__('main.sar')}}</small>
            </div>
            <div class="qr_card text-center">
                <img src="{{$data['qr_code']}}" alt="" height="125px" width="125px" class="">
            </div>
        </div>
    </div>
</main>
<!--End-Contents-->

</body>

</html>
