@extends('web.layouts.container')

@section('content')
    <section class="page-heading">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}">{{__('main.home')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{__('policies.privacy_policy')}}</li>
                </ol>
                <h3>{{__('policies.privacy_policy')}}</h3>
            </nav>
        </div>
        <img src="{{asset('assets/web/images/page-heading-1.png')}}" alt="" class="pattern1">
        <img src="{{asset('assets/web/images/page-heading-2.png')}}" alt="" class="pattern2">
        <img src="{{asset('assets/web/images/page-heading-3.png')}}" alt="" class="pattern3">
    </section>
    <!--Start content-pg -->
    <section class="content-pg">
        <div class="container">
            <div class="inner">
                <div class="text">
                    <h3>{{__('policies.privacy_policy')}}</h3>
                    <p>{!! $policy->privacy_policy_description !!}</p>
                </div>

            </div>
            <div class="inner">
                <div class="text">
                    <h3>{{__('policies.terms_use')}}</h3>
                    @if(count($lists))
                        @foreach($lists as $list)
                            @if($list == '') @continue @endif
                            <p><i class="fas fa-circle"></i>{{$list}}</p>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </section>
@endsection

@section('inner_js')

@endsection
