@extends('web.layouts.container')
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/toastr.css') }}" />
@endsection
@section('content')
    <section class="register-pg">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-6 pr-0 pl-0">
                    <img src="{{asset('assets/web/images/header-img.png')}}" alt="" class="main-img">
                </div>
                <div class="col-md-6 pr-0 pl-0">
                    <div class="text-box">
                        <h4 class="h4"> إدخال <b> الكود</b></h4>
                        <p class="p">{{__('members.enter_code')}}</p>
                        <h5 class="code-label dir-l">{{session('user_phone')}}</h5>
                        <div class="form-wrapper mt-5">
                            <span class="text-danger font-weight-bold">{{session('verify_code')}}</span>
                            <form method="post" action="{{route('user.verifyCode')}}" class="account_verification_form">
                                <div class="col-md-6 m-auto">
                                    <div class="form-group code-form-group mt-0">
                                        <div class="row mb-4">
                                            <input type="text" name="code[]" maxlength="1" class="form-control code-input">
                                            <input type="text" name="code[]" maxlength="1" class="form-control code-input">
                                            <input type="text" name="code[]" maxlength="1" class="form-control code-input">
                                            <input type="text" name="code[]" maxlength="1" class="form-control code-input">
                                        </div>

                                        <div class="countdown-wrapper text-center">
                                            <p class="countdown-num"><span id="countdown">0:0</span></p>
                                        </div>

                                    </div>
                                </div>
                                <button class="submit-butn account_verification_button">{{__('main.send')}}</button>

                                <a href="#" class="resend-link mt-3 resend_code_link d-none">{{__('members.resend')}}</a>
                            </form>
                        </div>
                    </div>

                </div>
            </div>

        </div>
    </section>

@endsection

@section('inner_js')
    <script src="{{ asset('assets/web/js/lib/toastr.min.js') }}"></script>
    <script>
        let currentLocal = "{{getCurrentLocale()}}";
    </script>

    <script src="{{ asset('assets/web/js/users.code_verification_form.js') }}"></script>

    <script>

        let resendCodeLink = "{{route('user.resendCode')}}";
        $('.resend_code_link').click(async function (e) {
            e.preventDefault();

            let url = $(this).attr('href'),
                method = 'get';

            const response=await ajax({
                url,
                dataType: 'json',
                method,
                contentType: false,
                processData: false,
            });

            if (response.errors) {
                toasterError(response.errors);
            }
            if (response.success) {
                $('.resend_code_link').attr('href', '#').addClass('d-none');
                startTimer(5);
            }

        });


        function startTimer(countDown = null) {
            let countDownElement = $('#countdown'),
                countDownDate = countDown ? countDown : 120,
                interval = setInterval(function () {
                    countDownDate--;
                    let days = Math.floor( countDownDate/(60*60*24) ),
                        hours = Math.floor( (countDownDate/(60*60)) % 24 ),
                        minutes = Math.floor( (countDownDate/60) % 60 ),
                        seconds = Math.floor( (countDownDate) % 60 );
                    countDownElement.html(minutes + ":" + seconds);

                    if (countDownDate === 0) {
                        clearInterval(interval);
                        $('.resend_code_link').removeClass('d-none').attr('href', resendCodeLink);

                    }
                }, 1000);
        }
        startTimer();

    </script>
@endsection
