@if(count($reservations))
    @foreach($reservations as $reservation)
        <div class="reservation_item">
            <div class="row">
                <div class="col-lg-3">
                    <a href="{{route('reservation.reservationDetails',$reservation->id)}}">
                        <img src="{{asset(json_decode($reservation->images)[0])}}" alt="" class="hall-img">
                    </a>
                </div>
                <div class="col-lg-3">
                    <div class="content">
                        <h5 class="name mb-3"><b>{{$reservation->hall_name}}</b></h5>
                        <span class="num">#{{$reservation->re_no}}</span>
                        <p class="data mt-2 "><i class="far fa-calendar-alt"></i>{{date('d/m/Y', strtotime($reservation->re_date_from))}}</p>
                        <p class="data"><i class="far fa-user"></i> {{$reservation->person_count}} أشخاص </p>
                    </div>
                </div>
                <div class="col-lg-3">
                    <h3 class="price center-vr dir-l"><b>{{$reservation->total}}</b> <small>SAR</small></h3>
                </div>
                <div class="col-lg-3">
                    <div class="prof-info">
                        <img src="{{asset($user->photo ?? 'assets/web/images/avatar.png')}}" alt="" class="prof_img">
                        <h6 class="name mb-0">{{$user->name}}</h6>
                    </div>
                    @if($reservation->re_status == 'confirmed') <span class="badge  badge_completed">{{__('reservations.confirmed')}}</span> @endif
                    @if($reservation->re_status == 'unconfirmed') <span class="badge  badge_uncertain">{{__('reservations.unconfirmed')}}</span> @endif
                    @if($reservation->re_status == 'waiting_for_pay') <span class="badge badge_pinding">{{__('reservations.waiting_for_pay')}}</span> @endif
                    @if($reservation->re_status == 'canceled') <span class="badge badge_canceled">{{__('reservations.canceled')}}</span> @endif
                    @if($reservation->re_status == 'finished') <span class="badge badge_expired">{{__('reservations.finished')}}</span> @endif
                    @if($reservation->re_status == 'reject') <span class="badge badge_canceled">{{__('reservations.reject')}}</span> @endif
                    @if($reservation->re_status == 'finished' && !$reservation->is_evaluate)
                        <button data-hall="{{$reservation->hall_id}}" data-reservation="{{$reservation->id}}" data-href="{{route('hallEvaluate')}}" class="rate-butn evaluate_modal_button"  data-toggle="modal" data-target="#rateModal"><i class="fas fa-star"></i> {{__('members.evaluate')}}</button>
                    @endif
                </div>
            </div>
            @if(in_array($reservation->re_status, ['confirmed', 'unconfirmed', 'waiting_approval', 'accept']) && time() < strtotime($reservation->re_date_from))
                <a data-href="{{route('reservation.reservationStatusOperation', $reservation->id)}}" class="deleteButton cancel_reservation_button" type="button" data-toggle="modal" data-target="#confirmationModal">
                    <i class="fas fa-times-circle"></i>
                </a>
            @endif
        </div>

    @endforeach

    @else

    <div class="reservation_item">
        <div class="row">
            <div class="col-lg-12 text-center text-danger">{{__('members.no_data')}}</div>
        </div>
    </div>

@endif
