@extends('web.layouts.container')

@section('content')
    <section class="page-heading">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}">{{__('main.home')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{__('main.new_register')}}</li>
                </ol>
                <h3>{{__('main.new_register')}}</h3>
            </nav>
        </div>
        <img src="{{asset('assets/web/images/page-heading-1.png')}}" alt="" class="pattern1">
        <img src="{{asset('assets/web/images/page-heading-2.png')}}" alt="" class="pattern2">
        <img src="{{asset('assets/web/images/page-heading-3.png')}}" alt="" class="pattern3">
    </section>
    <section class="register-pg">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-6 pr-0 pl-0">
                    <img src="{{asset('assets/web/images/header-img.png')}}" alt="" class="main-img">
                </div>
                <div class="col-md-6 pr-0 pl-0">
                    <div class="text-box center-vr">
                        <h6 class="h6">{{__('main.join_us')}}</h6>
                        <h4 class="h4">{{__('main.create_account')}} <b>{{__('main.new')}}</b></h4>
                        <p class="p">{{__('main.register_hint')}}</p>
                        <div class="form-wrapper  mt-4">
                            <form method="post" action="{{route('user.checkRegisterPhone')}}" class="register_form">
                                <div class="form-group">
                                    <div class="d-flex phone-num-row">
                                        <div class="flex-shrink-0">
                                            <select name="code" class="form-control phone-select search-select">
                                                @if(count($countryCods))
                                                    @foreach($countryCods as $code)
                                                        <option value="{{$code}}"> <img src="https://meet.b.alyomhost.org/assets/web/images/logo-footer.svg" alt="" class="logo"> {{$code}}</option>
                                                    @endforeach
                                                @endif
                                            </select>
                                        </div>
                                        <div class="position-relative w-100">
                                            <input name="phone" type="tel" class="form-control phone-input" autocomplete="off" autofocus required  placeholder="05********" />
                                            <label class="floating-label">{{__('members.phone')}}</label>
                                        </div>

                                    </div>
                                </div>
                                <button class="submit-butn mt-4 register_button" type="submit">{{__('main.sign_up')}}</button>
                                <p class="another_choice mt-4">{{__('main.have_account')}} <a href="{{route('userProvider.login')}}">{{__('main.sign_in')}}</a></p>
                            </form>
                        </div>
                    </div>

                </div>
            </div>

        </div>
    </section>

@endsection

@section('inner_js')
    <script src="{{ asset('assets/web/js/users.register.js') }}"></script>
@endsection
