<tr>
    <th>{{ __('halls.images') }}</th>
    <th>{{ __('halls.name') }}</th>
    <th>{{ __('halls.client_name') }}</th>
    <th>{{ __('halls.client_phone') }}</th>
    <th>{{ __('halls.reservation_date') }}</th>
    <th>{{ __('reservations.person_count') }}</th>
    <th>{{ __('reservations.service') }}</th>
    <th>{{ __('reservations.added_services') }}</th>
    <th>{{ __('reservations.services_amount') }}</th>
    <th>{{ __('reservations.added_services_amount') }}</th>
    <th>{{ __('reservations.added_value_amount') }}</th>
    <th>{{ __('reservations.total') }}</th>
    <th>{{ __('reservations.site_percentage') }}</th>
    <th>{{ __('reservations.net_total') }}</th>
</tr>
@if(count($reservations))
    @foreach($reservations as $reservation)
        <?php
        /** @var TYPE_NAME $reservation */
        $services = ($reservation->services && is_string($reservation->services)) ? json_decode($reservation->services, true) : ($reservation->services ?? []);
        $addedServices = ($reservation->added_services && is_string($reservation->added_services)) ? json_decode($reservation->added_services, true) : ($reservation->added_services ?? []);
        ?>
        <tr>
            <td><a href="{{route('reservation.reservationDetails', $reservation->id)}}"><img src="{{asset(json_decode($reservation->images)[0])}}" alt="" class="hall-img"></a></td>
            <td>{{$reservation->hall_name}}</td>
            <td>{{$reservation->client_name}}</td>
            <td>+{{$reservation->client_phone}}</td>
            <td>{{date('d/m/Y', strtotime($reservation->created_at))}}</td>
            <td>{{$reservation->person_count}}</td>
            <td>
                <ul>
                    @if(count($services))
                        @php
                            /** @var $reservation $reservation */
                            $servicesNames = getServices($services)['names'];
                        @endphp
                        @if(count($servicesNames))
                            @foreach($servicesNames as $servicesName)
                                <li>{{$servicesName}}</li>
                            @endforeach
                        @endif
                    @endif
                </ul>
            </td>
            <td>
                <ul>
                    @if(count($addedServices))
                        @php
                            /** @var $reservation $reservation */
                            $addedServicesNames = getServices($addedServices)['names'];
                        @endphp
                        @if(count($addedServicesNames))
                            @foreach($addedServicesNames as $addedServicesName)
                                <li>{{$addedServicesName}}</li>
                            @endforeach
                        @endif
                    @endif
                </ul>
            </td>
            <td><b>{{getServices($services)['total']}}</b> <small>{{__('main.sar')}}</small></td>
            <td><b>{{getServices($addedServices)['total']}}</b> <small>{{__('main.sar')}}</small></td>
            <td><b>{{ $reservation->added_value_amount }}</b> <small>{{__('main.sar')}}</small></td>
            <td><b>{{ $reservation->total }}</b> <small>{{__('main.sar')}}</small></td>
            <td><b>{{ ($reservation->total*$sitePercentage)/100 }}</b> <small>{{__('main.sar')}}</small></td>
            <td><b>{{ $reservation->total-(($reservation->total*$sitePercentage)/100) }}</b> <small>{{__('main.sar')}}</small></td>

        </tr>
    @endforeach
@else
    <tr><td colspan="20" class="text-center text-danger">{{__('members.no_data')}}</td></tr>
@endif
