@extends('web.layouts.container')
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/toastr.css') }}" />
@endsection
@section('content')
    <section class="page-heading">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}">{{__('main.home')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{__('main.new_register')}}</li>
                </ol>
                <h3>{{__('main.new_register')}}</h3>
            </nav>
        </div>
        <img src="{{asset('assets/web/images/page-heading-1.png')}}" alt="" class="pattern1">
        <img src="{{asset('assets/web/images/page-heading-2.png')}}" alt="" class="pattern2">
        <img src="{{asset('assets/web/images/page-heading-3.png')}}" alt="" class="pattern3">
    </section>
    <section class="register-pg">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-6 pr-0 pl-0">
                    <img src="{{asset('assets/web/images/header-img.png')}}" alt="" class="main-img">
                </div>
                <div class="col-md-6 pr-0 pl-0">
                    <div class="text-box center-vr">
                        <h6 class="h6">{{__('main.join_us')}}</h6>
                        <h4 class="h4">{{__('main.create_account')}} <b>{{__('main.new')}}</b></h4>
                        <p class="p">{{__('main.register_hint')}}</p>
                        <div class="form-wrapper  mt-4">
                            <form method="post" action="{{route('provider.checkRegisterPhone')}}" class="register_form">
                                <div class="form-group">
                                    <div class="d-flex phone-num-row">
                                        <div class="flex-shrink-0">
                                            <select name="code" class="form-control phone-select search-select">
                                                @if(count($countryCods))
                                                    @foreach($countryCods as $code)
                                                        <option value="{{$code}}">{{$code}}</option>
                                                    @endforeach
                                                @endif
                                            </select>
                                        </div>
                                        <div class="position-relative w-100">
                                            <input name="phone" type="tel" class="form-control phone-input text-left" autocomplete="off" autofocus required dir="ltr" placeholder="05********" />
                                            <label class="floating-label">{{__('members.phone')}}</label>
                                        </div>

                                    </div>
                                </div>
                                <button class="submit-butn mt-4 register_button" type="submit">{{__('main.sign_up')}}</button>
                                <p class="another_choice mt-4">{{__('main.have_account')}} <a href="{{route('userProvider.login')}}">{{__('main.sign_in')}}</a></p>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection

@section('inner_js')
    <script src="{{ asset('assets/web/js/lib/toastr.min.js') }}"></script>
    <script src="{{ asset('assets/web/js/users.register.js') }}"></script>
    <script>
        let getCityAndSectorRoute = "{{route('provider.getCityAndSector')}}";
    </script>
    <script>
        $('select[name="region_id"], select[name="city_id"]').change(async function (e) {
            let data = {
                    region_id: $('select[name="region_id"]').val(),
                    city_id: $('select[name="city_id"]').val()
                },
                url = getCityAndSectorRoute,
                method = 'get';

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.cities.length && !response.sectors.length){
                let cities = $('select[name="city_id"]');
                cities.html(`<option value=""> {{__('members.city_id')}} </option>`);
                for(let i = 0; i < response.cities.length; i++){
                    cities.append(`<option value="`+response.cities[i].id+`">`+response.cities[i].name+`</option>`)
                }
            }
            if (response.cities.length && response.sectors.length){
                let sectors = $('select[name="sector_id"]');
                sectors.html(`<option value=""> {{__('members.sector_id')}} </option>`);
                for(let i = 0; i < response.sectors.length; i++){
                    sectors.append(`<option value="`+response.sectors[i].id+`">`+response.sectors[i].name+`</option>`)
                }
            }
        });

        $(document).ready(function() {

            // ------------  File upload BEGIN ------------
            $('input[name="commercial_file"]').on('change', function(event) {
                $('.commercial_file_value').remove();
                var files = event.target.files;
                for (var i = 0; i < files.length; i++) {
                    var file = files[i];
                    $("<div class='commercial_file_value file__value'><div class='commercial_file__value--text'>" + file.name + "</div><div class='commercial_file__value--remove' data-id='commercial_" + file.name + "' ></div></div>").insertAfter('.commercial_file_input');
                }
            });

            $('input[name="logo"]').on('change', function(event) {
                $('.logo_file_value').remove();
                var files = event.target.files;
                for (var i = 0; i < files.length; i++) {
                    var file = files[i];
                    $("<div class='logo_file_value file__value'><div class='logo_file__value--text'>" + file.name + "</div><div class='logo_file__value--remove' data-id='logo_" + file.name + "' ></div></div>").insertAfter('.logo_file_input');
                }
            });


            //Click to remove item
            $('body').on('click', '.commercial_file_value', function() {
                $(this).remove();
                $('input[name="commercial_file"]').val('');
            });

            $('body').on('click', '.logo_file_value', function() {
                $(this).remove();
                $('input[name="logo"]').val('');
            });
            // ------------ File upload END ------------

        });

    </script>
@endsection
