<div class="tab-pane fade active show" id="v-pills-tab1" role="tabpanel" aria-labelledby="v-pills-tab1-tab">
    <div class="tab-wrapper info">
        <nav class="custom-nav">
            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                <a class="nav-link active" id="nav-profile-tab" data-toggle="tab" href="#nav-profile" role="tab" aria-controls="nav-profile" aria-selected="true">{{__('members.my_profile')}}</a>
                <a class="nav-link" id="nav-wallet-tab" data-toggle="tab" href="#nav-wallet" role="tab" aria-controls="nav-wallet" aria-selected="false">{{__('members.wallet')}}</a>
            </div>
        </nav>
        <div class="tab-content" id="nav-tabContent">
            <div class="tab-pane fade show active" id="nav-profile" role="tabpanel" aria-labelledby="nav-profile-tab">
                <div class="col-lg-9 m-auto">
                    <img src="{{asset($user->logo)}}" class="profile-pic" alt="">
                    <div class="item mt-5">
                        <h6 class="h6">{{__('members.name')}}</h6>
                        <p class="data">{{$user->name}}</p>
                    </div>
                    <div class="item">
                        <h6 class="h6">{{__('members.email')}}</h6>
                        <p class="data">{{$user->email}}</p>
                    </div>
                    <div class="item">
                        <h6 class="h6"> {{__('members.commercial_file')}} </h6>
                        <a href="{{asset($user->commercial_file)}}" data-fancybox="images">
                            <p class="data"><img src="{{asset($user->commercial_file)}}" class="commercial-img" alt=""><p>
                        </a>
                    </div>
                    <div class="item">
                        <h6 class="h6"> {{__('members.password')}} </h6>
                        <p class="data">*** *** ***</p>
                    </div>
                    <h4 class="title_banking mb-4 mt-5">{{__('members.bank_account_info')}}</h4>
                    <div class="item">
                        <h6 class="h6">{{__('members.bank_name')}} </h6>
                        <p class="data">{{$user->bank_acc_info['bank_name'] ?? null}}</p>
                    </div>
                    <div class="item">
                        <h6 class="h6">{{__('members.iban')}} </h6>
                        <p class="data">{{$user->bank_acc_info['iban'] ?? null}}</p>
                    </div>
                    <div class="item">
                        <h6 class="h6">{{__('members.client_name')}} </h6>
                        <p class="data">{{$user->bank_acc_info['client_name'] ?? null}} </p>
                    </div>
                    <button type="button" class="main-butn" data-toggle="modal" data-target="#infoModal"><i class="fas fa-pen"></i>{{__('members.edit_profile')}}</button>
                </div>
            </div>
            <div class="tab-pane fade" id="nav-wallet" role="tabpanel" aria-labelledby="nav-wallet-tab">
                <div class="row">
                    <div class="col-md-7 m-auto">
                        <div class="wallet-box">
                            <img src="{{asset('assets/web/images/icons/profile/wallet.svg')}}" alt="" class="icon">
                            <div class="text">
                                <p class="p">{{__('members.current_balance')}}</p>
                                <h1 class="price dir-l"><b>{{$walletTotal}}</b> <small>{{__('main.sar')}}</small></h1>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="filtering mb-5 pt-2 mt-4">
                    <h5>{{__('members.search_filter')}}</h5>
                    <form>
                        <div class="row mt-3">
                            <div class="col-lg-4 col-md-6">
                                <div class="form-group">
                                    <label>{{__('members.from')}}</label>
                                    <input name="re_date_from" class="datepicker form-control" data-date-format="yyyy-mm-dd" placeholder="13/07/2022">
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-6">
                                <div class="form-group">
                                    <label>{{__('members.to')}}  </label>
                                    <input name="re_date_to" class="datepicker form-control" data-date-format="yyyy-mm-dd" placeholder="13/07/2022">
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-6">
                                <div class="form-group">
                                    <label>{{__('members.re_status')}}</label>
                                    <select name="is_paid" class="form-control">
                                        <option value="">{{__('members.all_status')}}</option>
                                        <option value="paid">{{__('members.paid')}}</option>
                                        <option value="not_paid">{{__('members.no_paid')}} </option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>
                <div class="allHalls wallet_container">
                    <div class="responsive-table">
                        <table class="wallet_table">
                            <tr>
                                <th>{{ __('halls.images') }}</th>
                                <th>{{ __('halls.name') }}</th>
                                <th>{{ __('halls.client_name') }}</th>
                                <th>{{ __('halls.client_phone') }}</th>
                                <th>{{ __('halls.reservation_date') }}</th>
                                <th>{{ __('reservations.person_count') }}</th>
                                <th>{{ __('reservations.service') }}</th>
                                <th>{{ __('reservations.added_services') }}</th>
                                <th>{{ __('reservations.services_amount') }}</th>
                                <th>{{ __('reservations.added_services_amount') }}</th>
                                <th>{{ __('reservations.added_value_amount') }}</th>
                                <th>{{ __('reservations.total') }}</th>
                                <th>{{ __('reservations.site_percentage') }}</th>
                                <th>{{ __('reservations.net_total') }}</th>
                            </tr>

                            @if(count($wallets))
                                @foreach($wallets as $wallet)
                                    <?php
                                    /** @var TYPE_NAME $wallet */
                                    $services = ($wallet->services && is_string($wallet->services)) ? json_decode($wallet->services, true) : ($wallet->services ?? []);
                                    $addedServices = ($wallet->added_services && is_string($wallet->added_services)) ? json_decode($wallet->added_services, true) : ($wallet->added_services ?? []);
                                    ?>
                                    <tr>
                                        <td><a href="{{route('reservation.reservationDetails', $wallet->id)}}"><img src="{{asset(json_decode($wallet->images, true)[0])}}" alt="" class="hall-img"></a></td>
                                        <td>{{$wallet->hall_name}}</td>
                                        <td>{{$wallet->client_name}}</td>
                                        <td>+{{$wallet->client_phone}}</td>
                                        <td>{{date('d/m/Y', strtotime($wallet->created_at))}}</td>
                                        <td>{{$wallet->person_count}}</td>
                                        <td>
                                            <ul>
                                                @if(count($services))
                                                    @php
                                                        /** @var $wallet $wallet */
                                                        $servicesNames = getServices($services)['names'];
                                                    @endphp
                                                    @if(count($servicesNames))
                                                        @foreach($servicesNames as $servicesName)
                                                            <li>{{$servicesName}}</li>
                                                        @endforeach
                                                    @endif
                                                @endif
                                            </ul>
                                        </td>
                                        <td>
                                            <ul>
                                                @if(count($addedServices))
                                                    @php
                                                        /** @var $wallet $wallet */
                                                        $addedServicesNames = getServices($addedServices)['names'];
                                                    @endphp
                                                    @if(count($addedServicesNames))
                                                        @foreach($addedServicesNames as $addedServicesName)
                                                            <li>{{$addedServicesName}}</li>
                                                        @endforeach
                                                    @endif
                                                @endif
                                            </ul>
                                        </td>
                                        <td><b>{{getServices($services)['total']}}</b> <small>{{__('main.sar')}}</small></td>
                                        <td><b>{{getServices($addedServices)['total']}}</b> <small>{{__('main.sar')}}</small></td>
                                        <td><b>{{ $wallet->added_value_amount }}</b> <small>{{__('main.sar')}}</small></td>
                                        <td><b>{{ $wallet->total }}</b> <small>{{__('main.sar')}}</small></td>
                                        <td><b>{{ ($wallet->total*$sitePercentage)/100 }}</b> <small>{{__('main.sar')}}</small></td>
                                        <td><b>{{ $wallet->total-(($wallet->total*$sitePercentage)/100) }}</b> <small>{{__('main.sar')}}</small></td>

                                    </tr>
                                @endforeach
                            @else
                                <tr><td colspan="20" class="text-center text-danger">{{__('members.no_data')}}</td></tr>
                            @endif
                        </table>
                    </div>
                    <div class="mt-5">
                        {{$wallets->links()}}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
