<div class="responsive-table">
    <table class="wallet_table">
        <tr>
            <th>{{ __('halls.images') }}</th>
            <th>{{ __('halls.name') }}</th>
            <th>{{ __('halls.client_name') }}</th>
            <th>{{ __('halls.client_phone') }}</th>
            <th>{{ __('halls.reservation_date') }}</th>
            <th>{{ __('reservations.person_count') }}</th>
            <th>{{ __('reservations.service') }}</th>
            <th>{{ __('reservations.added_services') }}</th>
            <th>{{ __('reservations.services_amount') }}</th>
            <th>{{ __('reservations.added_services_amount') }}</th>
            <th>{{ __('reservations.added_value_amount') }}</th>
            <th>{{ __('reservations.total') }}</th>
            <th>{{ __('reservations.site_percentage') }}</th>
            <th>{{ __('reservations.net_total') }}</th>
        </tr>

        @if(count($wallets))
            @foreach($wallets as $wallet)
                <?php
                /** @var TYPE_NAME $wallet */
                $services = ($wallet->services && is_string($wallet->services)) ? json_decode($wallet->services, true) : ($wallet->services ?? []);
                $addedServices = ($wallet->added_services && is_string($wallet->added_services)) ? json_decode($wallet->added_services, true) : ($wallet->added_services ?? []);
                ?>
                <tr>
                    <td><a href="{{route('reservation.reservationDetails', $wallet->id)}}"><img src="{{asset(json_decode($wallet->images, true)[0])}}" alt="" class="hall-img"></a></td>
                    <td>{{$wallet->hall_name}}</td>
                    <td>{{$wallet->client_name}}</td>
                    <td>+{{$wallet->client_phone}}</td>
                    <td>{{date('d/m/Y', strtotime($wallet->created_at))}}</td>
                    <td>{{$wallet->person_count}}</td>
                    <td>
                        <ul>
                            @if(count($services))
                                @php
                                    /** @var $wallet $wallet */
                                    $servicesNames = getServices($services)['names'];
                                @endphp
                                @if(count($servicesNames))
                                    @foreach($servicesNames as $servicesName)
                                        <li>{{$servicesName}}</li>
                                    @endforeach
                                @endif
                            @endif
                        </ul>
                    </td>
                    <td>
                        <ul>
                            @if(count($wallet->added_services))
                                @php
                                    /** @var $wallet $wallet */
                                    $addedServicesNames = getServices($addedServices)['names'];
                                @endphp
                                @if(count($addedServicesNames))
                                    @foreach($addedServicesNames as $addedServicesName)
                                        <li>{{$addedServicesName}}</li>
                                    @endforeach
                                @endif
                            @endif
                        </ul>
                    </td>
                    <td><b>{{getServices($services)['total']}}</b> <small>{{__('main.sar')}}</small></td>
                    <td><b>{{getServices($addedServices)['total']}}</b> <small>{{__('main.sar')}}</small></td>
                    <td><b>{{ $wallet->added_value_amount }}</b> <small>{{__('main.sar')}}</small></td>
                    <td><b>{{ $wallet->total }}</b> <small>{{__('main.sar')}}</small></td>
                    <td><b>{{ ($wallet->total*$sitePercentage)/100 }}</b> <small>{{__('main.sar')}}</small></td>
                    <td><b>{{ $wallet->total-(($wallet->total*$sitePercentage)/100) }}</b> <small>{{__('main.sar')}}</small></td>

                </tr>
            @endforeach
        @else
            <tr><td colspan="20" class="text-center text-danger">{{__('members.no_data')}}</td></tr>
        @endif
    </table>
</div>
<div class="mt-5">
    {{$wallets->links()}}
</div>
