@extends('web.layouts.container')
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/toastr.css') }}" />
@endsection
@section('content')
    <section class="page-heading">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}">{{__('main.home')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{__('main.new_register')}}</li>
                </ol>
                <h3>{{__('main.new_register')}}</h3>
            </nav>
        </div>
        <img src="{{asset('assets/web/images/page-heading-1.png')}}" alt="" class="pattern1">
        <img src="{{asset('assets/web/images/page-heading-2.png')}}" alt="" class="pattern2">
        <img src="{{asset('assets/web/images/page-heading-3.png')}}" alt="" class="pattern3">
    </section>
    <section class="register-pg">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-6 pr-0 pl-0">
                    <img src="{{asset('assets/web/images/header-img.png')}}" alt="" class="main-img">
                </div>
                <div class="col-md-6 pr-0 pl-0">
                    <div class="text-box center-vr">
                        <h6 class="h6">{{__('main.join_us')}}</h6>
                        <h4 class="h4">{{__('main.create_account')}} <b>{{__('main.new')}}</b></h4>
                        <p class="p">{{__('main.complete_register_hint')}}</p>
                        <div class="form-wrapper  mt-4">
                            <form method="post" action="{{route('provider.doRegister')}}" class="register_form">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <input name="name" type="text" class="form-control" autocomplete="off" autofocus required />
                                            <label class="floating-label">{{__('members.name')}}</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <input name="email" type="email" class="form-control" autocomplete="off" autofocus required />
                                    <label class="floating-label">{{__('members.email')}}</label>
                                </div>
                                <div class="form-group">
                                    <div class="d-flex phone-num-row">
                                        <div class="flex-shrink-0">
                                            <select class="form-control phone-select search-select">
                                                <option>{{session('country_code')}}</option>
                                            </select>
                                        </div>
                                        <div class="position-relative w-100">
                                            <input type="tel" readonly class="form-control phone-input text-left bg-white" dir="ltr" value="{{session('provider_phone')}}"/>
                                            <label class="floating-label">{{__('members.phone')}}</label>
                                        </div>

                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <select name="region_id" class="form-control" autocomplete="off" autofocus required >
                                                <option value=""> {{__('members.region_id')}} </option>
                                                @if(count($regions))
                                                    @foreach($regions as $region)
                                                        <option value="{{$region->id}}">{{$region->name}}</option>
                                                    @endforeach
                                                @endif
                                            </select>
                                            <label class="floating-label">{{__('members.region_id')}}</label>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <select name="city_id" class="form-control" autocomplete="off" autofocus required >
                                                <option value=""> {{__('members.city_id')}} </option>
                                            </select>
                                            <label class="floating-label">{{__('members.city_id')}}</label>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <select name="sector_id" class="form-control" autocomplete="off" autofocus required >
                                                <option value=""> {{__('members.sector_id')}} </option>
                                            </select>
                                            <label class="floating-label">{{__('members.sector_id')}}</label>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <input name="street" type="text" class="form-control" autocomplete="off" autofocus required />
                                            <label class="floating-label">{{__('members.street')}}</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group show_hide_password">
                                    <input name="password" type="password" class="form-control" id="password" autocomplete="off" autofocus required />
                                    <label class="floating-label"> {{__('members.password')}} </label>
                                    <!--<span class="togglePassword"><i class="far fa-eye" id="togglePassword"></i></span>-->
                                    <i class="show_pass far fa-eye-slash"></i>
                                </div>
                                <div class="form-group show_hide_password">
                                    <input name="password_confirmation" type="password" class="form-control" autocomplete="off" autofocus required />
                                    <label class="floating-label"> {{__('members.retype_password')}} </label>
                                    <i class="show_pass far fa-eye-slash"></i>
                                </div>
                                <div class="form-group file-input-group">
                                    <div class="wrap">
                                        <div class="file">
                                            <div class="commercial_file_input file__input" id="commercial_file__input">
                                                <input class="file__input--file" id="customFile" type="file"  name="commercial_file" />
                                                <label class="file__input--label" for="customFile" data-text-btn="{{__('members.select')}}"> {{__('members.commercial_file')}}  :</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group file-input-group">
                                    <div class="wrap">
                                        <div class="file">
                                            <div class="logo_file_input file__input" id="logo_file__input">
                                                <input class="file__input--file" id="customLogoFile" type="file" name="logo" />
                                                <label class="file__input--label" for="customLogoFile" data-text-btn="{{__('members.select')}}"> {{__('members.logo')}}  :</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="custom-control custom-control_2 custom-checkbox">
                                    <input value="1" name="agreement" type="checkbox" class="custom-control-input" id="policices">
                                    <label class="custom-control-label" for="policices">{{__('main.agreement_on')}} <a href="{{route('termsConditions')}}">{{__('policies.terms_conditions')}}</a> {{__('main.and')}} <a href="{{route('privacyPolicy')}}">{{__('policies.privacy_policy')}}</a></label>
                                </div>
                                <div class="custom-control custom-control_2 custom-checkbox mt-3">
                                    <input value="1" name="email_receive" type="checkbox" class="custom-control-input" id="newsletter">
                                    <label class="custom-control-label" for="newsletter">{{__('members.email_receive')}}</label>
                                </div>
                                <button class="submit-butn mt-4 register_button" type="submit">{{__('main.sign_up')}}</button>

                                <p class="another_choice mt-4">{{__('main.have_account')}} <a href="{{route('userProvider.login')}}">{{__('main.sign_in')}}</a></p>

                            </form>
                        </div>
                    </div>

                </div>
            </div>

        </div>
    </section>

@endsection

@section('inner_js')
    <script src="{{ asset('assets/web/js/lib/toastr.min.js') }}"></script>
    <script src="{{ asset('assets/web/js/users.register.js') }}"></script>
    <script>
        let getCityAndSectorRoute = "{{route('provider.getCityAndSector')}}";
    </script>
    <script>
        $('select[name="region_id"], select[name="city_id"]').change(async function (e) {
            let data = {
                    region_id: $('select[name="region_id"]').val(),
                    city_id: $('select[name="city_id"]').val()
                },
                url = getCityAndSectorRoute,
                method = 'get';

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.cities.length && !response.sectors.length){
                let cities = $('select[name="city_id"]');
                cities.html(`<option value=""> {{__('members.city_id')}} </option>`);
                for(let i = 0; i < response.cities.length; i++){
                    cities.append(`<option value="`+response.cities[i].id+`">`+response.cities[i].name+`</option>`)
                }
            }
            if (response.cities.length && response.sectors.length){
                let sectors = $('select[name="sector_id"]');
                sectors.html(`<option value=""> {{__('members.sector_id')}} </option>`);
                for(let i = 0; i < response.sectors.length; i++){
                    sectors.append(`<option value="`+response.sectors[i].id+`">`+response.sectors[i].name+`</option>`)
                }
            }
        });

        $(document).ready(function() {

            // ------------  File upload BEGIN ------------
            $('input[name="commercial_file"]').on('change', function(event) {
                $('.commercial_file_value').remove();
                var files = event.target.files;
                for (var i = 0; i < files.length; i++) {
                    var file = files[i];
                    $("<div class='commercial_file_value file__value'><div class='commercial_file__value--text'>" + file.name + "</div><div class='commercial_file__value--remove' data-id='commercial_" + file.name + "' ></div></div>").insertAfter('.commercial_file_input');
                }
            });

            $('input[name="logo"]').on('change', function(event) {
                $('.logo_file_value').remove();
                var files = event.target.files;
                for (var i = 0; i < files.length; i++) {
                    var file = files[i];
                    $("<div class='logo_file_value file__value'><div class='logo_file__value--text'>" + file.name + "</div><div class='logo_file__value--remove' data-id='logo_" + file.name + "' ></div></div>").insertAfter('.logo_file_input');
                }
            });


            //Click to remove item
            $('body').on('click', '.commercial_file_value', function() {
                $(this).remove();
                $('input[name="commercial_file"]').val('');
            });

            $('body').on('click', '.logo_file_value', function() {
                $(this).remove();
                $('input[name="logo"]').val('');
            });
            // ------------ File upload END ------------

        });

    </script>
@endsection
