@extends('web.layouts.container')
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/toastr.css') }}" />
@endsection
@section('content')
    <section class="page-heading">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}">{{__('main.home')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{__('main.forget_password_title')}}</li>
                </ol>
                <h3>{{__('main.forget_password_title')}}</h3>
            </nav>
        </div>
        <img src="{{asset('assets/web/images/page-heading-1.png')}}" alt="" class="pattern1">
        <img src="{{asset('assets/web/images/page-heading-2.png')}}" alt="" class="pattern2">
        <img src="{{asset('assets/web/images/page-heading-3.png')}}" alt="" class="pattern3">
    </section>

    <section class="register-pg">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-6 pr-0 pl-0">
                    <img src="{{asset('assets/web/images/header-img.png')}}" alt="" class="main-img">
                </div>
                <div class="col-md-6 pr-0 pl-0">
                    <div class="text-box">
                        <h4 class="h4"> {{__('main.forget')}} <b>{{__('main.password')}}</b></h4>
                        <p class="p">{{__('main.please_enter_data')}}</p>
                        <div class="form-wrapper mt-5">
                            <form method="post" action="{{route('user.sendForgetPasswordCode')}}" class="reset_password_method_form">
                                <div class="form-group">
                                    <input name="email" type="text" class="form-control" autocomplete="off" autofocus required />
                                    <label class="floating-label">  {{__('members.email')}} </label>
                                </div>
                                <button class="submit-butn reset_password_method_button"> {{__('main.send')}} </button>

                            </form>
                        </div>
                    </div>

                </div>
            </div>

        </div>
    </section>
@endsection

@section('inner_js')

    <script src="{{ asset('assets/web/js/lib/toastr.min.js') }}"></script>
    <script src="{{ asset('assets/web/js/users.password.forget_password_form.js') }}"></script>
@endsection


