<div class="navs-wrapper">
    <!--Start navbar-->
    <nav class="navbar navbar-expand-lg ">
        <div class="container-fluid">
            <a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}" class="navbar-brand">
                <img src="{{asset('assets/web/images/logo-footer.svg')}}" alt="" class="logo">
            </a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">

                <ul class="navbar-nav m-auto">
                    <div class="account-links ">
                        <img src="{{asset('assets/web/images/icons/profile.svg')}}" alt="" class="icon">
                        @if(auth()->check() && in_array(auth()->user()->role, ['user', 'provider']))
                            @if(auth()->user()->role == 'user') <a href="{{ route('user.profile') }}">{{__('main.profile')}}</a> @endif
                            @if(auth()->user()->role == 'provider') <a href="{{ route('provider.profile') }}">{{__('main.profile')}}</a> @endif

                        @else
                            <a href="{{ route('userProvider.login') }}">{{__('main.login')}}</a> /
                            <a href="{{ route('user.register') }}">{{__('main.register')}}</a>
                        @endif

                    </div>
                    <li class="nav-item ">
                        <a class="nav-link {{isActive(route('home'))}}" href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}">{{__('main.home')}} </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link  {{isActive(route('aboutUs'))}}" href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('aboutUs'), [], true)}}">{{__('main.why_us')}}</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{isActive(route('hall.index'))}}" href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('hall.index'), [], true)}}"> {{__('main.halls')}}</a>
                    </li>
{{--                    <li class="nav-item">--}}
{{--                        <a class="nav-link" href="#">{{__('main.cities')}}</a>--}}
{{--                    </li>--}}
                    <li class="nav-item">
                        <a class="nav-link {{isActive(route('hall.offerHall'))}}" href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('hall.offerHall'), [], true)}}"> {{__('main.special_offers')}} </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{isActive(route('contactUs'))}}" href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('contactUs'), [], true)}}"> {{__('visitorMessages.head')}}</a>
                    </li>
                </ul>
                <a href="{{route('provider.register')}}" class="main-link">{{__('main.provider_register')}}</a>
                <div class="dropdown">
                    <button class="dropdown-btn dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        {{__('main.language')}}
                    </button>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                        <a class="dropdown-item" href="{{LaravelLocalization::getLocalizedURL('ar', null, [], true)}}">{{__('main.arabic')}}</a>
                        <a class="dropdown-item" href="{{LaravelLocalization::getLocalizedURL('en', null, [], true)}}">{{__('main.english')}}</a>
                    </div>
                </div>
            </div>
        </div>
    </nav>
    @if(in_array(\Illuminate\Support\Facades\Route::currentRouteName(), ['hall.index', 'home']))
        <div class="navbar navbar-expand-lg ">
            <div class="col-md-4 m-auto">
                <form action="{{route('hall.index')}}" method="get" class="form hall_name_search_form" autocomplete="off">
                    <div class="form-group">
                        <input type="search" name="hall_name" class="form-control" placeholder="{{__('halls.hall_Search')}}">
                        <button> <i class="fas fa-search"></i> </button>
                    </div>
                </form>
            </div>
        </div>
    @endif

</div>

<div class="tab-bar-mob d-none ">
    <div class="container">
        <div class="links d-flex justify-content-around align-items-center">
            <a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}" class="link active">
                <span class="icon">
                    <i class="bi bi-house-door"></i>
                </span>
                <span class="pg_name">{{__('main.home')}}</span>
            </a>
            <a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('hall.index'), [], true)}}" class="link">
                 <span class="icon">
                    <i class="bi bi-building"></i>
                </span>
                <span class="pg_name"> {{__('halls.head')}} </span>
            </a>
            <a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('contactUs'), [], true)}}" class="link">
                   <span class="icon">
                    <i class="bi bi-telephone"></i>
                </span>
                <span class="pg_name">{{__('visitorMessages.head')}}</span>
            </a>
        </div>
    </div>
</div>
