<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="{{ $settings['meta_description'] }} - {{ $meta_description ?? ($title ?? '') }}" />
    <meta name="keywords" content="{{ $settings['keywords'] }} , {{  $keywords ??  ($title ?? '') }}" />

    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ $settings['website_name'] }} - {{ ($title ?? '') }}</title>

    <link rel="shortcut icon" href="{{ asset('assets/web/images/icon.png') }}" title="Favicon" sizes="16x16" />


    @if (app()->getLocale() == 'ar')
        <link rel="stylesheet" href="{{ asset('assets/web/css/lib/bootstrap-rtl.min.css') }}" />
    @endif

    @if (app()->getLocale() == 'en')
        <link rel="stylesheet" href="{{ asset('assets/web/css/lib/bootstrap-ltr.min.css') }}" />
    @endif

    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@200;300;400;500;700;800;900&display=swap" rel="stylesheet">
    <!-- Bootstrap icons  -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">

    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/all.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/animate.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/jquery.fancybox.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/swiper.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/selectBox.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/datepicker.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/jquery-ui.css') }}" />
    <link rel="stylesheet" href="//code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">



    <link rel="stylesheet" href="{{ asset('assets/web/css/style.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/web/css/media.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/toastr.css') }}">

    @if (app()->getLocale() == 'en')
        <link rel="stylesheet" href="{{ asset('assets/web/css/style-en.css') }}" />
    @endif

    @yield('css')

    <style>

        /*-------- loader --------*/

        .loading_page {
            position: fixed;
            left: 0;
            top: 0;
            z-index: 9999;
            background-color: #fff;
            width: 100%;
            height: 100%;
        }

        circle {
            transform-origin: center;
            transform-box: fill-box;
            transform-origin: center;
            animation: rotate linear infinite;
        }

        circle:nth-child(1) {
            animation-duration: 1.6s;
        }

        circle:nth-child(2) {
            animation-duration: 1.2s;
        }

        circle:nth-child(3) {
            animation-duration: 0.8s;
        }

        @keyframes rotate {
            100% {
                transform: rotate(360deg);
            }
        }

        svg {
            position: absolute;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%);
            width: 100px;
        }

        .loader {
            animation: none;
            border: none;
            border-radius: 0;
            border-right-color: transparent;
            border-top-color: transparent;
            box-sizing: border-box;
            /*height: 20vmin;*/
            left: 50%;
            position: fixed;
            top: 50%;
            transform: translate(-50% , -50%);
            /*width: 20vmin;*/
            z-index: 1;
        }
    </style>

</head>

<body>

<!--<div class="loading">-->
<!--    <div class="loader"></div>-->
<!--</div>-->

<div class="loading_page">
    <svg class="loader">
        <circle cx="50" cy="50" r="40" stroke="#312482" stroke-dasharray="78.5 235.5" stroke-width="3" fill="none"></circle>
        <circle cx="50" cy="50" r="30" stroke="#312482" stroke-dasharray="62.8 188.8" stroke-width="3" fill="none"></circle>
        <circle cx="50" cy="50" r="20" stroke="#312482" stroke-dasharray="47.1 141.3" stroke-width="3" fill="none"></circle>
     </svg>
</div>


@yield('container_content')
<script src="{{ asset('assets/web/js/lib/jquery4.js') }} "></script>
<script src="{{ asset('assets/web/js/lib/popper.min.js') }} "></script>
<script src="{{ asset('assets/web/js/lib/bootstrap.js') }} "></script>
<script src="{{ asset('assets/web/js/lib/smooth-scroll.min.js') }} "></script>
<script src="{{ asset('assets/web/js/lib/jquery.fancybox.js') }} "></script>
<script src="{{ asset('assets/web/js/lib/jquery.easing-1.3.pack.js') }} "></script>
<script src="{{ asset('assets/web/js/lib/jquery.mousewheel-3.0.4.pack.js') }} "></script>
<script src="{{ asset('assets/web/js/lib/jquery.waypoints.min.js') }} "></script>
<script src="{{ asset('assets/web/js/lib/jquery.counterup.min.js') }} "></script>
<script src="{{ asset('assets/web/js/lib/swiper.js') }} "></script>
<script src="{{asset('assets/web/js/lib/image-uploader.min.js')}}"></script>
<script src="{{ asset('assets/web/js/lib/wow.min.js') }} "></script>
<script src="{{ asset('assets/web/js/lib/selectBox.js') }} "></script>
<script src="{{ asset('assets/web/js/lib/datepicker.min.js') }} "></script>
<script src="{{ asset('assets/web/js/printThis.js') }}"></script>
<script src="{{ asset('assets/web/js/lib/toastr.min.js') }}"></script>
<script src="{{ asset('assets/web/js/lib/jquery-ui-1.13.1.js') }}"></script>
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>

<script>
    $('#print_btn').on("click", function() {
        $('.cont_print').printThis({
            importCSS: true, // import parent page css
        });
    });
</script>

<script>

    // === window When Loading === //

    $(window).on("load", function() {

        var wind = $(window);

        $(".loading_page").addClass('d-none');

    });

</script>



{{--<script src="https://cdnjs.cloudflare.com/ajax/libs/animejs/2.0.2/anime.min.js"></script>--}}
{{--<script src="https://cdnjs.cloudflare.com/ajax/libs/skrollr/0.6.30/skrollr.min.js" integrity="sha512-A2+khatRDWHUE2VUtN4xUTkr1nc4YfDBw9Sg3ea6x0aRPfpcYieDZji4D2edDHy/yF5NsYzP7kL8sSM8s5EqCw==" crossorigin="anonymous"></script>--}}

@yield('container_js')
</body>

</html>
