@extends('web.layouts.layout')

@section('container_content')
    @include('web.layouts.nav')
    <main>
        {{--        @include('web.layouts.header')--}}
        @yield('content')
        {{--        @include('web.layouts.newsletter')--}}
    </main>
    @include('web.layouts.footer')

    <!--Confirmation Modal-->
    <div class="modal confirmation-modal fade alert_pop_up" id="confirmationModal" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="text-box text-center">
                        <img style="width: 200px" src="{{asset('assets/web/images/confirm.png')}}" alt="" class="icon filter_green mb-3"/>
                        <h3 class="title {{session('success') ? 'text-success' : 'text-danger'}}">
                            {{--                            {{session('success') ? 'text-success' : 'text-danger'}}--}}
                            @if(session('alert_pop_up'))
                                {{session('alert_pop_up')}}
                            @endif
                        </h3>
                        {{--                        <p class="p">{{__('products.thanks_message')}} <b>{{__('abouts.call_handy')}}</b>  {{__('products.store')}}</p>--}}
                    </div>
                </div>
                <div class="modal-footer">
                    <button data-dismiss="modal" type="button" class="main-butn">{{__('reservations.confirm')}}</button>
                </div>
            </div>
        </div>
    </div>


@endsection

@section('container_js')
    {{--    <script src="https://unpkg.com/axios/dist/axios.min.js"></script>--}}
    <script src="{{ asset('assets/web/js/lib/toastr.min.js') }}"></script>
    <script src="{{ asset('assets/web/js/lib/axios.min.js') }}"></script>

    <script>
        axios.defaults.headers.common = {
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN' : document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        };

        {{--let changeAmountRouteForNav = "{{route('home')}}",--}}
            {{--    deleteProductRouteForNav = "{{route('home')}}";--}}

        if ("{{session('alert_pop_up')}}"){
            $('.alert_pop_up').modal();
        }

    </script>
    <script src="{{ asset('assets/web/js/actions.js') }}"></script>
    <script src="{{ asset('assets/web/js/main.js') }} "></script>


        @if(session('store_device_token'))
            @include('web.layouts.firebase')
            {{session()->forget(['store_device_token'])}}
        @endif

    @yield('inner_js')
@endsection
