@extends('web.layouts.container')

@section('content')
    <!--Start searching-->
    <div class="searching">
        <div class="container-fluid">
            <div class="inner">
                <form action="{{route('hall.index')}}" method="get" class="form search_form" autocomplete="off">
                    <div class="item">
                        <img src="{{asset('assets/web/images/icons/selectbox-4.svg')}}" class="icon" alt="">
                        <div class="form-group">
                            <select name="occasion_id" class="form-control search-select">
                                <option value="">{{__('main.your_occasion')}}</option>
                                <option value="all">{{__('halls.all')}}</option>
                                @if(count($occasions))
                                    @foreach($occasions as $occasion)
                                        <option value="{{$occasion->id}}">{{$occasion->name}}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>
                    <div class="item">
                        <img src="{{asset('assets/web/images/icons/advances-search-2.svg')}}" class="icon" alt="">
                        <div class="form-group">
                            <select name="category_id" class="form-control search-select">
                                <option value="">{{__('main.type_of_place')}}</option>
                                <option value="all">{{__('halls.all')}}</option>
                                {{--                                <option value="">{{__('halls.all_categories')}}</option>--}}
                                @if(count($categories))
                                    @foreach($categories as $category)
                                        <option value="{{$category->id}}">{{$category->name}}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>
                    <div class="item">
                        <img src="{{asset('assets/web/images/icons/advances-search-3.svg')}}" class="icon" alt="">
                        <div class="form-group">
                            <select name="city_id" class="form-control search-select">
                                <option value="">{{__('main.city')}}</option>
                                <option value="all">{{__('halls.all')}}</option>
                            @if(count($cities))
                                    @foreach($cities as $city)
                                        <option value="{{$city->id}}">{{$city->name}}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>
                    <div class="item">
                        <img src="{{asset('assets/web/images/icons/advances-search-6.svg')}}" class="icon" alt="">
                        <div class="form-group">
                            <select name="rate" class="form-control search-select">
                                <option value="">{{__('main.evaluate_stars')}}</option>
                                <option value="all">{{__('halls.all')}}</option>
                                <option value="5">5.0</option>
                                <option value="4">4.0</option>
                                <option value="3">3.0 </option>
                            </select>
                        </div>
                    </div>
                    <div class="item">
                        <img src="{{asset('assets/web/images/icons/advances-search-5.svg')}}" class="icon" alt="">
                        <div class="form-group">
                            <select class="form-control search-select period_days">
                                <option selected >{{__('main.period')}}</option>
                                <option value="multi">{{__('main.several_days')}}</option>
                                <option value="single">{{__('main.one_day')}}</option>
                            </select>
                        </div>
                    </div>

                    <div class="dateBordering">
                        <div class="item dateItem">
                            <div class="form-group">
                                <label>{{__('main.from')}}</label>
                                <span class="icon"><img src="{{asset('assets/web/images/icons/advances-search-5.svg')}}" alt=""></span>
                                <input name="re_date_from" class="datepicker form-control" data-date-format="mm/dd/yyyy" placeholder="MM/DD/YYYY">
                            </div>
                        </div>
                        <div class="item dateItem date_to">
                            <div class="form-group">
                                <label>{{__('main.to')}}</label>
                                <span class="icon"><img src="{{asset('assets/web/images/icons/advances-search-5.svg')}}" alt=""></span>
                                <input name="re_date_to" class="datepicker form-control" data-date-format="mm/dd/yyyy" placeholder="MM/DD/YYYY">

                            </div>
                        </div>
                    </div>

                    <button class="submit-btn"><img src="{{asset('assets/web/images/icons/advances-search-4.svg')}}" class="icon" alt=""> </button>

                </form>
            </div>

        </div>
    </div>
    <!--Start Header-->
    <header>
        <!--Start header-container-->
        <div class="container-fluid">
            <div class="inner">
                <div class="row">
                    <div class="col-lg-6 pr-0 pl-0">
                        <img src="{{asset('assets/web/images/header-img.png')}} " alt="" class="header-img">
                    </div>
                    <div class="col-lg-6">
                        <div class="swiper-container header-swiper center-vr">
                            <div class="swiper-wrapper">
                                @if(count($sliders))
                                    @foreach($sliders as $slider)
                                        <div class="swiper-slide">
                                            <div class="text-box ">
                                                @php
                                                    /** @var TYPE_NAME $slider */
                                                    $splitTitle = explode(' ', $slider->title, 2);
                                                @endphp
                                                <h1 class="h1"><b>{{count($splitTitle) > 1 ? $splitTitle[0] : ''}}</b> {{count($splitTitle) > 1 ? $splitTitle[1] : ''}}</h1>
                                                <p class="p">{{stripText($slider->description)}}</p>
                                            </div>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                            <!-- Add Pagination -->
                            <div class="swiper-pagination"></div>
                        </div>

                    </div>
                </div>
            </div>
            <img src="{{asset('assets/web/images/header-pattern.png')}}" alt="" class="pattern">
        </div>
    </header>
    <!--Start features-sec -->
    <section class="features-sec">
        <div class="container">
            <div class="sec-heading wow fadeInUp"  >
                <span class="icon"><img src="{{asset('assets/web/images/sec-heading-1.png')}}" alt=""></span>
                <h3>{{__('main.why_us')}}</h3>
            </div>
            <div class="row">
                <div class="col-lg-4">
                    <div class="feature-card wow fadeInLeft"  >
                        <div class="content">
                            <h5 class="headline">{{stripText($about->why_us_first_title, 50)}}</h5>
                            <p class="paragraph">{{stripText($about->why_us_first_description, 100)}}</p>
                            <a href="{{route('aboutUs')}}" class="link-btn mt-4">{{__('main.know_more')}}</a>
                            <img src="{{asset('assets/web/images/icon.png')}}" alt="" class="icon mt-4">
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="feature-card wow fadeInUp"   data-wow-delay=".6s">
                        <div class="content">
                            <h5 class="headline">{{stripText($about->why_us_second_title, 50)}}</h5>
                            <p class="paragraph">{{stripText($about->why_us_second_description, 100)}}</p>
                            <a href="{{route('aboutUs')}}" class="link-btn mt-4">{{__('main.know_more')}}</a>
                            <img src="{{asset('assets/web/images/icon.png')}}" alt="" class="icon mt-4">
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="feature-card wow fadeInRight"  >
                        <div class="content">
                            <h5 class="headline">{{stripText($about->why_us_third_title, 50)}}</h5>
                            <p class="paragraph">{{stripText($about->why_us_third_description, 100)}}</p>
                            <a href="{{route('aboutUs')}}" class="link-btn mt-4">{{__('main.know_more')}}</a>
                            <img src="{{asset('assets/web/images/icon.png')}}" alt="" class="icon mt-4">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Start banner-sec -->
    <section class="banner-sec banner-sec2">
        <img src="{{asset('assets/web/images/banner-2.png')}}" alt="" class="banner-img">
        <div class="container">
            <div class="text-box wow text-focus-in" data-wow-duration="2d">
                <div class="row">
                    <div class="col-md-5 m-auto">
                        <h5 class="h5">{{__('main.always_with_you')}}</h5>
                        <h2 class="h2">{{__('main.make_best_event')}}</h2>
                        <a data-fancybox href="{{$about->video}}" class="play-btn"> <img src="{{asset('assets/web/images/icons/play-button.svg')}}" alt="" class="icon"> </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Start cities-sec -->
    <section class="cities-sec halls-sec">
        <div class="container">
            <div class="sec-heading wow fadeInUp"  >
                <span class="icon"><img src="{{asset('assets/web/images/sec-heading-2.png')}}" alt=""></span>
                <h3>{{__('main.cities')}}</h3>
            </div>
            <div class="cities-swiper">
                <div class="swiper-container">
                    <div class="swiper-wrapper">
                        @if(count($cities))
                            @foreach($cities as $city)
                                <div class="swiper-slide">
                                    <div class="hall-card">
                                        <div class="img-box">
                                            <img src="{{asset($city->photo)}}" alt="">
    {{--                                        <span class="rate-badge"><i class="far fa-star"></i> 4.5</span>--}}
                                        </div>
                                        <div class="card-body text-center">
                                            <h5 class="city-name"><img src="{{asset('assets/web/images/icons/loc-blue.svg')}}" alt="" class="icon"> {{$city->name}}</h5>
                                            <a href="{{route('hall.index').'?city_id='.$city->id}}" class="link-btn mt-3">{{__('main.find_more')}}</a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>
                <!-- Add Arrows -->
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
            </div>

        </div>
    </section>
    <!--Start halls-sec -->
    <section class="halls-sec">
        <div class="container">
            <div class="sec-heading wow fadeInUp"  >
                <span class="icon"><img src="{{asset('assets/web/images/sec-heading-1.png')}}" alt=""></span>
                <h3>{{__('main.top_rated_halls')}}</h3>
            </div>
            <div class="halls-swiper">
                <div class="swiper-container">
                    <div class="swiper-wrapper">
                        @if(count($highHallsRates))
                            @foreach($highHallsRates as $highHallsRate)
                                <div class="swiper-slide">
                                    <div class="hall-card">
                                        <div class="img-box">
                                            <a href="{{route('hall.show', $highHallsRate['id'])}}">
                                                <img src="{{asset($highHallsRate['images'][0])}}" alt="">
                                                <span class="rate-badge"><i class="far fa-star"></i> {{$highHallsRate['rate']}}</span>
                                                <span class="badge">{{$highHallsRate['category_name']}}</span>
                                            </a>
                                        </div>
                                        <div class="card-body">
                                            <div class="prof-info">
                                                <img src="{{asset('assets/web/images/avatar.png')}}" alt="" class="prof_img">
                                                <div class="text">
                                                    <span class="provider">{{__('main.provider')}}</span>
                                                    <h6 class="name mb-0">{{$highHallsRate['provider_name']}}</h6>
                                                </div>
                                            </div>
                                            <h5 class="headline">{{$highHallsRate['hall_name']}}</h5>
                                            <p class="city-name"><img src="{{asset('assets/web/images/icons/loc-blue.svg')}}" alt="" class="icon">{{$highHallsRate['city_name']}}</p>
                                                <small>
                                                    @if($highHallsRate['reservation_type'] == 'person_count')
                                                        <p class="price">{{__('main.start_from')}} <span class="dir-l"><b>{{$highHallsRate['booking_amount_per_person']}} {{__('main.sar')}}</b></span>
                                                        {{(__('main.per_person'))}}
                                                    @endif
                                                    @if($highHallsRate['reservation_type'] == 'days_count')
                                                            <p class="price">{{__('main.start_from')}} <span class="dir-l"><b>{{$highHallsRate['booking_amount_per_day']}} {{__('main.sar')}}</b></span>
                                                            {{(__('main.per_day'))}}
                                                    @endif
                                                </small>
                                            </p>
                                            <a href="{{route('reservation.hallReservation', $highHallsRate['id'])}}" class="link-btn"> {{__('main.book_now')}}  </a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>
                <!-- Add Arrows -->
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
            </div>
        </div>
    </section>

    <!--Start banner-sec -->
    <section class="banner-sec">
        <div class="container">
            <div class="inner">
                <img src="{{asset($pages->image)}}" alt="" class="banner-img">
                <div class="text-box wow zoomIn"  >
                    <div class="row">
                        <div class="col-md-5">
                            <h5 class="h5">{{$pages->title}}</h5>
                            <h2 class="h2">{{$pages->title_2}}</h2>
                            <a href="{{route('provider.register')}}" class="link-btn">{{__('main.join_us')}}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Start partners-sec -->
    <section class="partners-sec">
        <div class="container">
            <div class="sec-heading wow fadeInUp"  >
                <span class="icon"><img src="{{asset('assets/web/images/sec-heading-1.png')}}" alt=""></span>
                <h3> {{__('main.partners')}} </h3>
            </div>
            <div class="swiper-container partners-swiper">
                <div class="swiper-wrapper">
                    @if(count($partners))
                        @foreach($partners as $partner)
                            <div class="swiper-slide">
                                <img src="{{asset($partner->image)}}" alt="" class="logo">
                            </div>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </section>
    <!--Start newsletter-sec -->
    <section class="newsletter-sec">
        <div class="container">
            <div class="inner">
                <div class="row">
                    <div class="col-md-6 m-auto">
                        <div class="text-box text-center wow bounceIn"  >
                            <img src="{{asset('assets/web/images/icons/mail.svg')}}" alt="" class="icon">
                            <h3><b>{{__('main.newsletters_title')}}</b></h3>
                            <p>{{__('main.newsletters_hint')}}</p>
                            <form action="{{route('newsletter')}}" method="post" class="form newsletter_form">
                                <div class="form-group mt-4">
                                    <input type="email" name="email" class="form-control newsletter_email" placeholder="{{__('main.email')}} ...">
                                    <!--<button class="submit-btn newsletter_button"><i class="fab fa-telegram-plane"></i></button>-->
                                    <button class="submit-btn newsletter_button"><i class="fab fa-telegram-plane" ></i></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <img src="{{asset('assets/web/images/pattern-5.png')}}" alt="" class="pattern">
    </section>

    <!-- Modal -->
        <div class="modal fade subsModal newsletter_modal" id="subsModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
              <div class="modal-body text-center">
                    <h2 class="icon mb-4">
                        <i class="fas fa-check text-success"></i>
                    </h2>
                    <h3 class="title mb-4">{{__('newsletters.newsletter_subscribe_success')}}</h3>
                    <div class="text-center">
                        <button type="button" class="btn btn-danger rounded-pill px-4 m-2" data-dismiss="modal" aria-label="Close">{{__('main.close')}}</button>
                    </div>
              </div>
            </div>
          </div>
        </div>
    <!--Start statics-sec -->
    <section class="statics-sec">
        <div class="container">
            <div class="sec-heading wow fadeInUp"  >
                <span class="icon"><img src="{{asset('assets/web/images/sec-heading-1.png')}}" alt=""></span>
                <h3>{{__('main.owner_numbers')}}</h3>
            </div>
            <div class="row">
                @if(count($numbers))
                    @foreach($numbers as $number)
                        <div class="col-md-6 col-6 col-lg-3">
                            <div class="static-card wow flipInY"  >
                                <span class="line bg-mouve"></span>
                                <h1 class="h1"><span class="counter">{{$number->number}}</span> + </h1>
                                <p class="p">{{$number->title}}</p>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
        </div>
    </section>
@endsection

@section('inner_js')

    <script>
        $('.period_days').change(function () {
            if ($(this).val() === 'single'){
                $('.date_to').addClass('d-none')
            } else {
                $('.date_to').removeClass('d-none')
            }
        })
    </script>

    <script type="text/javascript">
        $('.counter').countUp({
            delay: 10,
            time: 2000
        });
    </script>

@endsection
