@extends('web.layouts.container')
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/admin/css/lib/jquery-ui.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/admin/css/lib/jquery-ui.theme.css') }}" />
    {{--    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/datepicker.min.css') }}" />--}}



    <style>

        .highlight{
            background: #FC0 !important; {{-- #0056b3 #FC0--}}

        }
        .ui-state-highlight, .ui-widget-content .ui-state-highlight, .ui-widget-header .ui-state-highlight{
            /*background-color: #0056b3 !important;*/
            /*color: #454545 !important;*/
        }
        /*.ui-widget-header a{*/
        /*    color: #333333 !important;*/
        /*}*/
    </style>

@endsection
@section('content')
    <section class="page-heading">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}">{{__('main.home')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page"> {{__('halls.hall_details')}} </li>
                </ol>
                <h3>  {{__('halls.hall_details')}}</h3>
            </nav>
        </div>
        <img src="{{asset('assets/web/images/page-heading-1.png')}}" alt="" class="pattern1">
        <img src="{{asset('assets/web/images/page-heading-2.png')}}" alt="" class="pattern2">
        <img src="{{asset('assets/web/images/page-heading-3.png')}}" alt="" class="pattern3">
    </section>
    <section class="hall-det reservation_det reservation_det2 bill-pg">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 m-auto">
                    <div class="hall_main_det">
                        <div class="row align-items-center">
                            <div class="col-lg-8">
                                <h3>{{$hall->hall_name}}</h3>
                            </div>
                            <div class="col-lg-4 mt-4 mt-lg-0">
                                <div class="stars_rate d-flex align-items-center justify-content-end">
                                    <div class="stars small">
                                        @if($hall->rate)
                                            @for($i = 1; $i <= $hall->rate; $i++)
                                                <i class="fas fa-star"></i>
                                            @endfor
                                        @endif
                                    </div>
                                    <span> ( {{$hall->evaluate_counts . ' ' . __('halls.evaluates')}} ) </span>
                                </div>
                            </div>
                            <div class="col-lg-12 d-flex justify-content-end">
                                <a title="{{__('halls.copy_to_share')}}" href="{{route('hall.show', $hall->id)}}" class="copy_to_share_link"><i class="fas fa-share fa-2x"></i></a>
                            </div>
                        </div>
                        <h6 class="mt-3"> <strong> <i class="fas fa-city ml-2"></i> {{__('halls.city_id')}} : </strong> <span> {{$hall->city_name}} </span> </h6>
                    </div>
                </div>
                <div class="col-lg-10 m-auto">
                    <div class="swiper-container single-hall-swiper">
                        <div class="swiper-wrapper">
                            @if(count($hall['images']))
                                @foreach($hall['images'] as $image)
                                    <div class="swiper-slide">
                                        <a data-fancybox="hall" href="{{ asset($image) }}">
                                            <img src="{{asset($image)}}" alt="" class="hall-img">
                                        </a>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                        <!-- Add Arrows -->
                        <div class="swiper-button-next"></div>
                        <div class="swiper-button-prev"></div>
                    </div>
                    <div class="reservation_item">
                        <div class="row">
                            <!-- Hall details -->
                            <div class="col-lg-4">
                                <div class="prof-info">
                                    <img src="{{asset($hall->provider_logo)}}" alt="" class="prof_img">
                                    <div class="text">
                                        <span class="title"> {{__('halls.user_id')}}</span>
                                        <h6 class="name mb-0">{{$hall->provider_name}}</h6>
                                    </div>
                                </div>
                            </div>
                            {{--                            <div class="col-md-4">--}}
                            {{--                                <div class="prof-info">--}}
                            {{--                                    <img src="{{asset($hall->provider_logo)}}" alt="" class="prof_img">--}}
                            {{--                                    <div class="text">--}}
                            {{--                                        <span class="title">{{__('halls.logo')}}</span>--}}
                            {{--                                        <h6 class="name mb-0">{{$hall->hall_name}}</h6>--}}
                            {{--                                    </div>--}}
                            {{--                                </div>--}}
                            {{--                            </div>--}}
                            <div class="col-md-4">
                                <div class="prof-info">
                                    <img src="{{asset('assets/web/images/icons/team.svg')}}" alt="" class="prof_img user_icon">
                                    <div class="text">
                                        <span class="title"> {{__('halls.capacity')}} </span>
                                        <h6 class="name mb-0"> {{$hall->capacity}} {{__('halls.person')}}  </h6>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="prof-info">
                                    <img src="{{asset('assets/web/images/icons/price.png')}}" alt="" class="prof_img user_icon">
                                    <div class="text">
                                        <span class="title"> {{__('halls.amount_day_person')}}</span>
                                        <h5 class="price dir-l"><b>{{$hall->booking_amount_per_person ?? $hall->booking_amount_per_day}} </b> <small>{{__('main.sar')}}</small></h5>
                                        <small class="text-danger"> {{__('halls.prices_not_includes_tax')}} </small>
                                    </div>
                                </div>
                            </div>

                            {{-- Map block--}}
                            <div class="col-md-12 mt-5">
                                <div class="map-box">
                                    <div style="border:0; height: 400px; width: 100%" class="map" id="map"></div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="hall_contacts">
                                    <div class="row">
                                        <div class="col-lg-3 col-6">
                                            <p class="labeled"><img src="{{asset('assets/web/images/icons/loc-mouve.svg')}}" alt="" class="icon"> {{__('halls.city_id')}}</p>
                                            <h6 class="data mb-4"><b>{{$hall->city_name}}</b></h6>
                                        </div>

                                        <div class="col-lg-3 col-6">
                                            <p class="labeled"><img src="{{asset('assets/web/images/icons/loc-mouve.svg')}}" alt="" class="icon"> {{__('halls.region_id')}}</p>
                                            <h6 class="data mb-4"><b>{{$hall->region_name}}</b></h6>
                                        </div>

                                        <div class="col-lg-3 col-6">
                                            <p class="labeled"><img src="{{asset('assets/web/images/icons/loc-mouve.svg')}}" alt="" class="icon"> {{__('halls.street')}}</p>
                                            <h6 class="data mb-4"><b>{{$hall->street}}</b></h6>
                                        </div>

                                        <div class="col-lg-3 col-6">
                                            <p class="labeled"><img src="{{asset('assets/web/images/icons/loc-mouve.svg')}}" alt="" class="icon"> {{__('halls.sector_id')}}</p>
                                            <h6 class="data mb-4"><b>{{$hall->sector_name}}</b></h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{-- Map block--}}


{{--                            <div class="col-md-12">--}}
{{--                                <div class="occasion_wrapper">--}}
{{--                                    <h5 class="headline mt-5 mb-4"><img src="{{asset('assets/web/images/icons/hall_description.png')}}" alt="" class="icon"> {{__('halls.description')}} </h5>--}}
{{--                                    <h6>{!! $hall->hall_description !!}</h6>--}}
{{--                                </div>--}}
{{--                            </div>--}}

                            <!-- occasion_wrapper -->
                            <div class="col-md-12">
                                <div class="occasion_wrapper">
                                    <h5 class="headline mt-5 mb-4"><img src="{{asset('assets/web/images/icons/selectbox-4.svg')}}" alt="" class="icon"> {{__('halls.your_occasions')}} </h5>
                                    <div class="avail_cards">
                                        <div class="row">
                                            @if(count($occasions))
                                                @foreach($occasions as $occasion)
                                                    <div class="col-lg-3">
                                                        <div class="avail_card">
                                                            <div class="icon mb-2">
                                                                <img src="{{asset($occasion->image ?? 'assets/web/images/icons/oc_1.png')}}" alt="">
                                                            </div>
                                                            <h5>{{$occasion->name}}</h5>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            @endif
                                        </div>
                                    </div>
                                    {{--                                    <div class="avail_occasion d-block">--}}
                                    {{--                                        <div class="row">--}}
                                    {{--                                            @if(count($occasions))--}}
                                    {{--                                                @foreach($occasions as $occasion)--}}
                                    {{--                                                    <div class="col-lg-4">--}}
                                    {{--                                                        <div class="card_occasion">--}}
                                    {{--                                                            <div class="img">--}}
                                    {{--                                                                <img src="{{asset($occasion->image ?? 'assets/web/images/wedding.jpg')}}" alt="">--}}
                                    {{--                                                            </div>--}}
                                    {{--                                                            <div class="info">--}}
                                    {{--                                                                <p class="p">{{$occasion->name}}</p>--}}
                                    {{--                                                            </div>--}}
                                    {{--                                                        </div>--}}
                                    {{--                                                    </div>--}}
                                    {{--                                                @endforeach--}}
                                    {{--                                            @endif--}}
                                    {{--                                        </div>--}}
                                    {{--                                    </div>--}}
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="occasion_wrapper">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <h5 class="headline mt-5 mb-4"><img src="{{asset('assets/web/images/icons/selectbox-4.svg')}}" alt="" class="icon"> {{__('halls.halls_options')}} </h5>
                                        </div>
                                        <div class="col-lg-6 text-left">
                                            <div class="swiper-button-next"></div>
                                            <div class="swiper-button-prev"></div>
                                        </div>
                                    </div>
                                    <div class="avail_occasion d-block">
                                        <div class="avail_occasion_slider swiper-container">
                                            <div class="swiper-wrapper">
                                                @if(count($tables))
                                                @foreach($tables as $table)
                                                    <div class="swiper-slide">
                                                        <div class="card_occasion">
                                                            <div class="img">
                                                                <img src="{{asset($table->image ?? 'assets/web/images/wedding.jpg')}}" alt="">
                                                            </div>
                                                            <div class="info">
                                                                <p class="p">{{$table->name}}</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                                @endif
                                            </div>
                                        </div>
                                        <!--<div class="row">-->
                                        <!--    @if(count($tables))-->
                                        <!--        @foreach($tables as $table)-->
                                        <!--            <div class="col-lg-4">-->
                                        <!--                <div class="card_occasion">-->
                                        <!--                    <div class="img">-->
                                        <!--                        <img src="{{asset($table->image ?? 'assets/web/images/wedding.jpg')}}" alt="">-->
                                        <!--                    </div>-->
                                        <!--                    <div class="info">-->
                                        <!--                        <p class="p">{{$table->name}}</p>-->
                                        <!--                    </div>-->
                                        <!--                </div>-->
                                        <!--            </div>-->
                                        <!--        @endforeach-->
                                        <!--    @endif-->
                                        <!--</div>-->
                                    </div>
                                </div>
                            </div>



                            <!-- Meet services details -->
                            @if(count($services))
                            <div class="col-lg-12 m-auto" >
                                <h5 class="headline mt-5 mb-4">  {{__('halls.approved_services')}} <b class="dir-l">{{__('halls.meet')}}</b></h5>
                                <div class="row ">
                                    @foreach($services as $service)
                                        <div class="col-lg-4 col-md-6">
                                            <div class="serv_card">
                                                <div class="img-box">
                                                    <img src="{{asset($service->image)}}" alt="" class="serv-img">
                                                </div>
                                                <div class="card-body">
                                                    <h6 class="title"><b>{{$service->name}}</b></h6>
                                                    <p class="p">{{stripText($service->description, 30)}}</p>
                                                    <h4 class="price dir-l mb-0"><b>{{$service->price}}</b> <small>SAR</small> <span class="fs_sm">({{__('halls.per_person')}})</span></h4>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            @endif
                            <!-- Additional services details -->
                            <div class="col-md-12  mb-5">
                                <h5 class="headline mt-5 mb-4">{{__('halls.added_services')}}</h5>
                                <div class="row">
                                    <div class="col-lg-12 m-auto">
                                        <div class="row">
                                            @if(count($addedServices))
                                                @foreach($addedServices as $addedService)
                                                    <div class="col-lg-4 col-md-6">
                                                        <div class="serv_card">
                                                            <div class="img-box">
                                                                <img src="{{asset($addedService['image'] ?? 'assets/web/images/icons/added_service_alt_img.png' ?? $logo)}}" alt="" class="serv-img">
                                                            </div>
                                                            <div class="card-body">
                                                                <h6 class="title"><b>{{$addedService['name']}}</b></h6>
                                                            <!--<p class="p">{{stripText($addedService['description'], 30)}}</p>-->
                                                                <p class="p discr">{{stripText($addedService['description'])}}</p>
                                                                <!--<span class="more_btn">كل التفاصيل </span>-->
                                                                <h4 class="price dir-l mb-0"><b>{{$addedService['price']}}</b> <small>{{__('main.sar')}}</small> <span class="fs_sm">({{__('halls.per_person')}})</span></h4>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- Reviews Swiper -->
                            @if(count($evaluates))
                                <div class="col-md-12 mb-5">
                                    <h5 class="headline mb-4">  {{__('halls.customer_reviews')}} </h5>
                                    <div class="review-swiper swiper-container">
                                        <div class="swiper-wrapper pb-5">
                                            @foreach($evaluates as $evaluate)
                                                <div class="swiper-slide">
                                                    <div class="reciew-card">
                                                        <div class="row">
                                                            <div class="col-md-4">
                                                                <div class="profile-img">
                                                                    <img src="{{asset($evaluate->user_photo ?? 'assets/web/images/icons/user.svg')}}" alt="">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-8">
                                                                <div class="review-content">
                                                                    <h6>{{$evaluate->user_name}}</h6>
                                                                    <div class="rate">
                                                                        <i class="fas fa-star {{$evaluate->evaluate_average >= 1 ? 'active' : ''}}"></i>
                                                                        <i class="fas fa-star {{$evaluate->evaluate_average >= 2 ? 'active' : ''}}"></i>
                                                                        <i class="fas fa-star {{$evaluate->evaluate_average >= 3 ? 'active' : ''}}"></i>
                                                                        <i class="fas fa-star {{$evaluate->evaluate_average >= 4 ? 'active' : ''}}"></i>
                                                                        <i class="fas fa-star {{$evaluate->evaluate_average >= 5 ? 'active' : ''}}"></i>
                                                                    </div>
                                                                    <p>{{$evaluate->comment}}</p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                        <!-- Add Pagination -->
                                        <div class="swiper-pagination"></div>
                                    </div>
                                </div>
                            @endif


                            <div class="col-md-12">
                                <div class="hall_tabs mb-5">
                                    <div class="text-center">
                                        <ul class="nav nav-pills mb-4" id="pills-tab" role="tablist">
                                            <li class="nav-item" role="presentation">
                                                <a href="#0" class="nav-link active" id="pills-description-tab" data-toggle="pill" data-target="#pills-description" type="button" role="tab" aria-controls="pills-description" aria-selected="true">
                                                    {{__('halls.description')}}
                                                </a>
                                            </li>
                                            <li class="nav-item" role="presentation">
                                                <a href="#0" class="nav-link" id="pills-features-tab" data-toggle="pill" data-target="#pills-features" type="button" role="tab" aria-controls="pills-features" aria-selected="false">
                                                    {{__('halls.features')}}
                                                </a>
                                            </li>
                                            <li class="nav-item" role="presentation">
                                                <a href="#0" class="nav-link" id="pills-condition-tab" data-toggle="pill" data-target="#pills-condition" type="button" role="tab" aria-controls="pills-condition" aria-selected="true">
                                                    {{__('halls.reservation_condition')}}
                                                </a>
                                            </li>

{{--                                            <li class="nav-item" role="presentation">--}}
{{--                                                <a href="#0" class="nav-link" id="pills-map-tab" data-toggle="pill" data-target="#pills-map" type="button" role="tab" aria-controls="pills-map" aria-selected="false">--}}
{{--                                                    {{__('halls.hall_location')}}--}}
{{--                                                </a>--}}
{{--                                            </li>--}}
                                        </ul>
                                    </div>
                                    <div class="tab-content" id="pills-tabContent">
                                        <div class="tab-pane fade show active" id="pills-description" role="tabpanel" aria-labelledby="pills-description-tab">
                                            <div class="col-md-12">
                                                <div class="occasion_wrapper">
                                                    <h5 class="headline mt-5 mb-4"><img src="{{asset('assets/web/images/icons/hall_description.png')}}" alt="" class="icon"> {{__('halls.description')}} </h5>
                                                    <h6>{!! $hall->hall_description !!}</h6>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="pills-features" role="tabpanel" aria-labelledby="pills-features-tab">
                                            {!! $hall->features !!}
                                        </div>
                                        <div class="tab-pane fade" id="pills-condition" role="tabpanel" aria-labelledby="pills-condition-tab">
                                            {!! $hall->reservation_condition !!}
                                        </div>
{{--                                        <div class="tab-pane fade" id="pills-map" role="tabpanel" aria-labelledby="pills-map-tab">--}}
{{--                                            <div class="col-lg-12">--}}
{{--                                                <h5 class="headline mt-5 mb-4"><img src="{{asset('assets/web/images/icons/loc-blue.svg')}}" alt="" class="icon"> {{__('halls.hall_location')}}</h5>--}}
{{--                                            </div>--}}

{{--                                            <div class="col-md-12">--}}
{{--                                                <div class="map-box">--}}
{{--                                                    <div style="border:0; height: 400px; width: 100%" class="map" id="map"></div>--}}
{{--                                                </div>--}}
{{--                                            </div>--}}
{{--                                            <div class="col-md-12">--}}
{{--                                                <div class="hall_contacts">--}}
{{--                                                    <div class="row">--}}
{{--                                                        <div class="col-lg-3 col-6">--}}
{{--                                                            <p class="labeled"><img src="{{asset('assets/web/images/icons/loc-mouve.svg')}}" alt="" class="icon"> {{__('halls.city_id')}}</p>--}}
{{--                                                            <h6 class="data mb-4"><b>{{$hall->city_name}}</b></h6>--}}
{{--                                                        </div>--}}

{{--                                                        <div class="col-lg-3 col-6">--}}
{{--                                                            <p class="labeled"><img src="{{asset('assets/web/images/icons/loc-mouve.svg')}}" alt="" class="icon"> {{__('halls.region_id')}}</p>--}}
{{--                                                            <h6 class="data mb-4"><b>{{$hall->region_name}}</b></h6>--}}
{{--                                                        </div>--}}

{{--                                                        <div class="col-lg-3 col-6">--}}
{{--                                                            <p class="labeled"><img src="{{asset('assets/web/images/icons/loc-mouve.svg')}}" alt="" class="icon"> {{__('halls.street')}}</p>--}}
{{--                                                            <h6 class="data mb-4"><b>{{$hall->street}}</b></h6>--}}
{{--                                                        </div>--}}

{{--                                                        <div class="col-lg-3 col-6">--}}
{{--                                                            <p class="labeled"><img src="{{asset('assets/web/images/icons/loc-mouve.svg')}}" alt="" class="icon"> {{__('halls.sector_id')}}</p>--}}
{{--                                                            <h6 class="data mb-4"><b>{{$hall->sector_name}}</b></h6>--}}
{{--                                                        </div>--}}
{{--                                                    </div>--}}
{{--                                                </div>--}}
{{--                                            </div>--}}
{{--                                        </div>--}}
                                    </div>
                                </div>
                            </div>

                            <!--<div class="col-md-12">-->
                            <!--    <div class="occasion_wrapper">-->
                        <!--        <h5 class="headline mt-5 mb-4"><img src="{{asset('assets/web/images/icons/hall_description.png')}}" alt="" class="icon"> {{__('halls.reservation_condition')}} </h5>-->
                        <!--        <h6>{!! $hall->reservation_condition !!}</h6>-->
                            <!--    </div>-->
                            <!--</div>-->

                            <!--<div class="col-md-12">-->
                            <!--    <div class="occasion_wrapper">-->
                        <!--        <h5 class="headline mt-5 mb-4"><img src="{{asset('assets/web/images/icons/hall_description.png')}}" alt="" class="icon"> {{__('halls.features')}} </h5>-->
                        <!--        <h6>{!! $hall->features !!}</h6>-->
                            <!--    </div>-->
                            <!--</div>-->


                            <!-- reserv_date -->
                        {{--                            <div class="col-md-10">--}}
                        {{--                                <div class="reserv_date">--}}
                        {{--                                    <h5 class="headline mt-5 mb-4"><img src="{{asset('assets/web/images/icons/advances-search-5.svg')}}" alt="" class="icon"> فترة الحجز </h5>--}}
                        {{--                                    <form class="d-flex">--}}
                        {{--                                        <input type="text" placeholder="{{ __('halls.available_dates_from') }}" name="available_dates_to" value="" class="available_dates form-control ml-2 datepicker" autocomplete="off" autofocus required>--}}
                        {{--                                        <input type="text" placeholder="{{ __('halls.available_dates_to') }}" name="available_dates_from" value="" class="available_dates form-control ml-2 datepicker" autocomplete="off" autofocus required>--}}
                        {{--                                    </form>--}}
                        {{--                                </div>--}}
                        {{--                            </div>--}}
                        <!-- Location details -->




                            <!-- Reserv-Butn -->
                            <div class="btns-wrapper mt-5">
                                <a href="{{route('reservation.hallReservation', $hall->id)}}" class="butn refuse-butn">{{__('halls.book_now')}}</a>
                            </div>
                            <!-- Note -->
                            <div class="col-lg-12">
                                <div class="note mt-5">
                                    <img src="{{asset('assets/web/images/saudi_exhibition_logo.png')}}" alt="" class="saudi_logo">
                                    <span class="text"> <b>{!! __('halls.hall_footer_title') !!}</b></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('inner_js')
    <script src="{{ asset('assets/web/js/lib/toastr.min.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lib/jquery-ui.js') }}"></script>
    {{--    <script src="{{ asset('assets/web/js/lib/datepicker.min.js') }} "></script>--}}

    <script src="https://polyfill.io/v3/polyfill.min.js?features=default"></script>
    <script defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDpVcBEVHKN5-iO0-z5MoEeLLpfV18JZjg&callback=initMap"></script>

    <script>

        let latitude = "{{$hall->lat}}",
            longitude = "{{$hall->lng}}",
            linkCopiedTitle = "{{__('halls.link_copied')}}";

        let marker;
        function initMap() {
            var map = new google.maps.Map(document.getElementById("map"), {
                zoom: 7,
                center: { lat: parseFloat(latitude) , lng: parseFloat(longitude) }
            });


            marker = new google.maps.Marker({
                map: map,
                draggable: false,
                animation: google.maps.Animation.DROP,
                position: {  lat: parseFloat(latitude) , lng: parseFloat(longitude) }
            });

        }
    </script>

    <script>
        $(".serv_card .card-body .more_btn").on("click" , function(){
            $(this).siblings(".discr").css("height" , "max-content");
            $(this).fadeOut();
        });

        $('.copy_to_share_link').click(function (e) {
            e.preventDefault();
            navigator.clipboard.writeText($(this).attr('href'));
            toasterSuccess(linkCopiedTitle);

        });

    </script>

    <script>
        var swiper = new Swiper('.avail_occasion_slider', {
            // slidesPerView: 3,
            spaceBetween: 30,
            // centeredSlides: true,
            speed: 1000,
            pagination: {
                el: ".avail_occasion_slider .swiper-pagination",
                clickable: true,
            },
            navigation: {
                nextEl: '.occasion_wrapper .swiper-button-prev',
                prevEl: '.occasion_wrapper .swiper-button-next',
            },
            mousewheel: false,
            keyboard: true,
            autoplay: {
                delay: 5000,
            },
            loop: false,
            breakpoints: {
                0: {
                    slidesPerView: 1,
                },
                480: {
                    slidesPerView: 2,
                },
                787: {
                    slidesPerView: 2,
                },
                991: {
                    slidesPerView: 3,
                },
                1200: {
                    slidesPerView: 3,
                }
            }
        });
    </script>



@endsection

