@if ($paginator->hasPages())
    <nav class="w-100">
        <ul class="butns d-flex justify-content-between align-items-center">
            {{-- Previous Page Link --}}
            @if ($paginator->onFirstPage())
                <li class="disabled p-5" aria-disabled="true">
                    <span class="butn subb">@lang('pagination.previous')</span>
                </li>
            @else
                <li class="butns d-flex justify-content-between p-5">
                    <a class="butn subb previous_hall_link" href="{{ $paginator->previousPageUrl() }}" rel="prev">@lang('pagination.previous')</a>
                </li>
            @endif

            <li>
                <nav aria-label="...">
                  <ul class="pagination">
                    <li class="page-item active" aria-current="page">
                      <span class="page-link">1</span>
                    </li>
                    <li class="page-item"><a class="page-link" href="#">2</a></li>
                    <li class="page-item"><a class="page-link" href="#">3</a></li>
                  </ul>
                </nav>
            </li>

            {{-- Next Page Link --}}
            @if ($paginator->hasMorePages())
                <li class="p-5">
                    <a class="butn subb next_hall_link" href="{{ $paginator->nextPageUrl() }}" rel="next">@lang('pagination.next')</a>
                </li>
            @else
                <li class="disabled p-5" aria-disabled="true">
                    <span class="butn subb">@lang('pagination.next')</span>
                </li>
            @endif
        </ul>
    </nav>
@endif
