@if ($paginator->hasPages())
    <nav class="w-100">
        <ul class="butns d-flex justify-content-between align-items-center">
            {{-- Previous Page Link --}}
            @if ($paginator->onFirstPage())
                <li class="disabled p-5" aria-disabled="true">
                    <span class="butn subb">@lang('pagination.previous')</span>
                </li>
            @else
                <li class="butns d-flex justify-content-between p-5">
                    <a class="butn subb previous_hall_link" href="{{ $paginator->previousPageUrl() }}" rel="prev">@lang('pagination.previous')</a>
                </li>
            @endif

            <li>
                <nav aria-label="...">
                    <ul class="pagination">
                        @foreach ($elements as $element)
                            {{-- "Three Dots" Separator --}}
                            @if (is_string($element))
                                <li class="page-item active" aria-current="page">
                                    <span class="page-link">{{$element}}</span>
                                </li>
                            @endif
                            @if (is_array($element))
                                @foreach ($element as $page => $url)
                                    @if ($page == $paginator->currentPage())
                                        <li class="page-item active" aria-current="page">
                                            <a onclick="return false" class="page-link" href="#"><span>{{ $page }}</span></a>
                                        </li>
                                    @else
                                        <li class="page-item"><a class="page-link next_hall_link" href="{{ $url }}">{{ $page }}</a></li>
                                    @endif
                                @endforeach
                            @endif
                        @endforeach
                    </ul>
                </nav>
            </li>
            {{-- Pagination Elements --}}
{{--            @foreach ($elements as $element)--}}
{{--                --}}{{-- "Three Dots" Separator --}}
{{--                @if (is_string($element))--}}
{{--                    <li class="page-item active" aria-disabled="true"><span>{{ $element }}</span></li>--}}
{{--                @endif--}}

{{--                --}}{{-- Array Of Links --}}
{{--                @if (is_array($element))--}}
{{--                    @foreach ($element as $page => $url)--}}
{{--                        @if ($page == $paginator->currentPage())--}}
{{--                            <li class="page-item active" aria-current="page"><span>{{ $page }}</span></li>--}}
{{--                        @else--}}
{{--                            <li class="page-item"><a class="page-link next_hall_link" href="{{ $url }}">{{ $page }}</a></li>--}}
{{--                        @endif--}}
{{--                    @endforeach--}}
{{--                @endif--}}
{{--            @endforeach--}}

            {{-- Next Page Link --}}
            @if ($paginator->hasMorePages())
                <li class="p-5">
                    <a class="butn subb next_hall_link" href="{{ $paginator->nextPageUrl() }}" rel="next">@lang('pagination.next')</a>
                </li>
            @else
                <li class="disabled p-5" aria-disabled="true">
                    <span class="butn subb">@lang('pagination.next')</span>
                </li>
            @endif
        </ul>
    </nav>
@endif
