@if(count($halls))
    @foreach($halls as $hall)
        <div class="col-md-6 col-lg-4">
            <div class="hall-card">
                <div class="img-box">
                    <a href="{{route('hall.show', $hall->id)}}" target="_blank">
                        <img src="{{getPhotoThumb($hall->images[0])}}" alt="">
                        @if($hall->rate)
                            <span class="rate-badge"><i class="far fa-star"></i> {{$hall->rate}}</span>
                        @endif
                        <span class="badge">{{$hall->category_name}}</span>
                    </a>
                </div>
                <a title="{{__('halls.copy_to_share')}}" href="{{route('hall.show', $hall->id)}}" class="copy_to_share_link col-lg-12 d-flex justify-content-end"><i class="fas fa-share fa-2x"></i></a>
                <div class="card-body">
                    <div class="prof-info">
                        <img src="{{asset($hall->provider_logo)}}" alt="" class="prof_img">
                        <div class="text">
                            <span class="provider">{{__('main.provider')}}</span>
                            <h6 class="name mb-0">{{$hall->provider_name}}</h6>
                        </div>
                    </div>
                    <h5 class="headline">{{$hall->hall_name}}</h5>
                    <p class="city-name"><img src="{{asset('assets/web/images/icons/loc-blue.svg')}}" alt="" class="icon"> {{$hall->city_name}}</p>
                    @if($hall->reservation_type == 'person_count')
                        <p class="price">{{__('main.start_from')}} <span class="dir-l"><b>{{$hall->booking_amount_per_person}} {{__('main.sar')}}</b></span>
                        {{(__('main.per_person'))}}
                    @endif
                    @if($hall->reservation_type == 'days_count')
                        <p class="price">{{__('main.start_from')}} <span class="dir-l"><b>{{$hall->booking_amount_per_day}} {{__('main.sar')}}</b></span>
                            {{(__('main.per_day'))}}
                            @endif
                            <a href="{{route('reservation.hallReservation', $hall->id)}}" class="link-btn my-3"> {{__('main.book_now')}}  </a>
                </div>
            </div>
        </div>
    @endforeach
    {{-- Ites for hide load more button if count less than 9 --}}
    @if(count($halls) < 9)
    <div class="show_done"></div>
    @endif
@else
    <div  style="background-color: #25B0A8" class="alert text-white text-center col-md-12 show_done">{{__('members.no_data')}}</div>
@endif
