@extends('web.layouts.container')

@section('content')

    <section class="page-heading">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}">{{__('main.home')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{__('abouts.head')}}</li>
                </ol>
                <h3>{{__('abouts.head')}}</h3>
            </nav>
        </div>
        <img src="{{asset('assets/web/images/page-heading-1.png')}}" alt="" class="pattern1">
        <img src="{{asset('assets/web/images/page-heading-2.png')}}" alt="" class="pattern2">
        <img src="{{asset('assets/web/images/page-heading-3.png')}}" alt="" class="pattern3">
    </section>

    <section class="about-sec">
        <div class="container">
            <div class="row pt-4">
                <div class="col-lg-6">
                    <div class="img-box">
                        <img src="{{asset($about->image)}}" alt="" class="about-img wow zoomIn" data-wow-duration="2s">
                        <img src="{{asset('assets/web/')}}/images/pattern-3.png" alt="" class="pattern1 wow fadeInRight" data-wow-duration="2s">
                        <img src="{{asset('assets/web/')}}/images/pattern-4.png" alt="" class="pattern2">
                        <a data-fancybox href="{{$about->video}}" class="play-btn wow zoomIn" data-wow-duration="2s">
                            <img src="{{asset('assets/web/images/icons/play-button.svg')}}" alt="" class="icon">
                        </a>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="text-box wow text-focus-in">
                        <h2 class="headline">{{$about->title}}</h2>
                        <p class="pargraph">{!! $about->description !!}</p>
                        <ul class="features-ul mt-4">
                            @if(count($lists))
                                @foreach($lists as $list)
                                    @if($list == '') @continue @endif
                                    <li>{{$list}}</li>
                                @endforeach
                            @endif
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="features-sec">
        <div class="container">
            <div class="sec-heading wow fadeInUp" data-wow-duration="2s">
                <span class="icon"><img src="{{asset('assets/web/images/sec-heading-1.png')}}" alt=""></span>
                <h3>{{__('main.why_us')}}</h3>
            </div>
            <div class="row">
                <div class="col-lg-4">
                    <div class="feature-card wow fadeInLeft" data-wow-duration="2s">
                        <div class="content">
                            <h5 class="headline">{{$about->why_us_first_title}}</h5>
                            <p class="paragraph">{!! $about->why_us_first_description !!}</p>
                            <img src="{{asset('assets/web/images/icon.png')}}" alt="" class="icon mt-4">
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="feature-card wow fadeInUp" data-wow-duration="2s" data-wow-delay=".6s">
                        <div class="content">
                            <h5 class="headline">{{$about->why_us_second_title}}</h5>
                            <p class="paragraph">{!! $about->why_us_second_description !!}</p>
                            <img src="{{asset('assets/web/images/icon.png')}}" alt="" class="icon mt-4">
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="feature-card wow fadeInRight" data-wow-duration="2s">
                        <div class="content">
                            <h5 class="headline">{{$about->why_us_third_title}}</h5>
                            <p class="paragraph">{!! $about->why_us_third_description !!}</p>
                            <img src="{{asset('assets/web/images/icon.png')}}" alt="" class="icon mt-4">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('inner_js')

@endsection
