@extends('admin.layouts.container')
@section('css')
    <link rel="stylesheet" href="{{asset('assets/admin/css/lib/toastr.css')}}">
@endsection
@section('content')
    <form>
        <div class="side-title">
            <div class="row">
                <div class="col-lg-6">
                    <h3>{{ $title }}</h3>
                </div>
{{--                <div class="col-lg-6 valign">--}}
{{--                    <div class="edit-buttons text-right w-100">--}}
{{--                        <a href="{{ route ('wallets.destroyAll') }}" data-method="delete" class="butn statusButns status_1 tableAction btn disabled bg-warning"> <span>{{ __('dashboard.sendToTrash') }}</span></a>--}}
{{--                        <a href="#" class="butn statusButns status_1 showArchive bg-primary"> <span> {{ __('dashboard.displayTrash') }} </span></a>--}}

{{--                        <a href="{{ route ('wallets.destroyAll') }}" data-method="delete" class="butn statusButns status_0 tableAction btn disabled bg-danger force"> <span> {{ __('dashboard.delete') }} </span></a>--}}
{{--                        <a href="{{ route ('wallets.restoreAll') }}" data-method="put" class="butn statusButns status_0 tableAction btn disabled bg-info"> <span> {{ __('dashboard.restore') }} </span></a>--}}
{{--                        <a href="#" class="butn statusButns status_0 showActive bg-primary"> <span> {{ __('dashboard.displayActive') }} </span></a>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--                <div class="col-lg-12 valign">--}}
{{--                    <div class="edit-buttons text-right w-100 d-flex justify-content-start">--}}
{{--                        <a href="{{ route ('walletsReport') }}"  class="butn btn bg-secondary"><span><i class="fa fa-file-excel"></i> {{ __('wallets.export_excel') }}</span></a>--}}
{{--                    </div>--}}
{{--                </div>--}}
            </div>
        </div>

        <!-- ------------ data table ------------- -->
        <div class="overflow_x">
            <table class="table table-hover table-bordered">
                <thead>
                <tr>
{{--                    <th scope="col">--}}
{{--                        <div class="custom-control custom-checkbox">--}}
{{--                            <input type="checkbox" class="custom-control-input" id="selectall" name="example1">--}}
{{--                            <label class="custom-control-label" for="selectall"> </label>--}}
{{--                        </div>--}}
{{--                    </th>--}}
                    <th scope="col">#</th>
                    <th scope="col">{{ __('halls.images') }}</th>
                    <th scope="col">{{ __('halls.name') }}</th>
                    <th scope="col">{{ __('halls.client_name') }}</th>
                    <th scope="col">{{ __('halls.client_phone') }}</th>
                    <th scope="col">{{ __('halls.reservation_date') }}</th>
                    <th scope="col">{{ __('reservations.person_count') }}</th>
                    <th scope="col">{{ __('reservations.service') }}</th>
                    <th scope="col">{{ __('reservations.added_services') }}</th>
                    <th scope="col">{{ __('reservations.services_amount') }}</th>
                    <th scope="col">{{ __('reservations.added_services_amount') }}</th>
                    <th scope="col">{{ __('reservations.added_value_amount') }}</th>
                    <th scope="col">{{ __('reservations.total') }}</th>
                    <th scope="col">{{ __('reservations.site_percentage') }}</th>
                    <th scope="col">{{ __('reservations.net_total') }}</th>

{{--                    <th scope="col" colspan="2">{{ __('dashboard.created_at') }}</th>--}}
                    <th scope="col">{{ __('dashboard.processes') }}</th>
                    <th scope="col">{{ __('reservations.is_paid') }}</th>
                </tr>
                </thead>

                <tbody class="response">
                    <tr class="search_filter_form"></tr>
                </tbody>
            </table>
        </div>

        <!-- ------------ sidemenu links ------------- -->
    </form>
@endsection



<script>
    /**
     * Importat to handle ajax requests for filters, deletes, trash and any proccess done on the table's data
     */
    var dataTable={
        route: '{{ route("wallets.reservationGrid", $wallet) }}'
    };

    let paidStatusRoute = "{{route('wallets.paidStatus')}}"
</script>
@section('inner_js')
    <script src="{{ asset('assets/admin/js/lib/toastr.min.js') }}"></script>

    <script>
        $(document).ready(function () {
            $(document).on('change', 'select[name="is_paid"]' , async function (e) {
                e.preventDefault();
                let url = paidStatusRoute,
                    data = {reservation_id: $(this).data('reservation'), is_paid: $(this).val()},
                    method = 'get';

                if ($(this).val() !== ''){
                    const response=await ajax({
                        url,
                        data,
                        dataType: 'json',
                        method,
                    });
                    if (response.message) {
                        toasterSuccess(response.message)
                    }
                    if (response.errors) {
                        toasterError(response.errors)
                    }
                }

            });
        });
    </script>
@endsection
