@extends('admin.layouts.container')
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/toastr.css') }}" />
@endsection
@section('content')
    <div class="side-title">
        <h3>{{ $head ?? '' }}</h3>
    </div>

    <div class="border-item">
        <form class="form-row add_member_form" method="post" action="{{ $action }}">
            @if($member ?? ''  && $member->id)
                @method('PUT')
            @endif
            @csrf

                <div class="col-md-4">
                    <div class="custom-control custom-checkbox">
                        <input type="checkbox" {{ in_array($occasion->id, $hall['occasions'] ?? []) ? 'checked' : '' }} value="{{ $occasion->id }}" class="custom-control-input" id="occasions_{{ $occasion->id }}" name="occasions[]">
                        <label class="custom-control-label" for="occasions_{{ $occasion->id }}"> {{$occasion->name}}</label>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="custom-control custom-checkbox">
                        <input type="checkbox" {{ in_array($occasion->id, $hall['occasions'] ?? []) ? 'checked' : '' }} value="{{ $occasion->id }}" class="custom-control-input" id="occasions_{{ $occasion->id }}" name="occasions[]">
                        <label class="custom-control-label" for="occasions_{{ $occasion->id }}"> {{$occasion->name}}</label>
                    </div>
                </div>

            <div class="form-group col-lg-4">
                <label>{{ meta('name', getCurrentLocale()) ?? __('members.name') }} </label>
                <input type="text" class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" name="name" placeholder="{{ meta('name', getCurrentLocale()) ??__('members.name') }}" value='{{ old("name", $member->name ?? "") }}'/>
            </div>
            <div class="form-group col-lg-3">
                <label>{{ meta('email', getCurrentLocale()) ?? __('members.email') }} </label>
                <input type="text" class="form-control {{ $errors->has('email') ? 'is-invalid' : '' }}" name="email" placeholder="{{ meta('email', getCurrentLocale()) ?? __('members.email') }}" value='{{ old("email", $member->email ?? "") }}' {{ ($member->email ?? null)}}/>
            </div>
            <div class="form-group col-lg-3">
                <label>{{ meta('phone', getCurrentLocale()) ?? __('members.phone') }} </label>
                <input type="text" class="form-control {{ $errors->has('phone') ? 'is-invalid' : '' }}" name="phone" placeholder="{{ meta('phone', getCurrentLocale()) ?? __('members.phone') }}" value='{{ old("phone", $member->phone ?? "") }}'/>
            </div>

            <div class="form-group col-lg-4 show_in_provider d-none">
                <label>{{ meta('region_id', $local) ?? __('halls.region_id') }} </label>
                <select name="region_id" class="form-control">
                    <option value="">{{ meta('region_id', $local) ?? __('halls.region_id') }}</option>
                    @if(count($regions))
                        @foreach($regions as $region)
                            <option {{($member->region_id ?? null) == $region->id ? 'selected': ''}} value="{{$region->id}}">{{$region->name}}</option>
                        @endforeach
                    @endif
                </select>
            </div>
            <div class="form-group col-lg-4 show_in_provider d-none">
                <label>{{ meta('city_id', $local) ?? __('halls.city_id') }} </label>
                <select name="city_id" class="form-control">
                    <option value="">{{ meta('city_id', $local) ?? __('halls.city_id') }}</option>
                    @if(count($cities))
                        @foreach($cities as $city)
                            <option {{($member->city_id ?? null) == $city->id ? 'selected': ''}} value="{{$city->id}}">{{$city->name}}</option>
                        @endforeach
                    @endif
                </select>
            </div>
            <div class="form-group col-lg-4 show_in_provider d-none">
                <label>{{ meta('sector_id', $local) ?? __('halls.sector_id') }} </label>
                <select name="sector_id" class="form-control">
                    <option value="">{{ meta('sector_id', $local) ?? __('halls.sector_id') }}</option>
                    @if(count($sectors))
                        @foreach($sectors as $sector)
                            <option {{($member->sector_id ?? null) == $sector->id ? 'selected': ''}} value="{{$sector->id}}">{{$sector->name}}</option>
                        @endforeach
                    @endif
                </select>
            </div>

                <div class="form-group col-lg-12 show_in_provider d-none">
                    <label>{{ meta('street', getCurrentLocale()) ?? __('members.street') }} </label>
                    <input type="text" class="form-control {{ $errors->has('street') ? 'is-invalid' : '' }}" name="street" placeholder="{{ meta('street', getCurrentLocale()) ?? __('members.street') }}" value='{{ old("street", $member->street ?? "") }}'/>
                </div>

            <div class="form-group col-lg-6">
                <label>{{ meta('password', getCurrentLocale()) ?? __('members.password') }} </label>
                <input type="password" class="form-control {{ $errors->has('password') ? 'is-invalid' : '' }}" name="password" placeholder="{{ meta('password', getCurrentLocale()) ?? __('members.password') }}" value='{{ old("password", "") }}'/>
            </div>

            <div class="form-group col-lg-6">
                <label>{{ meta('password_confirmation', getCurrentLocale()) ?? __('members.password_confirmation') }} </label>
                <input type="password" class="form-control {{ $errors->has('password_confirmation') ? 'is-invalid' : '' }}" name="password_confirmation" placeholder="{{ meta('password_confirmation', getCurrentLocale()) ?? __('members.password_confirmation') }}" value='{{ old("password_confirmation", "") }}'/>
            </div>

            <div class="text-center mt-5 col-12">
                <button class="butn add_member_button"><span>{{ __('dashboard.save') }}</span></button>
            </div>
        </form>
    </div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
    {{--        <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>--}}
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{--    <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    {{--    <script src="https://cdn.tiny.cloud/1/cvo4dn512c81ken3vhruwrooatptt4zew0lyb0ey4pas8mp1/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>--}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            imagePath = "{{asset('')}}",
            inputName = null,
            currentLanguage = "{{$local}}",
            getCityAndSectorRoute = "{{route('members.getCityAndSector')}}";
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>
    <script src="{{ asset('assets/web/js/lib/toastr.min.js') }}"></script>


    <script>

        let selectOption = $('select[name="role"] option:selected').val();
        if (selectOption === 'user'){
            $('.show_in_provider').addClass('d-none');
        }
        if(selectOption === 'provider') {
            $('.show_in_provider').removeClass('d-none');
        }
        $('select[name="role"]').change(function () {
            if($(this).val() === 'user'){
                $('.show_in_provider').addClass('d-none');
                $('.show_in_provider input').val('');
                $('.show_in_provider select').val('');
            }
            if($(this).val() === 'provider') {
                $('.show_in_provider').removeClass('d-none');
            }
        });

        $('.add_member_button').click(async function (e) {
            e.preventDefault();

            let form = $('.add_member_form'),
                data = new FormData(form[0]),
                url = form.attr('action'),
                method = form.attr('method');

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.url){
                window.location.href = response.url;
            }

            if (response.errors){
                toasterError(response.errors);
            }
        });

        $('select[name="region_id"], select[name="city_id"]').change(async function (e) {
            e.preventDefault();

            let data = {},
                url = getCityAndSectorRoute,
                method = 'get';

            if($(this).attr('name') === 'region_id'){
                $('select[name="city_id"]').html(`<option value="">{{ __('halls.city_id') }}</option>`);
                $('select[name="sector_id"]').html(`<option value="">{{ __('halls.sector_id') }}</option>`);

                data.region_id = $(this).val();
            }
            if($(this).attr('name') === 'city_id'){
                $('select[name="sector_id"]').html(`<option value="">{{ __('halls.sector_id') }}</option>`);
                data.city_id = $(this).val();
            }

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.status === 'city'){
                if (response.data.length){
                    for (let i = 0; i < response.data.length; i++){
                        $('select[name="city_id"]').append(`<option value="`+response.data[i].id+`">`+response.data[i].name+`</option>`)
                    }
                }
            }
            if (response.status === 'sector'){
                if (response.data.length){
                    for (let i = 0; i < response.data.length; i++){
                        $('select[name="sector_id"]').append(`<option value="`+response.data[i].id+`">`+response.data[i].name+`</option>`)
                    }
                }
            }

            if (response.errors){
                toasterError(response.errors);
            }


        });


    </script>

@endsection
