@extends('admin.layouts.container')
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/toastr.css') }}" />
@endsection
@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row send_notification_form" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($usersNotification ?? ''  && $usersNotification->id)
            @method('PUT')
        @endif
        @csrf
        <div class="form-group col-lg-12">
            <label>{{ meta('send_to', getCurrentLocale()) ?? __('usersNotifications.send_to') }}</label>
            <select name="send_to" class="form-control {{ $errors->has('send_to') ? 'is-invalid' : '' }}">
                <option value="">{{ meta('send_to', getCurrentLocale()) ?? __('usersNotifications.send_to') }}</option>
                <option {{($role == 'all_user') ? 'selected' : ''}} value="all_user">{{ __('usersNotifications.user_name')}}</option>
                <option {{($role == 'all_provider') ? 'selected' : ''}} value="all_provider">{{ __('usersNotifications.provider_name')}}</option>
{{--                <option value="all_users">{{ __('usersNotifications.all_users')}}</option>--}}
            </select>
        </div>
        <div class="form-group col-lg-12 {{(!$role) ? 'd-none' : ''}}  user_container">
            <label>{{ $role == 'all_user' ? __('usersNotifications.user') : __('usersNotifications.provider') }}</label>
            <select name="user_id" class="form-control">
                <option value="{{$role}}">{{ __('usersNotifications.all' ?? '') }}</option>
                @if(count($users))
                    @foreach($users as $user)
                        <option {{($usersNotification->user_id ?? null) == $user->id ? 'selected' : ''}} value="{{$user->id}}">{{$user->name}}</option>
                    @endforeach
                @endif
            </select>
        </div>


        <div class="form-group col-lg-12">
            <label>{{ meta('title', getCurrentLocale()) ?? __('usersNotifications.title') }} </label>
            <input type="text" class="form-control {{ $errors->has('title') ? 'is-invalid' : '' }}" name="title" placeholder="{{ meta('title', getCurrentLocale()) ?? __('usersNotifications.title') }}" value='{{ old("title", $usersNotification->title ?? null) }}'/>
        </div>

        <div class="form-group col-lg-12">
            <label>{{ meta('message', getCurrentLocale()) ?? __('usersNotifications.message') }}</label>
            <textarea name="message" class="form-control editor {{ $errors->has('message') ? 'is-invalid' : '' }}" placeholder="{{ meta('message', getCurrentLocale()) ?? __('usersNotifications.message') }}">{!! old("message", $usersNotification->message ?? null) !!}</textarea>
        </div>

        <div class="text-center mt-5 col-12">
            <button class="butn send_notification_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
{{--        <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>--}}
{{--    <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
{{--        var route_prefix = "{{ url(config('lfm.prefix')) }}";--}}
        {{--var url = "{{url('/')}}/";--}}

        let getUsersRoute = "{{route('usersNotifications.getUsers')}}"

    </script>
{{--    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>--}}
{{--    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>--}}
    <script src="{{ asset('assets/web/js/lib/toastr.min.js') }}"></script>
    <script>
        {{--let getInstructorsRoute = "{{route('usersNotifications.getInstructors')}}";--}}
    </script>

    <script>

        let selectedOption = $('select[name="send_to"] option:selected').val();
        if (selectedOption === '') {
            $('.user_container').addClass('d-none');
            $('.user_container select').val('');
        }

        if (selectedOption === 'all_user' || selectedOption === 'all_provider'){
            $('.user_container').removeClass('d-none');
        }

        $('select[name="send_to"]').change(async function () {
            if ($(this).val() === '') {
                $('.user_container').addClass('d-none');
                $('.user_container select').val('');
            }
            if ($(this).val() === 'all_user' ||$(this).val() === 'all_provider'){
                let data = {role: $(this).val()},
                    url = getUsersRoute,
                    method = 'get';

                const response=await ajax({
                    url,
                    data,
                    dataType: 'json',
                    method
                });

                if (response.errors){
                    toasterError(response.errors);
                }

                $('.user_container').removeClass('d-none');
                let userOptions = $('select[name="user_id"]');

                if (response.role === 'all_user'){
                    userOptions.html(`<option value="all_user">{{__('usersNotifications.all')}}</option>`);
                }
                if (response.role === 'all_provider'){
                    userOptions.html(`<option value="all_provider">{{__('usersNotifications.all')}}</option>`);
                }

                $('.user_container label').html(response.label);

                if (response.users){
                    for (let i = 0; i < response.users.length; i++){
                        userOptions.append(`<option value="`+response.users[i].id+`">`+response.users[i].name+`</option>`)
                    }
                }
            }
        });

        $('.send_notification_button').click(async function (e) {
            e.preventDefault();

            let form = $('.send_notification_form'),
                data = new FormData(form[0]),
                url = form.attr('action'),
                method = form.attr('method');

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.url){
                window.location.href = response.url;
            }

            if (response.errors){
                toasterError(response.errors);
            }


        });


    </script>

@endsection



