<div class="border-item">
    <form class="form-row" method="post" action="{{ $settingsAction }}" enctype="multipart/form-data">
        @if ($settings)
            <input type="hidden" name="update" value="true">
        @endif
        @csrf

        @if (auth()->user()->role == 'super_admin')
            <div class="col-md-12">
                <div class="card mb-5">
                    <div class="card-header">
                        <h4>{{__('settings.disable_dashboard_and_site')}}</h4>
                    </div>
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item">
                            <i class="fas fa-globe"></i> <b>{{meta('website_disable', $lang) ?? 'Website Disabled'}}</b>
                            <label class="switch ">
                                <input {{$settings->website_disable == 1 ? 'checked' : ''}} type="checkbox" class="success" name="website_disable" value="1">
                                <span class="slider"></span>
                            </label>
                        </li>
                        <li class="list-group-item">
                            <i class="fas fa-chart-line"></i> <b> {{ meta('dashboard_disable', $lang) ?? 'Dashboard Disabled' }}</b>
                            <label class="switch ">
                                <input {{$settings->dashboard_disable == 1 ? 'checked' : ''}} type="checkbox" class="success" name="dashboard_disable" value="1">
                                <span class="slider"></span>
                            </label>
                        </li>
                    </ul>
                </div>
            </div>
        @endif

        <div class="form-group col-lg-12">
            <label>{{ __('settings.payment_way') }} </label>
            <div class="row">
                <div class="col-sm">
                    <div class="custom-control custom-checkbox">
                        <input type="checkbox" {{ old('visa_master', $settings->visa_master) == 1 ? 'checked' : ''}} value="1" class="custom-control-input" id="visa_master" name="visa_master">
                        <label class="custom-control-label" for="visa_master">{{__('settings.visa_master')}}</label>
                    </div>
                </div>
                <div class="col-sm">
                    <div class="custom-control custom-checkbox">
                        <input type="checkbox" {{ old('apple_pay', $settings->apple_pay) == 1 ? 'checked' : ''}} value="1" class="custom-control-input" id="apple_pay" name="apple_pay">
                        <label class="custom-control-label" for="apple_pay">{{__('settings.apple_pay')}}</label>
                    </div>
                </div>
                <div class="col-sm">
                    <div class="custom-control custom-checkbox">
                        <input type="checkbox" {{ old('stc_pay', $settings->stc_pay) == 1 ? 'checked' : ''}} value="1" class="custom-control-input" id="stc_pay" name="stc_pay">
                        <label class="custom-control-label" for="stc_pay">{{__('settings.stc_pay')}}</label>
                    </div>
                </div>
                <div class="col-sm">
                    <div class="custom-control custom-checkbox">
                        <input type="checkbox" {{ old('mada', $settings->mada) == 1 ? 'checked' : ''}} value="1" class="custom-control-input" id="mada" name="mada">
                        <label class="custom-control-label" for="mada">{{__('settings.mada')}}</label>
                    </div>
                </div>
            </div>
        </div>

        <div class="form-group col-lg-6">
            <label>{{ meta('website_name', $lang) ?? __('settings.website_name') }}</label>
            <input type="text" class="form-control {{ $errors->has('website_name') ? 'is-invalid' : '' }}" name="website_name" placeholder="{{ meta('website_name', $lang) ?? __('settings.website_name') }}" value='{{ old("website_name", $settings->website_name ?? "") }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('Keywords', $lang) ?? __('settings.keywords') }}</label>
            <input type="text" class="form-control {{ $errors->has('keywords') ? 'is-invalid' : '' }}" name="keywords" placeholder="{{ meta('Keywords', $lang) ?? __('settings.keywords') }}" value='{{ old("keywords", $settings->keywords ?? "") }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('meta_description', $lang) ?? __('settings.meta_description') }}</label>
            <input type="text" class="form-control {{ $errors->has('meta_description') ? 'is-invalid' : '' }}" name="meta_description" placeholder="{{ meta('meta_description', $lang) ?? __('settings.meta_description') }}" value='{{ old("meta_description", $settings->meta_description ?? "") }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('site_email', $lang) ?? __('settings.site_email') }}</label>
            <input type="email" class="form-control {{ $errors->has('site_email') ? 'is-invalid' : '' }}" name="site_email" placeholder="{{ meta('site_email', $lang) ?? __('settings.site_email') }}" value='{{ old("site_email", $settings->site_email ?? "") }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('site_address', $lang) ?? __('settings.site_address') }}</label>
            <input type="text" class="form-control {{ $errors->has('site_address') ? 'is-invalid' : '' }}" name="site_address" placeholder="{{ meta('site_address', $lang) ?? __('settings.site_address') }}" value='{{ old("site_address", $settings->site_address ?? "") }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('site_phone', $lang) ?? __('settings.site_phone') }}</label>
            <input type="tel" class="form-control {{ $errors->has('site_phone') ? 'is-invalid' : '' }}" name="site_phone" placeholder="{{ meta('site_phone', $lang) ?? __('settings.site_phone') }}" value='{{ old("site_phone", $settings->site_phone ?? "") }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('facebook', $lang) ?? __('settings.facebook') }}</label>
            <input type="url" class="form-control {{ $errors->has('facebook') ? 'is-invalid' : '' }}" name="facebook" placeholder="{{ meta('facebook', $lang) ?? __('settings.facebook') }}" value='{{ old("facebook", $settings->facebook ?? "") }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('twitter', $lang) ?? __('settings.twitter') }}</label>
            <input type="url" class="form-control {{ $errors->has('twitter') ? 'is-invalid' : '' }}" name="twitter" placeholder="{{ meta('twitter', $lang) ?? __('settings.twitter') }}" value='{{ old("twitter", $settings->twitter ?? "") }}'/>
        </div>

        <div class="form-group col-lg-6">
            <label>{{ meta('instagram', $lang) ?? __('settings.instagram') }}</label>
            <input type="url" class="form-control {{ $errors->has('instagram') ? 'is-invalid' : '' }}" name="instagram" placeholder="{{ meta('instagram', $lang) ?? __('settings.instagram') }}" value='{{ old("instagram", $settings->instagram ?? "") }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('whatsapp', $lang) ?? __('settings.whatsapp') }}</label>
            <input type="tel" class="form-control {{ $errors->has('whatsapp') ? 'is-invalid' : '' }}" name="whatsapp" placeholder="{{ meta('whatsapp', $lang) ?? __('settings.whatsapp') }}" value='{{ old("whatsapp", $settings->whatsapp ?? "") }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('added_value', $lang) ?? __('settings.added_value') }}</label>
            <input type="number" min="1" class="form-control {{ $errors->has('added_value') ? 'is-invalid' : '' }}" name="added_value" placeholder="{{ meta('added_value', $lang) ?? __('settings.added_value') }}" value='{{ old("added_value", $settings->added_value ?? "") }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('tax_number', $lang) ?? __('settings.tax_number') }}</label>
            <input type="number" min="1" class="form-control {{ $errors->has('tax_number') ? 'is-invalid' : '' }}" name="tax_number" placeholder="{{ meta('tax_number', $lang) ?? __('settings.tax_number') }}" value='{{ old("tax_number", $settings->tax_number ?? "") }}'/>
        </div>
        {{--            <div class="form-group col-lg-6">--}}
        {{--                <label>{{ meta('website_percentage', $lang) ?? __('settings.website_percentage') }}</label>--}}
        {{--                <input type="number" min="1" class="form-control {{ $errors->has('website_percentage') ? 'is-invalid' : '' }}" name="website_percentage" placeholder="{{ meta('website_percentage', $lang) ?? __('settings.website_percentage') }}" value='{{ old("website_percentage", $settings->website_percentage ?? "") }}'/>--}}
        {{--            </div>--}}

        <div class="form-group col-lg-6">
            <label>{{ meta('mail_driver', $lang) ?? __('settings.mail_driver') }}</label>
            <input type="text" readonly class="form-control bg-white {{ $errors->has('mail_driver') ? 'is-invalid' : '' }}" name="mail_driver" placeholder="{{ meta('mail_driver', $lang) ?? __('settings.mail_driver') }}" value='{{ old("mail_driver", $settings->mail_driver ?? "") }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('mail_host', $lang) ?? __('settings.mail_host') }}</label>
            <input type="text" readonly class="form-control bg-white {{ $errors->has('mail_host') ? 'is-invalid' : '' }}" name="mail_host" placeholder="{{ meta('mail_host', $lang) ?? __('settings.mail_host') }}" value='{{ old("mail_host", $settings->mail_host ?? "") }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('mail_port', $lang) ?? __('settings.mail_port') }}</label>
            <input type="number" readonly class="form-control bg-white {{ $errors->has('mail_port') ? 'is-invalid' : '' }}" name="mail_port" placeholder="{{ meta('mail_port', $lang) ?? __('settings.mail_port') }}" value='{{ old("mail_port", $settings->mail_port ?? "") }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('mail_username', $lang) ?? __('settings.mail_username') }}</label>
            <input type="text" readonly class="form-control bg-white {{ $errors->has('mail_username') ? 'is-invalid' : '' }}" name="mail_username" placeholder="{{ meta('mail_username', $lang) ?? __('settings.mail_username') }}" value='{{ old("mail_username", $settings->mail_username ?? "") }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('mail_password', $lang) ?? __('settings.mail_password') }}</label>
            <input type="password" readonly class="form-control bg-white {{ $errors->has('mail_password') ? 'is-invalid' : '' }}" name="mail_password" placeholder="{{ meta('mail_password', $lang) ?? __('settings.mail_password') }}" value='{{ old("mail_password", $settings->mail_password ?? "") }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('mail_encryption', $lang) ?? __('settings.mail_encryption') }}</label>
            <input type="text" readonly class="form-control bg-white {{ $errors->has('mail_encryption') ? 'is-invalid' : '' }}" name="mail_encryption" placeholder="{{ meta('mail_encryption', $lang) ?? __('settings.mail_encryption') }}" value='{{ old("mail_encryption", $settings->mail_encryption ?? "") }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('mail_from_address', $lang) ?? __('settings.mail_from_address') }}</label>
            <input type="text" class="form-control {{ $errors->has('mail_from_address') ? 'is-invalid' : '' }}" name="mail_from_address" placeholder="{{ meta('mail_from_address', $lang) ?? __('settings.mail_from_address') }}" value='{{ old("mail_from_address", $settings->mail_from_address ?? "") }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('mail_from_name', $lang) ?? __('settings.mail_from_name') }}</label>
            <input type="text" class="form-control {{ $errors->has('mail_from_name') ? 'is-invalid' : '' }}" name="mail_from_name" placeholder="{{ meta('mail_from_name', $lang) ?? __('settings.mail_from_name') }}" value='{{ old("mail_from_name", $settings->mail_from_name ?? "") }}'/>
        </div>

        {{--Start image container--}}
        <div class="form-group col-lg-12">
            <label>{{ meta('website_logo', $lang) ?? __('settings.website_logo') }} </label>
            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="website_logo" value="{{old("website_logo", $settings->website_logo ?? "")}}"/>

            <div class="photos main_photo {{ old('website_logo', $settings->website_logo ?? '') ? ' wow fadeInUp' : 'hide' }}">
                <div class="col-lg-4">
                    <div class="items">
                        <div class="img">
                            <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                <img src="{{asset(old('website_logo', $settings->website_logo ?? ''))}} "  id="image_holder" class="image_holder"/>
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_button {{ old('website_logo', $settings->website_logo ?? '') ? 'hide' : '' }} ">
                <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> {{__('dashboard.choose')}}
                </a>
            </span>
        </div>
        {{--End image container--}}

        {{--Start image container--}}
        {{--        <div class="form-group col-lg-12">--}}
        {{--            <label>{{ meta('contact_us_image', $lang) ?? __('settings.contact_us_image') }} </label>--}}
        {{--            <input id="contact_us_image_thumbnail" class="contact_us_image_thumbnail" type="hidden" name="contact_us_image" value="{{old("contact_us_image", $settings->contact_us_image ?? "")}}"/>--}}

        {{--            <div class="photos contact_us_main_photo {{ old('contact_us_image', $settings->contact_us_image ?? '') ? ' wow fadeInUp' : 'hide' }}">--}}
        {{--                <div class="col-lg-4">--}}
        {{--                    <div class="items">--}}
        {{--                        <div class="img">--}}
        {{--                            <a href="#" id="lfm" data-input=".contact_us_image_thumbnail" data-preview=".contact_us_image_holder" class="lfm" data-hide=".contact_us_pick_button">--}}
        {{--                                <img src="{{asset(old('contact_us_image', $settings->contact_us_image ?? ''))}} "  id="contact_us_image_holder" class="contact_us_image_holder"/>--}}
        {{--                            </a>--}}
        {{--                        </div>--}}
        {{--                        <a href="#" class="showHide resetImage close" data-empty=".contact_us_image_thumbnail" data-hide=".contact_us_main_photo" data-show=".contact_us_pick_button"><i class="fas fa-times"></i></a>--}}
        {{--                    </div>--}}
        {{--                </div>--}}
        {{--            </div>--}}

        {{--            <div class="clearfix"></div>--}}
        {{--            <span class="input-group-btn contact_us_pick_button {{ old('contact_us_image', $settings->contact_us_image ?? '') ? 'hide' : '' }} ">--}}
        {{--            <a id="lfm" data-input=".contact_us_image_thumbnail" data-preview=".contact_us_image_holder" data-show=".contact_us_main_photo" data-hide=".contact_us_pick_button" class="lfm btn btn-primary text-light">--}}
        {{--                <i class="fas fa-camera-retro"></i> Choose--}}
        {{--            </a>--}}
        {{--        </span>--}}
        {{--        </div>--}}
        {{--End image container--}}

        <div class="text-center mt-5 col-12">
            <button class="butn"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>
