@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($service ?? ''  && $service->id)
            @method('PUT')
        @endif
        @csrf

        <div class="form-group col-lg-6">
            <label>{{ meta('service_type', $local) ?? __('services.service_type') }} </label>
            <select name="service_type" class="form-control">
                {{--                    <option value="">{{ meta('service_type', $local) ?? __('services.service_type') }}</option>--}}
                <option {{($service->service_type ?? null) == 'person_count' ? 'selected' : ''}} value="person_count">{{__('services.person_count')}}</option>
                <option {{($service->service_type ?? null) == 'days_count' ? 'selected' : ''}} value="days_count">{{__('services.days_count')}}</option>
            </select>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('price', $local) ?? __('services.price') }} </label>
            <input type="number" min="1" class="form-control {{ $errors->has('price') ? 'is-invalid' : '' }}" name="price" placeholder="{{ meta('price', $local) ?? __('services.price') }}" value='{{ old("price", $service->price ?? "") }}'/>
        </div>

        @foreach(languages() as $language)
        <div class="form-group col-lg-12">
            <label>{{ meta('name', $language->local) ?? __('services.name') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('name_'.$language->local) ? 'is-invalid' : '' }}" name="name_{{ $language->local }}" placeholder="{{ meta('name', $language->local) ?? __('services.name') }}" value='{{ old("name_{$language->local}", $service[$language->local]->name ?? "") }}'/>
        </div>
        <div class="form-group col-lg-12">
            <label>{{ meta('description', $language->local) ?? __('services.description') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <textarea name="description_{{ $language->local }}" class="form-control my-editor {{ $errors->has('description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('description', $language->local) ?? __('services.description') }}">{!! old("description_{$language->local}", $service[$language->local]->description ?? "") !!}</textarea>
        </div>

        @endforeach

        {{--Start image container--}}
        <div class="form-group col-lg-12">
            <label>{{ meta('image', getCurrentLocale()) ?? __('services.image') }} </label>
            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $service->image ?? "")}}"/>

            <div class="photos main_photo {{ old('image', $service->image ?? '') ? ' wow fadeInUp' : 'hide' }}">
                <div class="col-lg-4">
                    <div class="items">
                        <div class="img">
                            <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                <img src="{{asset(old('image', $service->image ?? ''))}} "  id="image_holder" class="image_holder"/>
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_button {{ old('image', $service->image ?? '') ? 'hide' : '' }} ">
                <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> Choose
                </a>
            </span>
        </div>
        {{--End image container--}}

        <div class="text-center mt-5 col-12">
            <button class="butn"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
        <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
{{--    <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        var route_prefix = "{{ url(config('lfm.prefix')) }}";
        var url = "{{url('/')}}/",
            currentLanguage = "{{getCurrentLocale()}}",
            inputName = '';
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>

@endsection



