@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>
<div class="border-item">
    <form class="form-row" method="post" action="{{ $action }}">
        @if($sector ?? ''  && $sector->id)
            @method('PUT')
        @endif
        @csrf

        <div class="form-group col-lg-4">
            <label>{{ meta('city_id', getCurrentLocale()) ?? __('sectors.city_id') }} </label>
            <select name="city_id" class="form-control {{ $errors->has('city_id') ? 'is-invalid' : '' }}">
                <option value="">{{ meta('city_id', getCurrentLocale()) ?? __('sectors.city_id') }}</option>
                @if(count($cities))
                    @foreach($cities as $city)
                        <option {{old('city_id', $sector->city_id ?? null) == $city->id ? 'selected' : ''}} value="{{$city->id}}">{{$city->name}}</option>
                    @endforeach
                @endif
            </select>
        </div>

        @foreach($languages as $language)
        <div class="form-group col-lg-4">
            <label>{{ meta('name', $language->local) ?? __('sectors.name') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('name_'.$language->local) ? 'is-invalid' : '' }}" name="name_{{ $language->local }}" placeholder="{{ meta('name', $language->local) ?? __('sectors.name') }}" value='{{ old("name_{$language->local}", $sector[$language->local]->name ?? "") }}'/>
        </div>
        @endforeach

        <div class="text-center mt-5 col-12">
            <button class="butn"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection
