@extends('admin.layouts.container')
{{--@section('css')--}}
{{--    <link rel="stylesheet" href="{{asset('assets/admin/css/lib/toastr.css')}}">--}}
{{--@endsection--}}
@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row add_service_form" method="post" action="" enctype="multipart/form-data">
{{--        @if($reservation ?? ''  && $reservation->id)--}}
{{--            @method('PUT')--}}
{{--        @endif--}}
{{--        @csrf--}}

            <div class="form-group col-lg-4">
                <label>{{ meta('re_status', $local) ?? __('reservations.re_status') }} </label>
                <input  readonly class="form-control bg-white"  value='{{ __('reservations.'.$reservation->re_status) }}'/>
            </div>
            <div class="form-group col-lg-4">
                <label>{{ meta('re_way', $local) ?? __('reservations.re_way') }} </label>
                <input  readonly class="form-control bg-white"  value='{{ __('reservations.'.$reservation->re_way) }}'/>
            </div>
            <div class="form-group col-lg-4">
                <label>{{ meta('re_no', $local) ?? __('reservations.re_no') }} </label>
                <input  readonly class="form-control bg-white"  value='{{ $reservation->re_no }}'/>
            </div>
            <div class="form-group col-lg-4">
                <label>{{ meta('re_date_from', $local) ?? __('reservations.re_date_from') }} </label>
                <input  readonly class="form-control bg-white"  value='{{ $reservation->re_date_from }}'/>
            </div>
            <div class="form-group col-lg-4">
                <label>{{ meta('re_date_to', $local) ?? __('reservations.re_date_to') }} </label>
                <input  readonly class="form-control bg-white"  value='{{ $reservation->re_date_to }}'/>
            </div>
            <div class="form-group col-lg-4">
                <label>{{ meta('user_name', $local) ?? __('reservations.user_name') }} </label>
                <input  readonly class="form-control bg-white"  value='{{ $reservation->user_name }}'/>
            </div>
            <div class="form-group col-lg-4">
                <label>{{ meta('user_phone', $local) ?? __('reservations.user_phone') }} </label>
                <input  readonly class="form-control bg-white"  value='{{ $reservation->user_phone}}'/>
            </div>
            <div class="form-group col-lg-4">
                <label>{{ meta('hall_name', $local) ?? __('reservations.hall_name') }} </label>
                <input  readonly class="form-control bg-white"  value='{{ $reservation->hall_name}}'/>
            </div>
            <div class="form-group col-lg-4">
                <label>{{ meta('provider_name', $local) ?? __('reservations.provider_name') }} </label>
                <input  readonly class="form-control bg-white"  value='{{ $reservation->provider_name}}'/>
            </div>
        @if($reservation->other_details)
        <div class="form-group col-lg-12">
            <label>{{ __('reservations.other_details') }} </label>
            <textarea readonly class="form-control bg-white" cols="30" rows="10">{{$reservation->other_details}}</textarea>
        </div>
        @endif

        <section class="reservation_det bill-pg col-md-12">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 m-auto">
                        <div class="reservation_item">
                            <h3 class="bill_title">{{__('reservations.bill_summary')}}</h3>
                            <div class="table-responsive">
                                <table class="table bill_table">
                                    <thead>
                                    <tr>
                                        <th scope="col" class="day_back_dark">{!! __('reservations.bill_description') !!}</th>
                                        <th scope="col" class="day_back_dark">{!! __('reservations.bill_quantity') !!}</th>
                                        <th scope="col" class="day_back_dark">{!! __('reservations.bill_unit_price') !!}</th>
                                        <th scope="col" class="day_back_dark"> {!! __('reservations.bill_total') !!} </th>
                                        <th scope="col" class="day_back_dark"> {!! __('reservations.bill_discount') !!} </th>
                                        <th scope="col" class="day_back_dark"> {!! __('reservations.bill_net_amount') !!} </th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <!-- -------- day 1 -------- -->
                                    @if(count($servicesAndAddedServices))
                                        @foreach($servicesAndAddedServices as $day => $servicesAndAddedService)
                                            <?php
                                            /** @var TYPE_NAME $reservation */
                                            /** @var TYPE_NAME $servicesAndAddedService */
                                            /** @var TYPE_NAME $day */

                                            $reservationPrice = $reservation->booking_amount_per_day ?? $reservation->booking_amount_per_person;
                                            $discountPercentage = ($servicesAndAddedService['services'][0] ?? $servicesAndAddedService['added_services'][0])['discount_percentage'];
                                            $count = $reservation->re_way == 'person_count' ? $reservation->person_count : 1;
                                            $total = $reservationPrice*$count;
                                            $discount = ($total*$discountPercentage)/100;
                                            $remaining = $total-$discount;
                                            $sar = __('reservations.sar');
                                            ?>
                                            <tr class="day_back">
                                                <th scope="row" class="day_back">
                                                    <span class=""> {{__('reservations.day')}} {{dateInfo($day, ['day_name' => true])}} {{__('reservations.corresponding_to')}} ({{dateInfo($day, ['format' => 'Y / m / d'])}}) </span>
                                                </th>
                                                <td>
                                                    {{$count}}
                                                </td>
                                                <td>{{$reservationPrice . ' ' . $sar}} </td>
                                                <td>{{$total . ' ' . $sar}} </td>
                                                <td>{{$discount . ' ' . $sar}} </td>
                                                <td>{{$remaining . ' ' . $sar}} </td>

                                            </tr>
                                            @if(($servicesAndAddedService['services'] ?? null))
                                                <tr class="day_color1">
                                                    <th scope="row">
                                                        <span class=""> {!! __('reservations.bill_approved_services') !!} </span>
                                                    </th>
                                                    <td></td><td></td><td></td><td></td><td></td>
                                                </tr>
                                                @foreach($servicesAndAddedService['services'] as $oneSer)
                                                    <?php
                                                    /** @var TYPE_NAME $oneSer */
                                                    $servicePrice = $oneSer['price']*$oneSer['quantity'];
                                                    $serviceDiscount = ($servicePrice*$oneSer['discount_percentage'])/100;
                                                    $serviceRemaining = $servicePrice-$serviceDiscount;

                                                    ?>
                                                    <tr class="day_color1">
                                                        <th scope="row">
                                                            <span> {{$oneSer['name']}} </span>
                                                        </th>
                                                        <td>{{$oneSer['quantity']}}</td>
                                                        <td>{{$oneSer['price'] . ' ' . $sar}} </td>
                                                        <td>{{$servicePrice . ' ' . $sar}}</td>
                                                        <td>{{$serviceDiscount . ' ' . $sar}}</td>
                                                        <td>{{$serviceRemaining . ' ' . $sar}} </td>
                                                    </tr>
                                                @endforeach

                                            @endif
                                            @if(($servicesAndAddedService['added_services'] ?? null))
                                                <tr class="day_color1">
                                                    <th scope="row">
                                                        <span class=""> {!! __('reservations.bill_added_services') !!} </span>
                                                    </th>
                                                    <td></td><td></td><td></td><td></td><td></td>
                                                </tr>
                                                @foreach($servicesAndAddedService['added_services'] as $oneAddedSer)
                                                    <?php
                                                    /** @var TYPE_NAME $oneAddedSer */
                                                    $addedServicePrice = $oneAddedSer['price']*$oneAddedSer['quantity'];
                                                    $addedServiceDiscount = ($addedServicePrice*$oneAddedSer['discount_percentage'])/100;
                                                    $addedServiceRemaining = $addedServicePrice-$addedServiceDiscount;

                                                    ?>
                                                    <tr class="day_color1">
                                                        <th scope="row">
                                                            <span> {{$oneAddedSer['name']}} </span>
                                                        </th>
                                                        <td>{{$oneAddedSer['quantity']}}</td>
                                                        <td>{{$oneAddedSer['price'] . ' ' . $sar}} </td>
                                                        <td>{{$addedServicePrice . ' ' . $sar}}</td>
                                                        <td>{{$addedServiceDiscount . ' ' . $sar}}</td>
                                                        <td>{{$addedServiceRemaining . ' ' . $sar}} </td>
                                                    </tr>
                                                @endforeach
                                            @endif
                                        @endforeach

                                    @else
                                        @foreach($reservationDays['days'] as $key => $reservationDay)
                                            <?php
                                            /** @var TYPE_NAME $reservation */
                                            /** @var TYPE_NAME $reservationDays */
                                            /** @var TYPE_NAME $day */
                                            /** @var TYPE_NAME $key */
                                            /** @var TYPE_NAME $reservationDay */

                                            $reservationPrice = ($reservation->booking_amount_per_day ?? $reservation->booking_amount_per_person);
                                            $discountPercentage = $reservationDays['percentage'][$key];
                                            $count = $reservation->re_way == 'person_count' ? $reservation->person_count : 1;
                                            $total = ($reservationPrice*$count);
                                            $discount = ($total*$discountPercentage)/100;
                                            $remaining = $total-$discount;
                                            $sar = __('reservations.sar');
                                            ?>
                                            <tr class="day_back">
                                                <th scope="row" class="day_back">
                                                    <span class=""> {{__('reservations.day')}} {{dateInfo($reservationDay, ['day_name' => true])}} {{__('reservations.corresponding_to')}} ({{dateInfo($reservationDay, ['format' => 'Y / m / d'])}}) </span>
                                                </th>
                                                <td>
                                                    {{$count}}
                                                </td>
                                                <td>{{$reservationPrice . ' ' . $sar}} </td>
                                                <td>{{$total . ' ' . $sar}} </td>
                                                <td>{{$discount . ' ' . $sar}} </td>
                                                <td>{{$remaining . ' ' . $sar}} </td>

                                            </tr>
                                        @endforeach
                                    @endif


                                    {{-- Start Bill footer--}}
                                    <tr>
                                        <th scope="row" class="day_back_dark">
                                            <span>{!! __('reservations.bill_total_before_tax') !!}</span>
                                        </th>
                                        <td colspan="5" class="text-center">
                                            {{$totalBeforeAddedValue . ' ' . __('reservations.sar')}}
                                        </td>
                                    </tr>
                                    <tr>
                                        <th scope="row" class="day_back_dark">
                                            <span>{!! __('reservations.bill_added_value') !!}</span>
                                        </th>
                                        <td colspan="5" class="text-center">
                                            {{($settings['added_value'] ?? 0)}}%
                                        </td>
                                    </tr>
                                    <tr>
                                        <th scope="row" class="day_back_dark">
                                            <span>{!! __('reservations.bill_total_after_tax') !!}</span>
                                        </th>
                                        <td colspan="5" class="text-center">
                                            {{$totalAfterAddedValue . ' ' . __('reservations.sar')}}
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="qr_card text-center">
                                <img src="{{$qrCode['qr_code']}}" alt="" height="125px" width="125px" class="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <div class="text-center mt-5 col-12">
            <a href="{{route('reservations.index')}}" class="butn"><span>{{ __('reservations.back_to_reservation') }}</span></a>
        </div>
    </form>
</div>

@endsection

@section('inner_js')

{{--    <script src="{{ asset('assets/admin/js/lib/toastr.min.js') }}"></script>--}}

{{--    <script>--}}
{{--        $('.add_service_button').click(async function (e) {--}}
{{--            e.preventDefault();--}}

{{--            let form = $('.add_service_form'),--}}
{{--                data = new FormData(form[0]),--}}
{{--                url = form.attr('action'),--}}
{{--                method = form.attr('method');--}}

{{--            $('.discount_dates_input').each(function () {--}}
{{--                if ($(this).prop('checked') === false){--}}
{{--                    data.append('discount_dates[]', 0);--}}
{{--                    data.append('discount_percentage[]', 'empty');--}}
{{--                } else {--}}
{{--                    data.append('discount_dates[]', 1);--}}
{{--                    let inputSibling = $(this).siblings('.discount_percentage');--}}
{{--                    data.append('discount_percentage[]', inputSibling.val());--}}

{{--                }});--}}


{{--            const response=await ajax({--}}
{{--                url,--}}
{{--                data,--}}
{{--                dataType: 'json',--}}
{{--                method--}}
{{--            });--}}

{{--            if (response.url){--}}
{{--                window.location.href = response.url;--}}
{{--            }--}}

{{--            if (response.errors){--}}
{{--                toasterError(response.errors);--}}
{{--            }--}}


{{--        });--}}
{{--    </script>--}}

@endsection



