@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>
<div class="border-item">
    <form class="form-row" method="post" action="{{ $action }}">
        @if($region ?? ''  && $region->id)
            @method('PUT')
        @endif
        @csrf

        <div class="form-group col-lg-4">
            <label>{{ meta('country_id', getCurrentLocale()) ?? __('states.country_id') }} </label>
            <select name="country_id" class="form-control {{ $errors->has('country_id') ? 'is-invalid' : '' }}">
                <option value="">{{ meta('country_id', getCurrentLocale()) ?? __('products.country_id') }}</option>
                @if(count($countries))
                    @foreach($countries as $country)
                        <option {{old('country_id', $region->country_id ?? null) == $country->id ? 'selected' : ''}} value="{{$country->id}}">{{$country->name}}</option>
                    @endforeach
                @endif
            </select>
        </div>

        @foreach($languages as $language)
        <div class="form-group col-lg-4">
            <label>{{ meta('name', $language->local) ?? __('states.name') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('name_'.$language->local) ? 'is-invalid' : '' }}" name="name_{{ $language->local }}" placeholder="{{ meta('name', $language->local) ?? __('states.name') }}" value='{{ old("name_{$language->local}", $region[$language->local]->name ?? "") }}'/>
        </div>
        @endforeach

        <div class="text-center mt-5 col-12">
            <button class="butn"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection
