@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($policy ?? ''  && $policy->id)
            @method('PUT')
        @endif
        @csrf

        @foreach($languages as $language)
        <div class="form-group col-lg-12">
            <label>{{ meta('privacy_policy_description', $language->local) ?? __('abouts.privacy_policy_description') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <textarea name="privacy_policy_description_{{ $language->local }}" class="form-control my-editor {{ $errors->has('privacy_policy_description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('privacy_policy_description', $language->local) ?? __('abouts.privacy_policy_description') }}">{{ old("privacy_policy_description_{$language->local}", $policy[$language->local]->privacy_policy_description ?? "") }}</textarea>
        </div>
        <div class="form-group col-lg-12">
            <label>{{ meta('privacy_policy_description_list', $language->local) ?? __('abouts.privacy_policy_description_list') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <textarea rows="10" name="privacy_policy_description_list_{{ $language->local }}" class="form-control {{ $errors->has('privacy_policy_description_list_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('privacy_policy_description_list', $language->local) ?? __('abouts.privacy_policy_description_list') }}">{{ old("privacy_policy_description_list_{$language->local}", $policy[$language->local]->privacy_policy_description_list ?? "") }}</textarea>
        </div>
        <div class="form-group col-lg-12">
            <label>{{ meta('terms_conditions_description', $language->local) ?? __('abouts.terms_conditions_description') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <textarea name="terms_conditions_description_{{ $language->local }}" class="form-control my-editor {{ $errors->has('terms_conditions_description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('terms_conditions_description', $language->local) ?? __('abouts.terms_conditions_description') }}">{{ old("terms_conditions_description_{$language->local}", $policy[$language->local]->terms_conditions_description ?? "") }}</textarea>
        </div>
        @endforeach

        <div class="text-center mt-5 col-12">
            <button class="butn"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{--        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{getCurrentLocale()}}",
            imagePath = "{{asset('')}}",
            inputName = "";
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>
@endsection


