@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>
<div class="border-item">
    <form class="form-row" method="post" action="{{ $action }}">
        @if($occasion ?? ''  && $occasion->id)
            @method('PUT')
        @endif
        @csrf

{{--        <div class="form-group col-lg-4">--}}
{{--            <label>{{ meta('category_id', $local) ?? __('occasions.category_id') }} </label>--}}
{{--            <select name="category_id" class="form-control {{ $errors->has('category_id_'.$local) ? 'is-invalid' : '' }}">--}}
{{--                <option value="">{{__('occasions.category_id')}}</option>--}}
{{--                @if(count($categories))--}}
{{--                    @foreach($categories as $category)--}}
{{--                        <option {{(old('category_id', $occasion->category_id ?? null)) == $category->id ? 'selected' : ''}} value="{{$category->id}}">{{$category->name}}</option>--}}
{{--                    @endforeach--}}
{{--                @endif--}}
{{--            </select>--}}
{{--        </div>--}}
        @foreach($languages as $language)
        <div class="form-group col-lg-6">
            <label>{{ meta('name', $language->local) ?? __('occasions.name') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('name_'.$language->local) ? 'is-invalid' : '' }}" name="name_{{ $language->local }}" placeholder="{{ meta('name', $language->local) ?? __('occasions.name') }}" value='{{ old("name_{$language->local}", $occasion[$language->local]->name ?? "") }}'/>
        </div>
        @endforeach

            {{--Start image container--}}
            <div class="form-group col-lg-12">
                <label>{{ meta('image', getCurrentLocale()) ?? __('occasions.image') }} </label>
                <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $occasion->image ?? "")}}"/>

                <div class="photos main_photo {{ old('image', $occasion->image ?? '') ? ' wow fadeInUp' : 'hide' }}">
                    <div class="col-lg-4">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="{{asset(old('image', $occasion->image ?? ''))}} "  id="image_holder" class="image_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn pick_button {{ old('image', $occasion->image ?? '') ? 'hide' : '' }} ">
                <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> Choose
                </a>
            </span>
            </div>
            {{--End image container--}}

        <div class="text-center mt-5 col-12">
            <button class="butn"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{--    <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        var route_prefix = "{{ url(config('lfm.prefix')) }}";
        var url = "{{url('/')}}/",
            currentLanguage = "{{getCurrentLocale()}}",
            inputName = '';
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>

@endsection

