@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($number ?? ''  && $number->id)
            @method('PUT')
        @endif
        @csrf

        <div class="form-group col-lg-12">
            <label>{{ meta('number', $local) ?? __('numbers.number') }} </label>
            <input type="number" min="1" class="form-control {{ $errors->has('number') ? 'is-invalid' : '' }}" name="number" placeholder="{{ meta('number', $local) ?? __('numbers.number') }}" value='{{ old("number", $number->number ?? "") }}'/>
        </div>
        @foreach($languages as $language)
        <div class="form-group col-lg-6">
            <label>{{ meta('title', $language->local) ?? __('numbers.title') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('title_'.$language->local) ? 'is-invalid' : '' }}" name="title_{{ $language->local }}" placeholder="{{ meta('title', $language->local) ?? __('numbers.title') }}" value='{{ old("title_{$language->local}", $number[$language->local]->title ?? "") }}'/>
        </div>
        @endforeach

        {{--Start image container--}}
{{--        <div class="form-group col-lg-6">--}}
{{--            <label>{{ meta('image', getCurrentLocale()) ?? __('numbers.image') }} </label>--}}
{{--            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $number->image ?? null)}}"/>--}}

{{--            <div class="photos main_photo {{ old('image', $number->image ?? null) ? ' wow fadeInUp' : 'hide' }}">--}}
{{--                <div class="col-lg-4">--}}
{{--                    <div class="items">--}}
{{--                        <div class="img">--}}
{{--                            <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">--}}
{{--                                <img src="{{($number->image ?? null) ? asset(old('image', $number->image ?? null)) : ''}} "  id="image_holder" class="image_holder"/>--}}
{{--                            </a>--}}
{{--                        </div>--}}
{{--                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--            </div>--}}

{{--            <div class="clearfix"></div>--}}
{{--            <span class="input-group-btn pick_button {{ old('image', $number->image ?? null) ? 'hide' : '' }} ">--}}
{{--                <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">--}}
{{--                    <i class="fas fa-camera-retro"></i> Choose--}}
{{--                </a>--}}
{{--            </span>--}}
{{--        </div>--}}
        {{--End image container--}}

        <div class="text-center mt-5 col-12">
            <button class="butn"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
{{--    <!-- Editor JS files -->--}}
{{--        <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>--}}
{{--    <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
{{--    <script>--}}
{{--        var route_prefix = "{{ url(config('lfm.prefix')) }}";--}}
{{--        var url = "{{url('/')}}/",--}}
{{--        currentLanguage = "{{getCurrentLocale()}}",--}}
{{--        inputName = null;--}}
{{--    </script>--}}
{{--    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>--}}
{{--    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>--}}

@endsection



