@extends('admin.layouts.container')

@section('content')
    <form>
        <div class="side-title">
            <div class="row">
                <div class="col-lg-6">
                    <h3>{{ $title }}</h3>
                </div>
                <div class="col-lg-6 valign">
                    <div class="edit-buttons text-right w-100">
                        <a href="{{ route ('members.destroyAll') }}" data-method="delete" class="butn statusButns status_1 tableAction btn disabled bg-warning"> <span>{{ __('dashboard.sendToTrash') }}</span></a>
                        <a href="#" class="butn statusButns status_1 showArchive bg-primary"> <span> {{ __('dashboard.displayTrash') }} </span></a>

{{--                        <a href="{{ route ('members.destroyAll') }}" data-method="delete" class="butn statusButns status_0 tableAction btn disabled bg-danger force"> <span> {{ __('dashboard.delete') }} </span></a>--}}
{{--                        <a href="{{ route ('members.restoreAll') }}" data-method="put" class="butn statusButns status_0 tableAction btn disabled bg-info"> <span> {{ __('dashboard.restore') }} </span></a>--}}
                        <a href="#" class="butn statusButns status_0 showActive bg-primary"> <span> {{ __('dashboard.displayActive') }} </span></a>
                    </div>
                </div>
{{--                <div class="col-lg-12 valign">--}}
{{--                    <div class="edit-buttons text-right w-100 d-flex justify-content-start">--}}
{{--                        <a href="{{ route ('membersReport') }}"  class="butn btn bg-secondary"><span><i class="fa fa-file-excel"></i> {{ __('members.export_excel') }}</span></a>--}}
{{--                    </div>--}}
{{--                </div>--}}
            </div>
        </div>

        <!-- ------------ data table ------------- -->
        <div class="overflow_x">
            <table class="table table-hover table-bordered">
                <thead>
                <tr>
                    <th scope="col">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" id="selectall" name="example1">
                            <label class="custom-control-label" for="selectall"> </label>
                        </div>
                    </th>
                    <th scope="col">#</th>
                    <th scope="col">{{ __('members.name') }}</th>
                    <th scope="col">{{ __('members.phone') }}</th>
                    <th scope="col">{{ __('members.email') }}</th>
                    <th scope="col">{{ __('members.status') }}</th>
                    <th scope="col">{{ __('members.member_type') }}</th>
                    <th scope="col" colspan="2">{{ __('dashboard.created_at') }}</th>
                    <th scope="col">{{ __('dashboard.processes') }}</th>
                </tr>
                </thead>

                <tbody class="response">
                <tr class="search_filter_form">
                    <th scope="row"></th>
                    <th scope="row"></th>
                    <th scope="row">
                        <input type="text" name="name" value="{{ $request->name ?? '' }}" class="form-control" placeholder="">
                    </th>
                    <th scope="row">
                        <input type="text" name="phone" value="{{ $request->phone ?? '' }}" class="form-control" placeholder="">
                    </th>
                    <th scope="row">
                        <input type="text" name="email" value="{{ $request->email ?? '' }}" class="form-control" placeholder="">
                    </th>
                    <th scope="row">
                        <select name="user_status" class="form-control">
                            <option value="">{{__('members.status')}}</option>
                            <option value="active">{{__('members.active')}}</option>
                            <option value="non_active">{{__('members.non_active')}}</option>
                        </select>
                    </th>
                    <th scope="row">
                        <select name="role" class="form-control">
                            <option value="">{{__('members.member_type')}}</option>
                            <option value="user">{{__('members.user')}}</option>
                            <option value="provider">{{__('members.provider')}}</option>
                        </select>
                    </th>
                    <td>
                        <input type="text" placeholder="{{ __('dashboard.date_from') }}" name="date_from" value="{{ $request->date_from ?? '' }}" class="date_from form-control">
                    </td>
                    <td>
                        <input type="text" placeholder="{{ __('dashboard.date_to') }}" name="date_to" value="{{ $request->date_to ?? '' }}" class="date_to form-control">
                    </td>
                    <th scope="col"><button type="button" class="butn color small search"><span><i class="fas fa-search"></i></span></button></th>
                </tr>
                </tbody>


            </table>
        </div>

        <!-- ------------ sidemenu links ------------- -->
    </form>
@endsection



<script>
    /**
     * Importat to handle ajax requests for filters, deletes, trash and any proccess done on the table's data
     */
    var dataTable={
        route: '{{ route("members.grid") }}'
    }
</script>
@section('inner_js')
    <script>
        $(document).ready(function () {
            $(document).on('click', '.active_member' , async function (e) {
                e.preventDefault();
                let url = $(this).data('href'),
                    method = 'get';

                const response=await ajax({
                    url,
                    dataType: 'json',
                    method,
                });
                if (response.message) {
                    $(this).children('i').toggleClass('fa-check text-success fa-times text-danger')

                }
            });
        });
    </script>
@endsection
