@foreach($members as $key=> $row)
    <tr>
        <th scope="row">
            <div class="custom-control custom-checkbox">
                <input type="checkbox" class="custom-control-input selectOne deleteCheck" id="customCheck{{$row->id}}" value="{{$row->id}}" name="id[]">
                <label class="custom-control-label" for="customCheck{{$row->id}}"></label>
            </div>
        </th>
        <td>{{ $loop->iteration }}</td>
        <td>{{ $row->name }}</td>
        <td>{{ $row->phone }}</td>
        <td>{{ $row->email }}</td>
        <td>{{ $row->status ? __('members.active') : __('members.non_active') }}</td>
        <td>{{ __('members.'.$row->role) }}</td>
        <td colspan="2">{{ \Carbon\Carbon::parse($row->created_at)->format('Y/m/d') }}</td>
        <td>
            @if($row->deleted_at)
                <a href="{{ route ('members.restore', $row->id) }}" data-method="put" class="icon rowAction" title="{{ __('dashboard.restore') }}"><img src="{{ asset('assets/admin/images/icons/restore.svg') }}" alt="{{ __('dashboard.restore') }}"></a>
{{--                <a href="{{ route ('members.destroy', $row->id) }}" data-method="delete" class="icon rowAction" title="{{ __('dashboard.delete') }}"><img src="{{ asset('assets/admin/images/icons/close.svg') }}" alt="{{ __('dashboard.delete') }}"></a>--}}
            @else
                <a style="cursor: pointer" class="active_member icon" data-href="{{route('members.activeMember', $row->id)}}"><i class="fa fa-2x {{$row->status ? 'fa-check text-success' : 'fa-times text-danger'}}"></i></a>
                <a href="{{ route ('members.edit', $row->id) }}" class="icon" title="{{ __('dashboard.edit') }}"><img src="{{ asset('assets/admin/images/icons/draw.svg') }}" alt="{{ __('dashboard.edit') }}"></a>
                <a href="{{ route ('members.destroy', $row->id) }}" data-method="delete" class="icon rowAction" title="{{ __('dashboard.trash') }}"><img src="{{ asset('assets/admin/images/icons/del.svg') }}" alt="{{ __('dashboard.trash') }}"></a>
            @endif
        </td>
    </tr>
@endforeach

@if( count( $members ) && $members->hasPages() )
    <tr> <td></td><td> {{ $members->links() }} </td> </tr>
@endif
