@extends('admin.layouts.container')
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/toastr.css') }}" />
@endsection
@section('content')
    <div class="side-title">
        <h3>{{ $head ?? '' }}</h3>
    </div>

    <div class="border-item">
        <form class="form-row add_member_form" method="post" action="{{ $action }}">
            @if($member ?? ''  && $member->id)
                @method('PUT')
            @endif
            @csrf

            <div class="form-group col-lg-2">
                <label>{{ __('members.member_type') }} </label>
                <select name="role" class="form-control {{ $errors->has('member_type') ? 'is-invalid' : '' }}">
{{--                    <option value="">{{ __('members.member_type') }}</option>--}}
                    <option {{($member->role ?? null) == 'user' ? 'selected' : ''}}  value="user">{{__('members.user')}}</option>
                    <option {{($member->role ?? null) == 'provider' ? 'selected' : ''}} value="provider">{{__('members.provider')}}</option>
                </select>
            </div>
            <div class="form-group col-lg-2">
                <label>{{ meta('status', getCurrentLocale()) ?? __('members.status') }} </label>
                <select name="status" class="form-control {{ $errors->has('status') ? 'is-invalid' : '' }}">
{{--                    <option selected value="">{{__('members.status')}}</option>--}}
                    <option {{old('status', $member->status ?? null) == 1 ? 'selected' : '' }} value="1">{{__('members.active')}}</option>
                    <option {{old('status', $member->status ?? null) == '0' ? 'selected' : '' }} value="0">{{__('members.non_active')}}</option>
                </select>
            </div>
            <div class="form-group col-lg-2 show_in_provider d-none">
                <label>{{ meta('website_percentage', getCurrentLocale()) ?? __('settings.website_percentage') }}</label>
                <input type="number" min="1" class="form-control {{ $errors->has('website_percentage') ? 'is-invalid' : '' }}" name="website_percentage" placeholder="{{ meta('website_percentage', getCurrentLocale()) ?? __('settings.website_percentage') }}" value='{{ old("website_percentage", $member->website_percentage ?? "") }}'/>
            </div>

            <div class="form-group col-lg-6">
                <label>{{ meta('name', getCurrentLocale()) ?? __('members.name') }} </label>
                <input type="text" class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" name="name" placeholder="{{ meta('name', getCurrentLocale()) ??__('members.name') }}" value='{{ old("name", $member->name ?? "") }}'/>
            </div>
            <div class="form-group col-lg-6">
                <label>{{ meta('email', getCurrentLocale()) ?? __('members.email') }} </label>
                <input type="text" class="form-control {{ $errors->has('email') ? 'is-invalid' : '' }}" name="email" placeholder="{{ meta('email', getCurrentLocale()) ?? __('members.email') }}" value='{{ old("email", $member->email ?? "") }}' {{ ($member->email ?? null)}}/>
            </div>
            <div class="form-group col-lg-6">
                <label>{{ meta('phone', getCurrentLocale()) ?? __('members.phone') }} </label>
                <input type="text" class="form-control {{ $errors->has('phone') ? 'is-invalid' : '' }}" name="phone" placeholder="{{ meta('phone', getCurrentLocale()) ?? __('members.phone') }}" value='{{ old("phone", $member->phone ?? "") }}'/>
            </div>


            <div class="form-group col-lg-4 show_in_provider d-none">
                <label>{{ meta('region_id', $local) ?? __('halls.region_id') }} </label>
                <select name="region_id" class="form-control">
                    <option value="">{{ meta('region_id', $local) ?? __('halls.region_id') }}</option>
                    @if(count($regions))
                        @foreach($regions as $region)
                            <option {{($member->region_id ?? null) == $region->id ? 'selected': ''}} value="{{$region->id}}">{{$region->name}}</option>
                        @endforeach
                    @endif
                </select>
            </div>
            <div class="form-group col-lg-4 show_in_provider d-none">
                <label>{{ meta('city_id', $local) ?? __('halls.city_id') }} </label>
                <select name="city_id" class="form-control">
                    <option value="">{{ meta('city_id', $local) ?? __('halls.city_id') }}</option>
                    @if(count($cities))
                        @foreach($cities as $city)
                            <option {{($member->city_id ?? null) == $city->id ? 'selected': ''}} value="{{$city->id}}">{{$city->name}}</option>
                        @endforeach
                    @endif
                </select>
            </div>
            <div class="form-group col-lg-4 show_in_provider d-none">
                <label>{{ meta('sector_id', $local) ?? __('halls.sector_id') }} </label>
                <select name="sector_id" class="form-control">
                    <option value="">{{ meta('sector_id', $local) ?? __('halls.sector_id') }}</option>
                    @if(count($sectors))
                        @foreach($sectors as $sector)
                            <option {{($member->sector_id ?? null) == $sector->id ? 'selected': ''}} value="{{$sector->id}}">{{$sector->name}}</option>
                        @endforeach
                    @endif
                </select>
            </div>

            <div class="form-group col-lg-12 show_in_provider d-none">
                <label>{{ meta('street', getCurrentLocale()) ?? __('members.street') }} </label>
                <input type="text" class="form-control {{ $errors->has('street') ? 'is-invalid' : '' }}" name="street" placeholder="{{ meta('street', getCurrentLocale()) ?? __('members.street') }}" value='{{ old("street", $member->street ?? "") }}'/>
            </div>
{{--            @if(($member ?? null)  && $member->id && $member->role == 'provider')--}}
                <div class="form-group col-lg-3 show_in_provider d-none">
                    <label>{{ meta('iban', getCurrentLocale()) ?? __('members.iban') }} </label>
                    <input class="form-control bg-white" readonly value='{{ ($member->bank_acc_info['iban'] ?? "") }}'/>
                </div>
                <div class="form-group col-lg-3 show_in_provider d-none">
                    <label>{{ meta('acc_no', getCurrentLocale()) ?? __('members.acc_no') }} </label>
                    <input class="form-control bg-white" readonly value='{{ ($member->bank_acc_info['acc_no'] ?? "") }}'/>
                </div>
                <div class="form-group col-lg-3 show_in_provider d-none">
                    <label>{{ meta('bank_name', getCurrentLocale()) ?? __('members.bank_name') }} </label>
                    <input class="form-control bg-white" readonly value='{{ ($member->bank_acc_info['bank_name'] ?? "") }}'/>
                </div>
                <div class="form-group col-lg-3 show_in_provider d-none">
                    <label>{{ meta('client_name', getCurrentLocale()) ?? __('members.client_name') }} </label>
                    <input class="form-control bg-white" readonly value='{{ ($member->bank_acc_info['client_name'] ?? "") }}'/>
                </div>
{{--            @endif--}}
            <div class="form-group col-lg-6">
                <label>{{ meta('password', getCurrentLocale()) ?? __('members.password') }} </label>
                <input type="password" class="form-control {{ $errors->has('password') ? 'is-invalid' : '' }}" name="password" placeholder="{{ meta('password', getCurrentLocale()) ?? __('members.password') }}" value='{{ old("password", "") }}'/>
            </div>

            <div class="form-group col-lg-6">
                <label>{{ meta('password_confirmation', getCurrentLocale()) ?? __('members.password_confirmation') }} </label>
                <input type="password" class="form-control {{ $errors->has('password_confirmation') ? 'is-invalid' : '' }}" name="password_confirmation" placeholder="{{ meta('password_confirmation', getCurrentLocale()) ?? __('members.password_confirmation') }}" value='{{ old("password_confirmation", "") }}'/>
            </div>

                <div class="card p-3 mb-3 col-lg-12 d-none show_in_provider">
{{--                    <label>{{ meta('contract_agreement', $local) ??  __('members.contract_agreement') }} </label>--}}
                    <div class="row card-body">
                        <div class="col-md-4">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" {{ ($member->contract_agreement ?? null ) ? 'checked' : '' }} value="1" class="custom-control-input" id="contract_agreement" name="contract_agreement">
                                <label class="custom-control-label" for="contract_agreement">{{__('members.contract_agreement')}}</label>
                            </div>
                        </div>
                        @if($member->contract_agreement_date ?? null)

                            <div class="form-group col-lg-8">
                                <label class="">{{ meta('contract_agreement_date', getCurrentLocale()) ?? __('members.contract_agreement_date') }} </label>
                                <input class="form-control bg-white" value='{{ $member->contract_agreement_date }}'/>
                            </div>
                        @endif

                    </div>
                </div>

            {{--Start image container--}}
            <div class="form-group col-lg-4">
                <label>{{ meta('photo', getCurrentLocale()) ?? __('members.photo') }} </label>
                <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="photo" value="{{old("photo", $member->photo ?? "")}}"/>

                <div class="photos main_photo {{ old('photo', $member->photo ?? '') ? ' wow fadeInUp' : 'hide' }}">
                    <div class="col-lg-12">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="{{asset(old('photo', $member->photo ?? ''))}} "  id="image_holder" class="image_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn pick_button {{ old('photo', $member->photo ?? '') ? 'hide' : '' }} ">
                <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> Choose
                </a>
            </span>
            </div>
            {{--End image container--}}

                {{--Start logo container--}}
                <div class="form-group col-lg-4 d-none show_in_provider">
                    <label>{{ meta('logo', getCurrentLocale()) ?? __('members.logo') }} </label>
                    <input id="logo_image_thumbnail" class="logo_image_thumbnail" type="hidden" name="logo" value="{{old("logo", $member->logo ?? "")}}"/>

                    <div class="photos logo_main_photo {{ old('logo', $member->logo ?? '') ? ' wow fadeInUp' : 'hide' }}">
                        <div class="col-lg-12">
                            <div class="items">
                                <div class="img">
                                    <a href="#" id="lfm" data-input=".logo_image_thumbnail" data-preview=".logo_image_holder" class="lfm" data-hide=".pick_button">
                                        <img src="{{asset(old('logo', $member->logo ?? ''))}} "  id="logo_image_holder" class="logo_image_holder"/>
                                    </a>
                                </div>
                                <a href="#" class="showHide resetImage close" data-empty=".logo_image_thumbnail" data-hide=".logo_main_photo" data-show=".logo_pick_button"><i class="fas fa-times"></i></a>
                            </div>
                            @if($member->logo ?? null)
                                <h5><a href="{{asset($member->logo)}}" class="btn btn-success" download><i class="fa fa-download"></i> {{__('members.download')}}</a></h5>
                            @endif
                        </div>
                    </div>
                    <div class="clearfix"></div>
                    <span class="input-group-btn logo_pick_button {{ old('logo', $member->logo ?? '') ? 'hide' : '' }} ">
                    <a id="lfm" data-input=".logo_image_thumbnail" data-preview=".logo_image_holder" data-show=".logo_main_photo" data-hide=".logo_pick_button" class="lfm btn btn-primary text-light">
                        <i class="fas fa-camera-retro"></i> Choose
                    </a>
                </span>
                </div>
                {{--End logo container--}}

            {{--Start image container--}}
            <div class="form-group col-lg-4 d-none show_in_provider">
                <label>{{ meta('commercial_file', getCurrentLocale()) ?? __('members.commercial_file') }} </label>
                <input id="commercial_file_image_thumbnail" class="commercial_file_image_thumbnail" type="hidden" name="commercial_file" value="{{old("commercial_file", $member->commercial_file ?? "")}}"/>

                <div class="photos commercial_file_main_photo {{ old('commercial_file', $member->commercial_file ?? '') ? ' wow fadeInUp' : 'hide' }}">
                    <div class="col-lg-12">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".commercial_file_image_thumbnail" data-preview=".commercial_file_image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="{{asset(old('commercial_file', $preview ?? ''))}} "  id="commercial_file_image_holder" class="commercial_file_image_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".commercial_file_image_thumbnail" data-hide=".commercial_file_main_photo" data-show=".commercial_file_pick_button"><i class="fas fa-times"></i></a>
                        </div>
                        @if($member->commercial_file ?? null)
                            <h5><a href="{{asset($member->commercial_file)}}" class="btn btn-success" download><i class="fa fa-download"></i> {{__('members.download')}}</a></h5>
                        @endif
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn commercial_file_pick_button {{ old('commercial_file', $member->commercial_file ?? '') ? 'hide' : '' }} ">
                    <a id="lfm" data-input=".commercial_file_image_thumbnail" data-preview=".commercial_file_image_holder" data-show=".commercial_file_main_photo" data-hide=".commercial_file_pick_button" class="lfm btn btn-primary text-light">
                        <i class="fas fa-camera-retro"></i> Choose
                    </a>
                </span>
            </div>
            {{--End image container--}}



                <div class="text-center mt-5 col-12">
                <button class="butn add_member_button"><span>{{ __('dashboard.save') }}</span></button>
            </div>
        </form>
    </div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
    {{--        <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>--}}
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{--    <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    {{--    <script src="https://cdn.tiny.cloud/1/cvo4dn512c81ken3vhruwrooatptt4zew0lyb0ey4pas8mp1/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>--}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            imagePath = "{{asset('')}}",
            inputName = null,
            currentLanguage = "{{$local}}",
            getCityAndSectorRoute = "{{route('members.getCityAndSector')}}";
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>
    <script src="{{ asset('assets/web/js/lib/toastr.min.js') }}"></script>


    <script>

        let selectOption = $('select[name="role"] option:selected').val();
        if (selectOption === 'user'){
            $('.show_in_provider').addClass('d-none');
            $('input[name="name"]').parents('.form-group').toggleClass('col-lg-6 col-lg-8');
        }
        if(selectOption === 'provider') {
            $('.show_in_provider').removeClass('d-none');
        }
        $('select[name="role"]').change(function () {
            $('input[name="name"]').parents('.form-group').toggleClass('col-lg-6 col-lg-8');
            if($(this).val() === 'user'){
                $('.show_in_provider').addClass('d-none');
                $('.show_in_provider input').val('');
                $('.show_in_provider select').val('');
            }
            if($(this).val() === 'provider') {
                $('.show_in_provider').removeClass('d-none');
            }
        });

        $('.add_member_button').click(async function (e) {
            e.preventDefault();

            let form = $('.add_member_form'),
                data = new FormData(form[0]),
                url = form.attr('action'),
                method = form.attr('method');

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.url){
                window.location.href = response.url;
            }

            if (response.errors){
                toasterError(response.errors);
            }
        });

        $('select[name="region_id"], select[name="city_id"]').change(async function (e) {
            e.preventDefault();

            let data = {},
                url = getCityAndSectorRoute,
                method = 'get';

            if($(this).attr('name') === 'region_id'){
                $('select[name="city_id"]').html(`<option value="">{{ __('halls.city_id') }}</option>`);
                $('select[name="sector_id"]').html(`<option value="">{{ __('halls.sector_id') }}</option>`);

                data.region_id = $(this).val();
            }
            if($(this).attr('name') === 'city_id'){
                $('select[name="sector_id"]').html(`<option value="">{{ __('halls.sector_id') }}</option>`);
                data.city_id = $(this).val();
            }

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.status === 'city'){
                if (response.data.length){
                    for (let i = 0; i < response.data.length; i++){
                        $('select[name="city_id"]').append(`<option value="`+response.data[i].id+`">`+response.data[i].name+`</option>`)
                    }
                }
            }
            if (response.status === 'sector'){
                if (response.data.length){
                    for (let i = 0; i < response.data.length; i++){
                        $('select[name="sector_id"]').append(`<option value="`+response.data[i].id+`">`+response.data[i].name+`</option>`)
                    }
                }
            }

            if (response.errors){
                toasterError(response.errors);
            }


        });


    </script>

@endsection
