<section class="sidemenu">
    <div class="logo">
        <img src="{{asset('/assets/admin/images/logo-footer.svg')}}" alt="">
    </div>
    <ul class="sidemenu-links">
        <li class="{{ $activeMenu[""] ?? '' }}">
            <a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('dashboard'), [], true)}}"> <i class="bi bi-bar-chart"></i> <span>{{ __('dashboard.dashboard')}}</span></a>
        </li>
        @foreach ($currentUserInfo->modules->toArray() as $module)

            @php
                /** @var $module */

                $moduleName = moduleName($module['path'], getCurrentLocale());
                $moduleAddNew = metaFields($module['path'], 'add_new', getCurrentLocale());
            @endphp


            @if (in_array($module['path'], ['pages', 'reservations', 'settings', 'abouts', 'comments', 'policies', 'contracts', 'pendingBaskets', 'wallets'])
                || (auth()->user()->role == 'sub_admin' && $module['path'] == 'users'))

                <li class="{{ $activeMenu[$module['path']] ?? '' }}">
                    <a href="{{ route("{$module['path']}.index") }}">

                        <i class="{{ __($module['path'].'.menuIcon') ?? 'fas fa-edit' }}"></i>
                        <span>{{$moduleName ?? __($module['path'].'.head') }}</span>

                    </a>
                </li>

            @else
                <li class="linkGroup  {{ $activeMenu[$module['path']] ?? '' }}">
                    <a onclick="return false" href="#" class="linkItem-head"> <i class="{{ __($module['path'].'.menuIcon') ?? 'fas fa-edit' }}"></i> <span> {{ $moduleName ??__($module['path'].'.head') }} </span></a>
                    <ul class="linkItem-body">
                        <li>
                            <a href='{{ route("{$module['path']}.index") }}'>{{$moduleName ?? __($module['path'].'.head') }}</a>
                        </li>
                        <li>
                            @if ($module['path'] == 'newsletters')
                                <a href="{{ route("{$module['path']}.mailsList")  }}">{{  $moduleAddNew ?? __($module['path'].'.mail_list')}}</a>
                            @else
                                <a href="{{ route("{$module['path']}.create")  }}">{{ $moduleAddNew ?? __($module['path'].'.new')}}</a>
                            @endif
                        </li>

                    </ul>
                </li>
            @endif

        @endforeach
        <li>
            <a data-toggle="modal" data-target="#logout" href="{{ route('admin_logout') }}" ><i class="fas fa-sign-out-alt"></i> <span> {{ __('dashboard.logout') }} </span></a>
        </li>
    </ul>
</section>



{{-- Log out Modal --}}

<!-- Modal -->
<div class="modal fade" id="logout" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">{{__('dashboard.logout_confirm')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <h3>{{__('dashboard.logout_confirm_warning')}} <i class="fa fa-exclamation-circle text-danger"></i></h3>
                <form id="logout-form-side" action="{{ route('admin_logout') }}" method="POST" style="display: none;">
                    @csrf
                </form>
            </div>
            <div class="modal-footer justify-content-between">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{__('dashboard.close')}}</button>
                <button onclick="document.getElementById('logout-form-side').submit()" type="button" class="btn btn-primary">{{__('dashboard.logout')}}</button>
            </div>
        </div>
    </div>
</div>


