<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="" />
    <meta name="keywords" content="" />
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'CMS') .' - '. ($title ?? '') }}</title>
    <link rel="shortcut icon" href="{{ asset($logo ?? 'assets/admin/images/logo-footer.svg') }}" title="Favicon" sizes="16x16" />


    @if (app()->getLocale() == 'ar')
        <link rel="stylesheet" href="{{ asset('assets/admin/css/lib/bootstrap-rtl.min.css') }}" />
    @endif

    @if (app()->getLocale() == 'en')
        <link rel="stylesheet" href="{{ asset('assets/admin/css/lib/bootstrap-ltr.min.css') }}" />
    @endif

    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@200;300;400;500;700;800;900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Rubik:400,500,700,900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/admin/css/lib/animate.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/admin/css/lib/jquery-ui.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/admin/css/lib/jquery-ui.theme.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/admin/css/lib/all.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/admin/css/lib/jquery.fancybox.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/admin/css/styles.css') }}" />
    <link rel="stylesheet" href="{{asset('assets/admin/css/lib/toastr.css')}}">

    @if (app()->getLocale() == 'ar')
        <link rel="stylesheet" href="{{ asset('assets/admin/css/style_ar.css') }}" />
    @endif

    @yield('css')

</head>

<body>

@yield('container_content')
<script src="{{ asset('assets/admin/js/lib/jquery-3.0.0.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/lib/jquery-migrate-3.0.0.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/lib/popper.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/lib/bootstrap.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/lib/wow.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/lib/jquery-ui.js') }}"></script>
<script src="{{ asset('assets/admin/js/lib/jquery.fancybox.js') }}"></script>
<script src="{{ asset('assets/admin/js/main.js') }}"></script>
<script src="{{ asset('assets/admin/js/lib/toastr.min.js') }}"></script>

@yield('container_js')
</body>

</html>
