@extends('admin.layouts.layout')

@section('container_content')
    @include('admin.layouts.menu')


    <!-- ------------ top nav ------------- -->
    <section class="top-nav">
        <div class="row">
            <div class="col-lg-5">
                <div class="title">
                    <h3>{{ $title ?? __('dashboard.title')}}</h3>

                </div>
            </div>
            <!-- <div class="col-lg-4">
                <div class="search-bar">
                    <form>
                        <div class="form-group">
                            <input class="form-control" type="text" placeholder="search">
                            <button><i class="fas fa-search"></i></button>
                        </div>
                    </form>
                </div>
            </div> -->
            <div class="col-lg-3">
{{--                <ul class="notivacations">--}}
{{--                    <li class="items notivacat">--}}
{{--                        <div class="icon">--}}
{{--                            <i class="far fa-bell"></i>--}}
{{--                            <span class="num">--}}
{{--                                1--}}
{{--                            </span>--}}
{{--                        </div>--}}
{{--                    </li>--}}
{{--                </ul>--}}
            </div>
            <div class="col-lg-4">
                <div class="profile-nav">
                    <div class="info">
                        <h5>{{ $currentUserInfo->name ?? '' }}</h5>
                    </div>
                    <div class="user-img dropdown show">
                        <a href="#" class="dropdown-toggle" role="button" id="dropdownMenuLink" data-toggle="dropdown">
                            <img src="{{ asset($currentUserInfo->photo) }}" alt="">
                        </a>
                        <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                            <div class="pic text-center">
                                <img src="{{ asset($currentUserInfo->photo) }}" alt="">
                                <h5>{{ $currentUserInfo->name ?? '' }}</h5>
                            </div>
                            <a class="dropdown-item" href="{{ route('admin_logout') }}"
                               onclick="event.preventDefault();document.getElementById('logout-form').submit();"><i class="fas fa-sign-out-alt"></i> {{ __('dashboard.logout') }}
                            </a>
                            <form id="logout-form" action="{{ route('admin_logout') }}" method="POST" style="display: none;">
                                @csrf
                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="toggelmenu">
            <span></span>
            <span></span>
            <span></span>
            <i class="fas fa-arrow-right"></i>
        </div>
    </section>

    <!--Contents-->
    <main class="main">
        @if(count($errors))
            <div class="alert alert-danger">
                @foreach($errors->all() as $error)
                    <li>
                        {{$error}}
                    </li>
                @endforeach
            </div>
        @endif

        @if (session('message'))
            <div class="alert alert-success message_alert">{{session('message')}}</div>
        @endif

        <div class="alert alert-danger ajaxErrorResponse" style="display: none"></div>
        <div class="alert alert-success ajaxResponse" style="display: none"></div>

    <!-- Response of ajax requests -->


        @yield('content')
    </main>

    <!--Footer-->
    <footer class="">
        <div class="loading hide">
            <div class="loader"></div>
        </div>
    </footer>
    <!--End-Footer-->
    <!-- -------------- request ----------------- -->
    <!-- <a class="to-top" data-scroll href="#bazinga" id="scroll-btn">
        <i class="fa fa-arrow-up"></i>
    </a> -->
@endsection

@section('container_js')
    {{--    <script src="https://unpkg.com/axios/dist/axios.min.js"></script>--}}
    <script src="{{ asset('assets/admin/js/lib/axios.min.js') }}"></script>

    <script>
        axios.defaults.headers.common = {
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN' : document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        };
    </script>
    <script src="{{ asset('assets/admin/js/actions.js') }}"></script>
    @yield('inner_js')
@endsection
