@extends('admin.layouts.container')

@section('content')
    <div class="side-title">
        <h3>{{$head ?? '' }}</h3>
    </div>

    <div class="border-item">
        <form class="form-row add_hall_from" method="post" action="{{ $action }}" enctype="multipart/form-data">
            @if($hall ?? ''  && $hall->id)
                @method('PUT')
            @endif
            @csrf
            <div class="form-group col-lg-4">
                <label>{{ meta('user_id', $local) ?? __('halls.user_id') }} </label>
                <select name="user_id" class="form-control">
                    <option value="">{{ meta('user_id', $local) ?? __('halls.user_id') }}</option>
                    @if(count($providers))
                        @foreach($providers as $provider)
                            <option {{($hall->user_id ?? null) == $provider->id ? 'selected': ''}} value="{{$provider->id}}">{{$provider->name}}</option>
                        @endforeach
                    @endif
                </select>
            </div>
            <div class="form-group col-lg-4">
                <label>{{ meta('category_id', $local) ?? __('halls.category_id') }} </label>
                <select name="category_id" class="form-control">
                    <option value="">{{ meta('category_id', $local) ?? __('halls.category_id') }}</option>
                    @if(count($categories))
                        @foreach($categories as $category)
                            <option {{($hall->category_id ?? null) == $category->id ? 'selected': ''}} value="{{$category->id}}">{{$category->name}}</option>
                        @endforeach
                    @endif
                </select>
            </div>
            <div class="form-group col-lg-2">
                <label>{{ meta('is_offer', $local) ?? __('halls.is_offer') }} </label>
                <select name="is_offer" class="form-control">
                    {{--                    <option value="">{{ meta('is_offer', $local) ?? __('halls.is_offer') }}</option>--}}
                    <option {{($hall->is_offer ?? null) == 1 ? 'selected': ''}} value="1">{{__('halls.yes')}}</option>
                    <option {{($hall->is_offer ?? null) == 0 ? 'selected': ''}} value="0">{{__('halls.no')}}</option>
                </select>
            </div>
            <div class="form-group col-lg-2">
                <label>{{ meta('status', $local) ?? __('halls.status') }} </label>
                <select name="hall_status" class="form-control">
                    <option value="">{{ meta('status', $local) ?? __('halls.status') }}</option>
                    <option {{($hall->hall_status ?? null) == 1 ? 'selected': ''}} value="1">{{__('halls.active')}}</option>
                    <option {{($hall->hall_status?? null) == 0 ? 'selected': ''}} value="0">{{__('halls.non_active')}}</option>
                </select>
            </div>
            <div class="form-group col-lg-4">
                <label>{{ meta('region_id', $local) ?? __('halls.region_id') }} </label>
                <select name="region_id" class="form-control">
                    <option value="">{{ meta('region_id', $local) ?? __('halls.region_id') }}</option>
                    @if(count($regions))
                        @foreach($regions as $region)
                            <option {{($hall->region_id ?? null) == $region->id ? 'selected': ''}} value="{{$region->id}}">{{$region->name}}</option>
                        @endforeach
                    @endif
                </select>
            </div>
            <div class="form-group col-lg-4">
                <label>{{ meta('city_id', $local) ?? __('halls.city_id') }} </label>
                <select name="city_id" class="form-control">
                    <option value="">{{ meta('city_id', $local) ?? __('halls.city_id') }}</option>
                    @if(count($cities))
                        @foreach($cities as $city)
                            <option {{($hall->city_id ?? null) == $city->id ? 'selected': ''}} value="{{$city->id}}">{{$city->name}}</option>
                        @endforeach
                    @endif
                </select>
            </div>
            <div class="form-group col-lg-4">
                <label>{{ meta('sector_id', $local) ?? __('halls.sector_id') }} </label>
                <select name="sector_id" class="form-control">
                    <option value="">{{ meta('sector_id', $local) ?? __('halls.sector_id') }}</option>
                    @if(count($sectors))
                        @foreach($sectors as $sector)
                            <option {{($hall->sector_id ?? null) == $sector->id ? 'selected': ''}} value="{{$sector->id}}">{{$sector->name}}</option>
                        @endforeach
                    @endif
                </select>
            </div>
            <div class="form-group col-lg-12">
                <label>{{ meta('street', $local) ?? __('halls.street') }} </label>
                <div class="row">
                    <div class="col-md-10">
                        <input type="text" id="street" class="form-control" name="street" placeholder="{{ meta('street', $local) ?? __('halls.street') }}" value='{{ $hall->street ?? "" }}'/>
                        <input type="hidden" name="lat" value='{{ $hall->lat ?? "" }}'>
                        <input type="hidden" name="lng" value='{{ $hall->lng ?? "" }}'>
                    </div>
                    <div class="col-md-2">
                        <button type="button" class="butn small modal-btn map_modal_button" data-toggle="modal" data-target="#exampleModalCenter">
                            <span>{{__('halls.your_location')}}</span>
                        </button>
                    </div>

                </div>
            </div>
            <div class="form-group col-lg-6">
                <label>{{ meta('reservation_way', $local) ?? __('halls.reservation_way') }} </label>
                <select name="reservation_way" class="form-control">
                    <option value="">{{ meta('reservation_way', $local) ?? __('halls.reservation_way') }}</option>
                    <option {{($hall->reservation_way ?? null) == 'direct' ? 'selected' : ''}} value="direct">{{__('halls.direct')}}</option>
                    <option {{($hall->reservation_way ?? null) == 'accept_request' ? 'selected' : ''}} value="accept_request">{{__('halls.accept_request')}}</option>
                </select>
            </div>
            <div class="form-group col-lg-6">
                <label>{{ meta('reservation_type', $local) ?? __('halls.reservation_type') }} </label>
                <select name="reservation_type" class="form-control">
                    {{--                    <option value="">{{ meta('reservation_type', $local) ?? __('halls.reservation_type') }}</option>--}}
                    <option {{($hall->reservation_type ?? null) == 'person_count' ? 'selected' : ''}} value="person_count">{{__('halls.person_count')}}</option>
                    <option {{($hall->reservation_type ?? null) == 'days_count' ? 'selected' : ''}} value="days_count">{{__('halls.days_count')}}</option>
                </select>
            </div>
            <div class="form-group col-lg-6">
                <label>{{ meta('capacity', $local) ?? __('halls.capacity') }} </label>
                <input type="number" min="1" class="form-control" name="capacity" placeholder="{{ meta('capacity', $local) ?? __('halls.capacity') }}" value='{{ $hall->capacity ?? "" }}'/>
            </div>

            <div class="form-group col-lg-6 booking_amount_per_person">
                <label>{{ meta('booking_amount_per_person', $local) ?? __('halls.booking_amount_per_person') }} </label>
                <input type="number" min="1" class="form-control" name="booking_amount_per_person" placeholder="{{ meta('booking_amount_per_person', $local) ?? __('halls.booking_amount_per_person') }}" value='{{ $hall->booking_amount_per_person ?? "" }}'/>
            </div>
            <div class="form-group col-lg-6 d-none booking_amount_per_day">
                <label>{{ meta('booking_amount_per_day', $local) ?? __('halls.booking_amount_per_day') }} </label>
                <input type="number" min="1" class="form-control" name="booking_amount_per_day" placeholder="{{ meta('booking_amount_per_day', $local) ?? __('halls.booking_amount_per_day') }}" value='{{ $hall->booking_amount_per_day ?? "" }}'/>
            </div>

            <div class="form-group col-lg-6">
                <label>{{ meta('min_capacity', $local) ?? __('halls.min_capacity') }} </label>
                <input type="number" min="1" class="form-control" name="min_capacity" placeholder="{{ meta('min_capacity', $local) ?? __('halls.min_capacity') }}" value='{{ $hall->min_capacity ?? "" }}'/>
            </div>
            <div class="form-group col-lg-6">
                <label>{{ meta('total_capacity', $local) ?? __('halls.total_capacity') }} </label>
                <input type="number" min="1" class="form-control" name="total_capacity" placeholder="{{ meta('total_capacity', $local) ?? __('halls.total_capacity') }}" value='{{ $hall->total_capacity ?? "" }}'/>
            </div>

            {{-- Dates range --}}
            <div class="card col-lg-12 p-3 mb-3">
                <label>{{__('halls.dates_rang') }} </label>
                <div class="row justify-content-start align-items-center align-content-center">
                    <div class="form-group col-md-6">
                        <input type="text" placeholder="{{ __('halls.dates_rang_from') }}" name="dates_rang_from" value="{{($hall->available_dates['dates_rang_from'] ?? null)}}" class="my_datepicker form-control">
                    </div>
                    <div class="form-group col-md-6">
                        <input type="text" placeholder="{{ __('halls.dates_rang_to') }}" name="dates_rang_to" value="{{($hall->available_dates['dates_rang_to'] ?? null)}}" class="my_datepicker form-control">
                    </div>
                </div>
            </div>
            {{-- UnAvailable dates block--}}
            <div class="card col-lg-12 p-3 mb-3">
                <label>{{__('halls.unavailable_dates') }} </label>
                <div class="unavailable_dates_container_person">
                    @if(count($hall->unavailable_dates ?? []))
                        @foreach($hall->unavailable_dates as $unAvailableDate)
                            <div class="row justify-content-start align-items-center align-content-center unavailable_date_item">
                                <div class="form-group col-md-2">
                                    <a class="btn btn-danger delete_unavailable_date_link" href="#"><i class="fa fa-times"></i></a>
                                </div>
                                <div class="form-group col-md-5">
                                    <input type="text" placeholder="{{ __('halls.unavailable_dates_from') }}" name="unavailable_dates_from[]" value="{{$unAvailableDate[0]}}" class="my_datepicker form-control">
                                </div>
                                <div class="form-group col-md-5">
                                    <input type="text" placeholder="{{ __('halls.unavailable_dates_to') }}" name="unavailable_dates_to[]" value="{{last($unAvailableDate)}}" class="my_datepicker form-control">
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <a data-target=".unavailable_dates_container_person" href="#" class="btn btn-primary btn-sm btn-block add_unavailable_dates_link"><i class="fa fa-plus"></i></a>
                    </div>
                </div>
            </div>
            {{-- Discount dates block--}}
            <div class="card col-lg-12 p-3 mb-3">
                <label>{{ __('halls.discount_dates') }}</label>
                <div class="discount_dates_container_person">
                    @if(count($hall->discount_dates ?? []))
                        @foreach($hall->discount_dates as $discountDates)
                            <div class="row align-items-center discount_date_item">
                                <div class="form-group col-md-1">
                                    <a class="btn btn-danger delete_discount_date_link" href="#"><i class="fa fa-times"></i></a>
                                </div>
                                <div class="form-group col-md-3">
                                    <input type="text" placeholder="{{ __('halls.discount_dates_from') }}" name="discount_dates_from[]" value="{{$discountDates['dates'][0]}}" class="my_datepicker form-control">
                                </div>
                                <div class="form-group col-md-3">
                                    <input type="text" placeholder="{{ __('halls.discount_dates_to') }}" name="discount_dates_to[]" value="{{last($discountDates['dates'])}}" class="my_datepicker form-control">
                                </div>
                                <div class="form-group col-md-5">
                                    <div class="custom-control custom-checkbox">
                                        <div class="discount_dates_container d-flex justify-content-start align-content-center align-items-center custom-control_3">
                                            {{--                                        <input type="checkbox" value="1" class="custom-control-input discount_dates_input person_discount_dates_input" id="person_discount_dates_1">--}}
                                            {{--                                        <label class="custom-control-label col-md-4" for="person_discount_dates_1"> {{__('halls.discount')}}</label>--}}
                                            <input name="discount_percentage[]" type="number" min="1" pattern="/[1-9]/" class="discount_percentage col-md-8 form-control" placeholder="{{__('halls.discount_percentage')}}" value="{{$discountDates['discount_percentage']}}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <a data-target=".discount_dates_container_person" href="#" class="btn btn-primary btn-sm btn-block add_discount_dates_link"><i class="fa fa-plus"></i></a>
                    </div>
                </div>
            </div>

                <div class="card p-3 mb-3 col-lg-12">
                    <label>{{ __('halls.table_ids') }} </label>
                    <div class="row card-body">
                        @if(count($tables))
                            @foreach($tables as $table)
                                <div class="col-md-4">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" {{ in_array($table->id, $hall['table_ids'] ?? []) ? 'checked' : '' }} value="{{ $table->id }}" class="custom-control-input" id="tables_{{ $table->id }}" name="table_ids[]">
                                        <label class="custom-control-label" for="tables_{{ $table->id }}"> {{$table->name}}</label>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>

            <div class="card p-3 mb-3 col-lg-12">
                <label>{{ meta('occasions', $local) ??  __('halls.occasions') }} </label>
                <div class="row card-body">
                    @if(count($occasions))
                        @foreach($occasions as $occasion)
                            <div class="col-md-4">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" {{ in_array($occasion->id, $hall['occasions'] ?? []) ? 'checked' : '' }} value="{{ $occasion->id }}" class="custom-control-input" id="occasions_{{ $occasion->id }}" name="occasions[]">
                                    <label class="custom-control-label" for="occasions_{{ $occasion->id }}"> {{$occasion->name}}</label>
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>
            </div>
            @foreach(languages() as $language)
                <div class="form-group col-lg-12">
                    <label>{{ meta('name', $language->local) ?? __('halls.name') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <input type="text" class="form-control" name="name_{{ $language->local }}" placeholder="{{ meta('name', $language->local) ?? __('halls.name') }}" value='{{ $hall[$language->local]->name ?? "" }}'/>
                </div>

                <div class="form-group col-lg-12">
                    <label>{{ meta('description', $language->local) ?? __('halls.description') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <textarea rows="7" name="description_{{ $language->local }}" class="form-control " placeholder="{{ meta('description', $language->local) ?? __('halls.description') }}">{!! $hall[$language->local]->description ?? "" !!}</textarea>
                </div>

                    <div class="form-group col-lg-12">
                        <label>{{ meta('reservation_condition', $language->local) ?? __('halls.reservation_condition') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                        <textarea rows="7" name="reservation_condition_{{ $language->local }}" class="form-control " placeholder="{{ meta('reservation_condition', $language->local) ?? __('halls.reservation_condition') }}">{!! $hall[$language->local]->reservation_condition ?? "" !!}</textarea>
                    </div>

                    <div class="form-group col-lg-12">
                        <label>{{ meta('features', $language->local) ?? __('halls.features') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                        <textarea rows="7" name="features_{{ $language->local }}" class="form-control " placeholder="{{ meta('features', $language->local) ?? __('halls.features') }}">{!! $hall[$language->local]->features ?? "" !!}</textarea>
                    </div>

            @endforeach

            <div class="service_container col-md-12">
                @if(($hall ?? null) && is_array($hall->added_services) && count($hall->added_services))
                    @foreach($hall->added_services as $service)
                        <div class="form-group col-lg-12 card deleted_service service_card">
                            <label>{{ __('halls.added_services') }}</label>
                            <div class="row">
                                @if($loop->iteration != 1)
                                    <div class="form-group col-md-12 d-flex justify-content-end">
                                        <a href="#" class="btn btn-danger delete_service mr-3"><i class="fa fa-times"></i></a>
                                    </div>
                                @endif
                                <div class="form-group col-md-6">
                                    <input type="text" name="added_services_name[]" placeholder="{{__('halls.added_services_name')}}" class="form-control" value="{{$service->name}}"/>
                                </div>
                                <div class="form-group col-md-6">
                                    <input type="number" min="1" name="added_services_price[]"  placeholder="{{__('halls.added_services_price')}}" class="form-control" value="{{$service->price}}"/>
                                </div>
                                <div class="from-group col-md-12">
                                    <textarea name="added_services_description[]"  placeholder="{{__('halls.added_services_description')}}" class="form-control" cols="30" rows="5">{{$service->description}}</textarea>
                                </div>
                                <div class="form-group col-lg-12">
                                    <label>{{ __('halls.added_services_image') }} </label>
                                    <input id="image_thumbnail_{{$loop->iteration}}" class="image_thumbnail_{{$loop->iteration}}" type="hidden" name="added_services_image[]" value="{{old("added_services_image", $service->image ?? "")}}"/>

                                    <div class="photos main_photo_{{$loop->iteration}} {{ old('added_services_image', $service->image ?? '') ? ' wow fadeInUp' : 'hide' }}">
                                        <div class="col-lg-4">
                                            <div class="items">
                                                <div class="img">
                                                    <a href="#" id="lfm" data-input=".image_thumbnail_{{$loop->iteration}}" data-preview=".image_holder_{{$loop->iteration}}" class="lfm" data-hide=".pick_button">
                                                        <img src="{{asset(old('added_services_image', $service->image ?? ''))}} "  id="image_holder_{{$loop->iteration}}" class="image_holder_{{$loop->iteration}}"/>
                                                    </a>
                                                </div>
                                                <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail_{{$loop->iteration}}" data-hide=".main_photo_{{$loop->iteration}}" data-show=".pick_button_{{$loop->iteration}}"><i class="fas fa-times"></i></a>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="clearfix"></div>
                                    <span class="input-group-btn pick_button_{{$loop->iteration}} {{ old('added_services_image', $service->image) ? 'hide' : '' }} ">
                                        <a id="lfm" data-input=".image_thumbnail_{{$loop->iteration}}" data-preview=".image_holder_{{$loop->iteration}}" data-show=".main_photo_{{$loop->iteration}}" data-hide=".pick_button_{{$loop->iteration}}" class="lfm btn btn-primary text-light">
                                            <i class="fas fa-camera-retro"></i> Choose
                                        </a>
                                    </span>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="form-group col-lg-12 card deleted_service service_card">
                        <label>{{ __('halls.added_services') }}</label>
                        <div class="row">
                            <div class="form-group col-md-12 d-flex justify-content-end">
                                <a href="#" class="btn btn-danger delete_service mr-3"><i class="fa fa-trash-alt"></i></a>
                            </div>
                            <div class="form-group col-md-6">
                                <input type="text" name="added_services_name[]" placeholder="{{__('halls.added_services_name')}}" class="form-control" value=""/>
                            </div>
                            <div class="form-group col-md-6">
                                <input type="number" min="1" name="added_services_price[]"  placeholder="{{__('halls.added_services_price')}}" class="form-control" value=""/>
                            </div>
                            <div class="from-group col-md-12">
                                <textarea name="added_services_description[]"  placeholder="{{__('halls.added_services_description')}}" class="form-control" cols="30" rows="5"></textarea>
                            </div>
                            <div class="form-group col-lg-12">
                                <label>{{ __('halls.added_services_image') }} </label>
                                <input id="image_thumbnail_1" class="image_thumbnail_1" type="hidden" name="added_services_image[]" value=""/>

                                <div class="photos main_photo_1 hide">
                                    <div class="col-lg-4">
                                        <div class="items">
                                            <div class="img">
                                                <a href="#" id="lfm" data-input=".image_thumbnail_1" data-preview=".image_holder_1" class="lfm" data-hide=".pick_button_1">
                                                    <img src=""  id="image_holder_1" class="image_holder_1"/>
                                                </a>
                                            </div>
                                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail_1" data-hide=".main_photo_1" data-show=".pick_button_1"><i class="fas fa-times"></i></a>
                                        </div>
                                    </div>
                                </div>

                                <div class="clearfix"></div>
                                <span class="input-group-btn pick_button_1">
                                <a id="lfm" data-input=".image_thumbnail_1" data-preview=".image_holder_1" data-show=".main_photo_1" data-hide=".pick_button_1" class="lfm btn btn-primary text-light">
                                    <i class="fas fa-camera-retro"></i> Choose
                                </a>
                             </span>
                            </div>
                        </div>
                    </div>
                @endif
            </div>

            <div class="form-group col-lg-12">
                <a href="#" class="btn btn-primary btn-block add_service"><i class="fa fa-plus"></i> {{ __('halls.added_services') }}</a>
            </div>

            <div class="border-item photos col-md-12 other_image_container">
                <div class="row">
                    @if ($hall ?? false)
                        @foreach ($hall['images'] as $photo)
                            <div class="col-md-4">
                                <div class="items">
                                    <div class="img">
                                        <a href="{{ asset($photo ?? '')}}" data-fancybox="gallery"><img src="{{ asset($photo ?? '')}}" alt=""></a>
                                    </div>
                                    <input type="hidden" name="images[]" value="{{ $photo ?? "" }}">
                                    <a href="#" class="close"><i class="fas fa-times"></i></a>
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>
                <div class="text-center">
                    <input id="other_image_thumbnail" class="other_image_thumbnail" type="hidden"/>
                    <div class="clearfix"></div>
                    <span id="add">
                    <a id="lfm" data-width="" data-cache="article_gallery" data-input=".other_image_thumbnail" data-preview="" data-show="" data-hide="" class="lfm add">
                        Add New Item
                    </a>
                </span>
                </div>
            </div>
            <div class="text-center mt-5 col-12">
                <button class="butn add_hall_button"><span>{{ __('dashboard.save') }}</span></button>
            </div>
        </form>
    </div>

    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">{{__('halls.choose_your_location')}}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div style="border:0; height: 400px; width: 100%" class="map" id="map"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="butn color small save_location"><span>{{__('halls.save_location')}}</span></button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('inner_js')
    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{--    <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        var route_prefix = "{{ url(config('lfm.prefix')) }}";
        var url = "{{url('/')}}/",
            currentLanguage = "{{$local}}",
            inputName = '',
            unavailable_dates_to = "{{__('halls.unavailable_dates_to')}}",
            unavailable_dates_from = "{{__('halls.unavailable_dates_from')}}",
            discount_dates_to = "{{__('halls.discount_dates_to')}}",
            discount = "{{__('halls.discount')}}",
            discount_dates_from = "{{__('halls.unavailable_dates_from')}}",
            discount_dates = "{{__('halls.discount_dates')}}",
            discount_percentage = "{{__('halls.discount_percentage')}}";
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>
    <script src="{{ asset('assets/admin/js/articles.js') }}"></script>

    <script src="https://polyfill.io/v3/polyfill.min.js?features=default"></script>
    <script defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDpVcBEVHKN5-iO0-z5MoEeLLpfV18JZjg&callback=initMap"></script>

    <script>

        let latitude = null,
            longitude = null;
        if (navigator.geolocation) {
            navigator.geolocation.watchPosition(function (position) {
                // let lat = $('input.latitude'),
                //     lng = $('input.longitude');
                // latitude = lat.val(parseFloat(position.coords.latitude));
                // longitude = lng.val(parseFloat(position.coords.longitude));
                latitude = parseFloat(position.coords.latitude);
                longitude = parseFloat(position.coords.longitude);
                localStorage.setItem('lat', latitude);
                localStorage.setItem('lng', longitude);
            });

            latitude = localStorage.getItem('lat');
            longitude = localStorage.getItem('lng');
        } else {
            alert('Geolocation is not supported by this browser')
        }

        latitude = localStorage.getItem('lat') ? localStorage.getItem('lat') : 24.676128352012547;
        longitude = localStorage.getItem('lng') ? localStorage.getItem('lng') : 46.742963671874996;

        var marker;
        var save_location = $('.save_location');

        function initMap() {
            var map = new google.maps.Map(document.getElementById("map"), {
                zoom: 7,
                center: { lat: parseFloat(latitude), lng: parseFloat(longitude) }
            });

            marker = new google.maps.Marker({
                map: map,
                draggable: true,
                animation: google.maps.Animation.DROP,
                position: { lat: parseFloat(latitude), lng: parseFloat(longitude) }

            });

            marker.addListener("dragend", function (map) {
                let lat = map.latLng.lat(), lng = map.latLng.lng();
                localStorage.setItem('lat', lat);
                localStorage.setItem('lng', lng);
                var geocoder = new google.maps.Geocoder();
                var infowindow = new google.maps.InfoWindow();

                google.maps.event.addListener(marker, 'dragend', function() {
                    infowindow.close();
                });

                var latlng = { lat: parseFloat(lat), lng: parseFloat(lng) };
                geocoder.geocode({ location: latlng }, function(results, status) {
                    if (status === "OK") {
                        if (results[0]) {
                            infowindow.setContent(results[0].formatted_address);
                            infowindow.open(map, marker);
                            $('input[name="street"]').val(results[0].formatted_address);
                        } else {
                            window.alert("No results found");
                        }
                    } else {
                        window.alert("Geocoder failed due to: " + status);
                    }
                });
                if (marker.getAnimation() !== null) {
                    marker.setAnimation(null);
                } else {
                    marker.setAnimation(google.maps.Animation.BOUNCE);
                }
            });
        }

        save_location.click(function (map) {
            let lat = localStorage.getItem('lat'),
                lng = localStorage.getItem('lng');
            localStorage.setItem('lat', lat);
            localStorage.setItem('lng', lng);
            $('input[name="lat"]').val(lat);
            $('input[name="lng"]').val(lng);
            var geocoder = new google.maps.Geocoder();
            var infowindow = new google.maps.InfoWindow();

            var latlng = { lat: parseFloat(lat), lng: parseFloat(lng) };
            geocoder.geocode({ location: latlng }, function(results, status) {
                if (status === "OK") {
                    if (results[0]) {
                        infowindow.setContent(results[0].formatted_address);
                        infowindow.open(map, marker);
                        $('input[name="street"]').val(results[0].formatted_address);

                    } else {
                        window.alert("No results found");
                    }
                } else {
                    window.alert("Geocoder failed due to: " + status);
                }
            });
            if (marker.getAnimation() !== null) {
                marker.setAnimation(null);
            } else {
                marker.setAnimation(google.maps.Animation.BOUNCE);
            }

            $('.modal').modal('hide')
        });

        let getCityAndSectorRoute = "{{route('halls.getCityAndSector')}}",
            availableDatesFrom = [],
            availableDatesTo = [],
            availableDates = [];

        localStorage.setItem('articleGallery', null);
        localStorage.setItem('oldArticleStorage', null);


        $('.add_service').click(function (e) {
            e.preventDefault();
            let counter = (Math.random()*100000).toString(20).replace('.', '_');
            let serviceDiv = `
                <div class="form-group col-lg-12 card deleted_service service_card">
                        <label>{{ __('halls.added_services') }}</label>
                       <div class="row">
                       <div class="form-group col-md-12 d-flex justify-content-end">
                       <a href="#" class="btn btn-danger delete_service mr-3"><i class="fa fa-trash-alt"></i></a>
                       </div>
                         <div class="form-group col-md-6">
                            <input type="text" name="added_services_name[]" placeholder="{{__('halls.added_services_name')}}" class="form-control" value=""/>
                        </div>
                        <div class="form-group col-md-6">
                            <input type="number" min="1" name="added_services_price[]"  placeholder="{{__('halls.added_services_price')}}" class="form-control" value=""/>
                        </div>
                        <div class="from-group col-md-12">
                            <textarea name="added_services_description[]"  placeholder="{{__('halls.added_services_description')}}" class="form-control" cols="30" rows="5"></textarea>
                        </div>
                         <div class="form-group col-lg-12">
                                <label>{{ __('halls.added_services_image') }} </label>
                                <input id="image_thumbnail_`+counter+`" class="image_thumbnail_`+counter+`" type="hidden" name="added_services_image[]" value=""/>

                                <div class="photos main_photo_`+counter+` hide">
                                    <div class="col-lg-4">
                                        <div class="items">
                                            <div class="img">
                                                <a href="#" id="lfm" data-input=".image_thumbnail_`+counter+`" data-preview=".image_holder_`+counter+`" class="lfm" data-hide=".pick_button_`+counter+`">
                                                    <img src="" id="image_holder_`+counter+`" class="image_holder_`+counter+`"/>
                                                </a>
                                            </div>
                                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail_`+counter+`" data-hide=".main_photo_`+counter+`" data-show=".pick_button_`+counter+`"><i class="fas fa-times"></i></a>
                                        </div>
                                    </div>
                                </div>

                                <div class="clearfix"></div>
                                <span class="input-group-btn pick_button_`+counter+`">
                                <a id="lfm" data-input=".image_thumbnail_`+counter+`" data-preview=".image_holder_`+counter+`" data-show=".main_photo_`+counter+`" data-hide=".pick_button_`+counter+`" class="lfm btn btn-primary text-light">
                                    <i class="fas fa-camera-retro"></i> Choose
                                </a>
                             </span>
                            </div>
                       </div>
                    </div>`;

            $('.service_container').append(serviceDiv);

        });

        $(document).on('click', '.delete_service', function (e) {
            e.preventDefault();
            $(this).parents('.deleted_service').remove();
        });

        $('.add_hall_button').click(async function (e) {
            e.preventDefault();

            $(this).prop('disabled', true);

            let form = $('.add_hall_from'),
                data = new FormData(form[0]),
                url = form.attr('action'),
                method = form.attr('method');

            $('.discount_dates_input').each(function () {
                if ($(this).prop('checked') === false){
                    data.append('discount_dates[]', 0);
                    data.append('discount_percentage[]', 'empty');
                } else {
                    data.append('discount_dates[]', 1);
                    let inputSibling = $(this).siblings('.discount_percentage');
                    data.append('discount_percentage[]', inputSibling.val());

                }});


            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.url){
                window.location.href = response.url;
            }

            if (response.errors){
                $(this).prop('disabled', false);
                toasterError(response.errors);
            }


        });

        $(document).on('click', '.active_hall' , async function (e) {
            e.preventDefault();
            let url = $(this).data('href'),
                method = 'get';

            const response=await ajax({
                url,
                dataType: 'json',
                method,
            });
            if (response.message) {
                $(this).children('i').toggleClass('fa-check text-success fa-times text-danger')

            }
        });

        $('select[name="region_id"], select[name="city_id"]').change(async function (e) {
            e.preventDefault();

            let data = {},
                url = getCityAndSectorRoute,
                method = 'get';

            if($(this).attr('name') === 'region_id'){
                $('select[name="city_id"]').html(`<option value="">{{ __('halls.city_id') }}</option>`);
                $('select[name="sector_id"]').html(`<option value="">{{ __('halls.sector_id') }}</option>`);

                data.region_id = $(this).val();
            }
            if($(this).attr('name') === 'city_id'){
                $('select[name="sector_id"]').html(`<option value="">{{ __('halls.sector_id') }}</option>`);
                data.city_id = $(this).val();
            }

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.status === 'city'){
                if (response.data.length){
                    for (let i = 0; i < response.data.length; i++){
                        $('select[name="city_id"]').append(`<option value="`+response.data[i].id+`">`+response.data[i].name+`</option>`)
                    }
                }
            }
            if (response.status === 'sector'){
                if (response.data.length){
                    for (let i = 0; i < response.data.length; i++){
                        $('select[name="sector_id"]').append(`<option value="`+response.data[i].id+`">`+response.data[i].name+`</option>`)
                    }
                }
            }

            if (response.errors){
                toasterError(response.errors);
            }


        });

        let reservation_type = $('select[name="reservation_type"] option:selected').val();
        if(reservation_type === 'person_count'){
            $('.booking_amount_per_person').removeClass('d-none');
            $('.booking_amount_per_day').addClass('d-none');
            $('.booking_amount_per_day input').val('');
        }
        if(reservation_type === 'days_count'){
            $('.booking_amount_per_day').removeClass('d-none');
            $('.booking_amount_per_person').addClass('d-none');
            $('.booking_amount_per_person input').val('');
        }

        $('select[name="reservation_type"]').change(function () {
            if($(this).val() === 'person_count'){
                $('.booking_amount_per_person').removeClass('d-none');
                $('.booking_amount_per_day').addClass('d-none');
                $('.booking_amount_per_day input').val('');
            }
            if($(this).val() === 'days_count'){
                $('.booking_amount_per_day').removeClass('d-none');
                $('.booking_amount_per_person').addClass('d-none');
                $('.booking_amount_per_person input').val('');
            }
        });

        $('input[name="date_search"]').change(function () {
            let searchDate = $(this).val();
            if(searchDate !== ''){
                searchDate = new Date(searchDate).toDateString();
                $('.deleted_available_dates_container').each(function () {
                    let dateFrom = $(this).children('.form-group').children('.available_dates_from').val(),
                        dateTo = $(this).children('.form-group').children('.available_dates_to').val();
                    dateFrom = new Date(dateFrom).toDateString();
                    dateTo = new Date(dateTo).toDateString();
                    if(searchDate === dateFrom || searchDate === dateTo){
                        $(this).removeClass('d-none');
                    }
                    if(searchDate !== dateFrom && searchDate !== dateTo){
                        $(this).addClass('d-none');
                    }
                })
            } else {
                $('.deleted_available_dates_container').removeClass('d-none')
            }

        })

        //    ##########################################

        // Un Available days block
        $('.add_unavailable_dates_link').click(function (e) {
            e.preventDefault();
            $($(this).data('target')).append(`
            <div class="row justify-content-start align-items-center align-content-center unavailable_date_item">
                <div class="form-group col-md-2">
                    <a class="btn btn-danger delete_unavailable_date_link" href="#"><i class="fa fa-times"></i></a>
                </div>
                <div class="form-group col-md-5">
                    <input type="text" placeholder="${unavailable_dates_from}" name="unavailable_dates_from[]" value="" class="my_datepicker form-control">
                </div>
                <div class="form-group col-md-5">
                    <input type="text" placeholder="${unavailable_dates_to}" name="unavailable_dates_to[]" value="" class="my_datepicker form-control">
                </div>
            </div>
            `);
        });

        $(document).on('click', '.delete_unavailable_date_link', function(e){
            e.preventDefault();
            $(this).parents('.unavailable_date_item').remove();
        });

        // Discount dates block
        $('.add_discount_dates_link').click(function (e) {
            e.preventDefault();
            let counter = (Math.random()*100000).toString(20).replace('.', '_');
            $($(this).data('target')).append(`
    <div class="row align-items-center discount_date_item">
        <div class="form-group col-md-1">
            <a class="btn btn-danger delete_discount_date_link" href="#"><i class="fa fa-times"></i></a>
        </div>
        <div class="form-group col-md-3">
            <input type="text" placeholder="${discount_dates_from}" name="discount_dates_from[]" value="" class="my_datepicker form-control">
        </div>
        <div class="form-group col-md-3">
            <input type="text" placeholder="${discount_dates_to}" name="discount_dates_to[]" value="" class="my_datepicker form-control">
        </div>
        <div class="form-group col-md-5">
            <div class="custom-control custom-checkbox">
                <div class="discount_dates_container d-flex justify-content-start align-content-center align-items-center custom-control_3">
                <input name="discount_percentage[]" type="number" min="1" pattern="/[1-9]/" class="discount_percentage col-md-8 form-control" placeholder="${discount_percentage}" value="">
                </div>
            </div>
        </div>
    </div>
`);
        });

        $(document).on('click', '.delete_discount_date_link', function(e){
            e.preventDefault();
            $(this).parents('.discount_date_item').remove();
        });

        $('body').on('DOMNodeInserted', '.service_container', function(e) {
            if ($(e.target).find('.lfm')) {
                $('.lfm').filemanager('image', {prefix: route_prefix});
            }
        });

        $('body').on('DOMNodeInserted', '.unavailable_dates_container_person, .unavailable_dates_container_days, .discount_dates_container_person, .discount_dates_container_days', function(e) {
            if ($(e.target).find('.unavailable_date_item, .discount_date_item')) {
                $('.my_datepicker').datepicker({
                    beforeShowDay: disablePrevDays,
                    minDate: new Date(),
                    onClose : closeFunction ,
                    format: 'mm/dd/yyyy',
                })
            }
        });

        $('.my_datepicker').datepicker({
            beforeShowDay: disablePrevDays,
            minDate: new Date(),
            onClose : closeFunction ,
            format: 'mm/dd/yyyy',
        });


        function closeFunction(date){
            let dateObject = new Date(),
                year = dateObject.getFullYear(),
                month = dateObject.getMonth()+1,
                day = dateObject.getDate();

            month = month < 10 ? '0'+month : month;
            day = day < 10 ? '0'+day : day;
            let inputDate = date.split('/');

            if (inputDate[2] < year){
                this.value = '';
                console.log('inputDate[2] < year');
                return false
            }
            if (inputDate[2] == year && inputDate[0] < month){
                this.value = '';
                return false
            }
            if (inputDate[2] == year && inputDate[0] == month && inputDate[1] < day){
                this.value = '';
                return false;
            }




        }
        function disablePrevDays(date){
            let dateObject = new Date(),
                year = dateObject.getFullYear(),
                month = dateObject.getMonth()+1,
                day = dateObject.getDate();

            if (date.getFullYear() < year){
                return [ false, "closed", "Closed on Monday" ]
            }
            if (date.getFullYear() < year && (date.getMonth()+1) < month){
                return [ false, "closed", "Closed on Monday" ]
            }
            if (date.getFullYear() < year && (date.getMonth()+1) < month && date.getDate() < day){
                return [ false, "closed", "Closed on Monday" ]
            }
            return [ true, "", "" ]
        }

    </script>

@endsection


