@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($contract ?? ''  && $contract->id)
            @method('PUT')
        @endif
        @csrf

        @foreach($languages as $language)
        <div class="form-group col-lg-12">
            <label>{{ meta('text', $language->local) ?? __('abouts.text') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <textarea name="text_{{ $language->local }}" class="form-control my-editor {{ $errors->has('text_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('text', $language->local) ?? __('abouts.text') }}">{{ old("text_{$language->local}", $contract[$language->local]->text ?? "") }}</textarea>
        </div>
        @endforeach

        <div class="text-center mt-5 col-12">
            <button class="butn"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{--        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{getCurrentLocale()}}",
            imagePath = "{{asset('')}}",
            inputName = "";
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>
@endsection


