@extends('admin.layouts.container')

@section('content')
    <div class="side-title">
        <h3>{{$head ?? '' }}</h3>
    </div>

    <div class="border-item">
        <form class="form-row">
            <div class="form-group col-lg-4">
                <label>{{ meta('user_id', getCurrentLocale()) ?? __('comments.user_id') }} </label>
                <input type="text" class="form-control" value='{{ $comment->user_name }}'/>
            </div>
            <div class="form-group col-lg-4">
                <label>{{ meta('hall_name', getCurrentLocale()) ?? __('comments.hall_name') }} </label>
                <input type="text" class="form-control" value='{{ $comment->hall_name }}'/>
            </div>
            <div class="form-group col-lg-2">
                <label>{{ meta('evaluate_average', getCurrentLocale()) ?? __('comments.evaluate_average') }}</label>
                <input type="text" class="form-control" value='{{ $comment->evaluate_average }}'/>
            </div>
            <div class="form-group col-lg-2">
                <label>{{ __('comments.status') }}</label>
                <a style="cursor: pointer" class="active_comment icon form-control text-center" data-href="{{route('comments.activeComment', $comment->id)}}">
                    <i class="fa fa-2x {{$comment->status ? 'fa-check text-success' : 'fa-times text-danger'}}"></i>
                </a>
            </div>
            <div class="form-group col-lg-12">
                <label>{{ meta('comment', getCurrentLocale()) ?? __('comments.comment') }} </label>
                <textarea class="form-control">{{ $comment->comment}}</textarea>
            </div>
        </form>
    </div>

@endsection

@section('inner_js')
    <script>
        $(document).ready(function () {
            $(document).on('click', '.active_comment' , async function (e) {
                e.preventDefault();
                let url = $(this).data('href'),
                    method = 'get';

                const response=await ajax({
                    url,
                    dataType: 'json',
                    method,
                });
                if (response.message) {
                    $(this).children('i').toggleClass('fa-check text-success fa-times text-danger')

                }
            });
        });

    </script>
@endsection



