@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>
<div class="border-item">
    <form class="form-row" method="post" action="{{ $action }}">
        @if($city ?? ''  && $city->id)
            @method('PUT')
        @endif
        @csrf

        <div class="form-group col-lg-4">
            <label>{{ meta('region_id', getCurrentLocale()) ?? __('regions.region_id') }} </label>
            <select name="region_id" class="form-control {{ $errors->has('region_id') ? 'is-invalid' : '' }}">
                <option value="">{{ meta('region_id', getCurrentLocale()) ?? __('regions.region_id') }}</option>
                @if(count($regions))
                    @foreach($regions as $region)
                        <option {{old('region_id', $city->region_id ?? null) == $region->id ? 'selected' : ''}} value="{{$region->id}}">{{$region->name}}</option>
                    @endforeach
                @endif
            </select>
        </div>

        @foreach($languages as $language)
        <div class="form-group col-lg-4">
            <label>{{ meta('name', $language->local) ?? __('regions.name') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('name_'.$language->local) ? 'is-invalid' : '' }}" name="name_{{ $language->local }}" placeholder="{{ meta('name', $language->local) ?? __('regions.name') }}" value='{{ old("name_{$language->local}", $city[$language->local]->name ?? "") }}'/>
        </div>
        @endforeach

            {{--Start image container--}}
            <div class="form-group col-lg-12">
                <label>{{ meta('photo', getCurrentLocale()) ?? __('cities.photo') }} </label>
                <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="photo" value="{{old("photo", $city->photo ?? "")}}"/>

                <div class="photos main_photo {{ old('photo', $city->photo ?? '') ? ' wow fadeInUp' : 'hide' }}">
                    <div class="col-lg-4">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="{{asset(old('photo', $city->photo ?? ''))}} "  id="image_holder" class="image_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn pick_button {{ old('photo', $city->photo ?? '') ? 'hide' : '' }} ">
                    <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                        <i class="fas fa-camera-retro"></i> Choose
                    </a>
                </span>
            </div>
            {{--End image container--}}

        <div class="text-center mt-5 col-12">
            <button class="butn"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
        <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
{{--    <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            imagePath = "{{asset('')}}",
            currentLanguage = "{{getCurrentLocale()}}",
            inputName = null;
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>
@endsection

