@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>
<div class="border-item">
    <form class="form-row" method="post" action="{{ $action }}">
        @if($category ?? ''  && $category->id)
            @method('PUT')
        @endif
        @csrf
        @foreach($languages as $language)
        <div class="form-group col-lg-6">
            <label>{{ meta('name', $language->local) ?? __('articles.name') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('name_'.$language->local) ? 'is-invalid' : '' }}" name="name_{{ $language->local }}" placeholder="{{ meta('name', $language->local) ?? __('articles.name') }}" value='{{ old("name_{$language->local}", $category[$language->local]->name ?? "") }}'/>
        </div>
        @endforeach

        <div class="text-center mt-5 col-12">
            <button class="butn"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection
