@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($about ?? ''  && $about->id)
            @method('PUT')
        @endif
        @csrf

        <div class="form-group col-lg-12">
            <label>{{ meta('video', $local) ?? __('abouts.video') }} </label>
            <input type="url" class="form-control {{ $errors->has('video') ? 'is-invalid' : '' }}" name="video" placeholder="{{ meta('video', $local) ?? __('abouts.video') }}" value='{{ old("video", $about->video ?? "") }}'/>
        </div>
        @foreach($languages as $language)
        <div class="form-group col-lg-12">
            <label>{{ meta('title', $language->local) ?? __('abouts.title') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('title_'.$language->local) ? 'is-invalid' : '' }}" name="title_{{ $language->local }}" placeholder="{{ meta('title', $language->local) ?? __('abouts.title') }}" value='{{ old("title_{$language->local}", $about[$language->local]->title ?? "") }}'/>
        </div>
        <div class="form-group col-lg-12">
            <label>{{ meta('about_us_list', $language->local) ?? __('abouts.about_us_list') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <textarea name="about_us_list_{{ $language->local }}" class="form-control  {{ $errors->has('about_us_list_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('about_us_list', $language->local) ?? __('abouts.about_us_list') }}">{{ old("about_us_list_{$language->local}", $about[$language->local]->about_us_list ?? "") }}</textarea>
        </div>
        <div class="form-group col-lg-12">
            <label>{{ meta('why_us_first_title', $language->local) ?? __('abouts.why_us_first_title') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('why_us_first_title_'.$language->local) ? 'is-invalid' : '' }}" name="why_us_first_title_{{ $language->local }}" placeholder="{{ meta('why_us_first_title', $language->local) ?? __('abouts.why_us_first_title') }}" value='{{ old("why_us_first_title_{$language->local}", $about[$language->local]->why_us_first_title ?? "") }}'/>
        </div>
        <div class="form-group col-lg-12">
            <label>{{ meta('why_us_second_title', $language->local) ?? __('abouts.why_us_second_title') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('why_us_second_title_'.$language->local) ? 'is-invalid' : '' }}" name="why_us_second_title_{{ $language->local }}" placeholder="{{ meta('why_us_second_title', $language->local) ?? __('abouts.why_us_second_title') }}" value='{{ old("why_us_second_title_{$language->local}", $about[$language->local]->why_us_second_title ?? "") }}'/>
        </div>
        <div class="form-group col-lg-12">
            <label>{{ meta('why_us_third_title', $language->local) ?? __('abouts.why_us_third_title') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('why_us_third_title_'.$language->local) ? 'is-invalid' : '' }}" name="why_us_third_title_{{ $language->local }}" placeholder="{{ meta('why_us_third_title', $language->local) ?? __('abouts.why_us_third_title') }}" value='{{ old("why_us_third_title_{$language->local}", $about[$language->local]->why_us_third_title ?? "") }}'/>
        </div>
        <div class="form-group col-lg-12">
            <label>{{ meta('description', $language->local) ?? __('abouts.description') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <textarea name="description_{{ $language->local }}" class="form-control my-editor {{ $errors->has('description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('description', $language->local) ?? __('abouts.description') }}">{{ old("description_{$language->local}", $about[$language->local]->description ?? "") }}</textarea>
        </div>
        <div class="form-group col-lg-12">
            <label>{{ meta('why_us_first_description', $language->local) ?? __('abouts.why_us_first_description') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <textarea name="why_us_first_description_{{ $language->local }}" class="form-control my-editor {{ $errors->has('why_us_first_description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('why_us_first_description', $language->local) ?? __('abouts.why_us_first_description') }}">{{ old("why_us_first_description_{$language->local}", $about[$language->local]->why_us_first_description ?? "") }}</textarea>
        </div>

        <div class="form-group col-lg-12">
            <label>{{ meta('why_us_second_description', $language->local) ?? __('abouts.why_us_second_description') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <textarea name="why_us_second_description_{{ $language->local }}" class="form-control my-editor {{ $errors->has('why_us_second_description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('why_us_second_description', $language->local) ?? __('abouts.why_us_second_description') }}">{{ old("why_us_second_description_{$language->local}", $about[$language->local]->why_us_second_description ?? "") }}</textarea>
        </div>
        <div class="form-group col-lg-12">
            <label>{{ meta('why_us_third_description', $language->local) ?? __('abouts.why_us_third_description') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <textarea name="why_us_third_description_{{ $language->local }}" class="form-control my-editor {{ $errors->has('why_us_third_description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('why_us_third_description', $language->local) ?? __('abouts.why_us_third_description') }}">{{ old("why_us_third_description_{$language->local}", $about[$language->local]->why_us_third_description ?? "") }}</textarea>
        </div>
        @endforeach


        {{--Start consultation image container--}}
        <div class="form-group col-lg-4">
            <label>{{ meta('image', getCurrentLocale()) ?? __('abouts.image') }} </label>
            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $about->image ?? "")}}"/>

            <div class="photos over_view_main_photo {{ old('image', $about->image ?? '') ? ' wow fadeInUp' : 'hide' }}">
                <div class="col-lg-12">
                    <div class="items">
                        <div class="img">
                            <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".over_view_pick_button">
                                <img src="{{asset(old('image', $about->image ?? ''))}} "  id="image_holder" class="image_holder"/>
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".why_us_main_photo" data-show=".why_us_pick_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn why_us_pick_button {{ old('image', $about->image ?? '') ? 'hide' : '' }} ">
                <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".why_us_main_photo" data-hide=".why_us_pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> Choose
                </a>
            </span>
        </div>
        {{--End why us image container--}}


        <div class="text-center mt-5 col-12">
            <button class="butn"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{--        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{getCurrentLocale()}}",
            imagePath = "{{asset('')}}",
            inputName = "";
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>
    <script src="{{ asset('assets/admin/js/articles.js') }}"></script>
@endsection


