<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Verification extends Model
{
    protected $fillable = ['user_id', 'email', 'type', 'code'];


    /**
     * Return user to verification
     * @return BelongsTo
     */
    public function user() :BelongsTo
    {
        return $this->belongsTo(User::class)->whereIn('role', ['user', 'provider']);
    }
}
