<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UsersNotification extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'title',
        'message',
        'user_id',
        'send_to',
        'is_read',
        'notification_type',
        'page_link',
        ];

    protected $casts = ['is_read' => 'array'];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
