<?php

namespace App;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;


/**
 * @property mixed role
 * @property mixed modules
 * @property mixed password
 * @property mixed website_percentage
 * @property mixed device_token
 */
class User extends Authenticatable
{
    use Notifiable;
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'email',
        'code',
        'phone',
        'photo',
        'verify_code',
        'attempt_send_code',
        'last_attempt_date',
        'code_verify_attempt',
        'device_token',
        'api_token',
        'region_id',
        'city_id',
        'sector_id',
        'street',
        'commercial_file',
        'bank_acc_info',
        'logo',
        'agreement',
        'email_receive',
        'website_percentage',
        'contract_agreement',
        'contract_agreement_date',
        'password',
        'role',
        'status',
        'email_verified_at',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token'
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'bank_acc_info' => 'array',
        'device_token' => 'array',
    ];




    /**
     * Specifies the user's FCM token
     *
     * @return string|array
     */
    public function routeNotificationForFcm()
    {
//        return $this->getDeviceTokens();
        return is_string($this->device_token) ? json_decode($this->device_token, true)['token'] : ($this->device_token['token'] ?? null);
    }

    /**
     * Get the modules of this user
     * @return BelongsToMany
     */
    public function modules() :BelongsToMany
    {
        return $this->belongsToMany(Module::class,'user_modules');
    }

    /**
     * Check if the user can access a module
     * @param string, module name
     * @return bool
     */
    public function hasModule($module) :bool
    {
        if($this->modules->contains('path',$module))
        {
            return true;
        }
        return false;
    }

    /**
     * Check if the user can access a module
     * @param string, module name
     * @return bool
     */
    public function canAccess($module)
    {
        if ($this->role == 'super_admin') {
            return true;
        } else {
            return $this->hasModule($module);
        }
        return false;
    }

    public function orders()
    {
        return $this->hasMany(Order::class);
    }

    public function verifications()
    {
        return $this->hasMany(Verification::class);
    }

    public function evaluates()
    {
        return $this->hasMany(Evaluate::class);
    }

    public function reservations()
    {
        return $this->hasMany(Reservation::class);
    }

    public function halls()
    {
        return $this->hasMany(Hall::class);
    }

}
