<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Table
 * @package App
 * @mixin Builder
 */
class Table extends Model
{
    use SoftDeletes;

    protected $fillable = ['image'];

    public static function withDescription($ids = [])
    {
        $languageId = currentLanguage()->id;
        $tables = self::orderBy('tables.id', 'desc')->join('table_descriptions as tDesc', 'tDesc.table_id', 'tables.id')
            ->where('tDesc.language_id', $languageId);


        if (count($ids)){
            $tables->whereIn('tables.id', $ids);
        }

        $tables->select(
            [
                'tables.id',
                'tables.image',
                'tDesc.name',
            ]
        );

        return $tables->cursor();

    }

}
