<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Slider extends Model
{
    use SoftDeletes;

    public static function withDescription()
    {
        return self::join('slider_descriptions as sd', 'sd.slider_id', 'sliders.id')
            ->where('sd.language_id', currentLanguage()->id)
            ->select(['sd.title', 'sd.description'])->cursor();
    }
}
