<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;

class Service extends Model
{
    // For soft delete
    use SoftDeletes;

    protected $fillable = ['service_type', 'image', 'price'];


    public static function withDescription($servicesId = null, $serviceType = null)
    {
        $services = self::join('service_descriptions as sd', 'sd.service_id', 'services.id')
            ->where('sd.language_id', currentLanguage()->id);

        if (is_array($servicesId) && count($servicesId)){
            $services->whereIn('services.id', $servicesId);
        } elseif($servicesId) {
            $services->where('services.id', $servicesId);
        }

        if ($serviceType){
            $services->where('services.service_type', $serviceType);
        }

        $services->select([
            'services.*',
            'sd.name',
            'sd.description',
        ]);

        return ($servicesId && !is_array($servicesId)) ? $services->first() : $services->get() ?? [];
    }

    /**
     * Get description of current language of The Category
     * @return HasOne
     */
    public function currentDescription() :HasOne
    {
        return $this->hasOne(ServiceDescription::class)->where('language_id', currentLanguage()->id);
    }

    /**
     * Get the description of the service.
     * @param int $language_id
     * @return HasMany
     */
    public function descriptions($language_id= 0) :HasMany
    {
        if ($language_id) {
            return $this->hasMany(ServiceDescription::class)->where('language_id', $language_id);
        }
        return $this->hasMany(ServiceDescription::class);
    }
}
